<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-8">
        <h2><?= print_lang($app_lang,'mod_branch_to_branch_transfer_view_breadcrumb'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'mod_branch_to_branch_transfer_view_breadcrumb'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-4">
        <div class="title-action">
            <?php if(check_user_access('add_assets') === TRUE){ ?>
                <a href="<?php echo url('/b-to-b-transfer/add'); ?>" class="btn btn-primary btn-sm custom-font-btn"><i class="fa fa-plus"></i>&nbsp; <?= print_lang($app_lang,'add_new_asset'); ?></a>
            <?php } ?>
        </div>
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'mod_branch_to_branch_transfer_view_title'); ?></h2>
                    
                    <form id="b-to-b-transfer-form" action="<?= url('/b-to-b-transfer'); ?>">
                    <div class="row">
                        <div class="col-md-10">
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" name="from" value="<?= $search_from; ?>" placeholder="<?= print_lang($app_lang,'from'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="from" value="<?= $search_from; ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" name="to" value="<?= $search_to; ?>" placeholder="<?= print_lang($app_lang,'to'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="to" value="<?= $search_to; ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-2 text-right">
                            <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                        </div>
                    </div>
                    </form>

                    <hr>

                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center" style="min-width:50px; max-width:50px;"><?= print_lang($app_lang,'mod_branch_to_branch_transfer_view_thead_sr'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_branch_to_branch_transfer_view_thead_date'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_branch_to_branch_transfer_view_thead_item'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_branch_to_branch_transfer_view_thead_warehouse'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_branch_to_branch_transfer_view_thead_unit'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_branch_to_branch_transfer_view_thead_batch'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_branch_to_branch_transfer_view_thead_qty'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_branch_to_branch_transfer_view_thead_to_branch'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_branch_to_branch_transfer_view_thead_to_warehouse'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_branch_to_branch_transfer_view_thead_details'); ?></th>
                                    <th class="text-center" style="min-width:120px; max-width:120px;"><?= print_lang($app_lang,'mod_branch_to_branch_transfer_view_thead_action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $i = 1; foreach($pageData as $row){
                                    $item_data = array_key_exists($row['item'], $items) ? $items[$row['item']] : NULL;

                                    if($row['unit'] == 'sale')
                                    {
                                        $item_unit = $item_data['sale_unit'];
                                    }
                                    else if($row['unit'] == 'production')
                                    {
                                        $item_unit = $item_data['production_unit'];
                                    }
                                    else
                                    {
                                        $item_unit = $item_data['purchase_unit'];
                                    }
                                ?>
                                    <tr class="text-center">
                                        <td><?= $i++; ?></td>
                                        <td><?= display_true_date(explode(' ',$row['t_date'])[0]); ?></td>
                                        <td><?= array_key_exists($row['item'], $items) ? $items[$row['item']]['name'] : NULL; ?></td>
                                        <td><?= array_key_exists($row['warehouse'], $warehouses) ? $warehouses[$row['warehouse']]['name'] : NULL; ?></td>
                                        <td><?= array_key_exists($item_unit, $units) ? $units[$item_unit]['name'] : NULL; ?></td>
                                        <td><?= $row['batch']; ?></td>
                                        <td><?= $row['qty']; ?></td>
                                        <td><?= array_key_exists($row['to_branch'], $branches) ? $branches[$row['to_branch']]['branch_name'] : NULL; ?></td>
                                        <td><?= array_key_exists($row['to_warehouse'], $warehouses) ? $warehouses[$row['to_warehouse']]['name'] : NULL; ?></td>
                                        <td><?= $row['details']; ?></td>
                                        <td>
                                            <?php if(check_user_access('edit_assets') === TRUE){ ?>
                                                <a href="<?= url('/b-to-b-transfer/edit').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-primary url-elem"><i class="fa fa-pencil">&nbsp; </i><?= print_lang($app_lang,'edit'); ?></a>
                                            <?php } ?>
                                            <?php if(check_user_access('delete_assets') === TRUE){ ?>
                                                <a href="<?= url('/b-to-b-transfer/delete').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-danger delete-btn-trigger"><i class="fa fa-trash"></i>&nbsp; <?= print_lang($app_lang,'delete'); ?></a>
                                            <?php } ?>
                                        </td>
                                    </tr>
                                <?php } ?>
                            </tbody>
                        </table>    
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>