<!DOCTYPE html>
<html>

<head>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="shortcut icon" type="image/png" href="<?= url('/assets/img/favicon.png'); ?>"/>

    <title>Select Branch | <?= Config::get('constants.title'); ?></title>

    <link href="<?= url('/'); ?>/assets/css/bootstrap.min.css" rel="stylesheet">
    <link href="<?= url('/'); ?>/assets/font-awesome/css/font-awesome.css" rel="stylesheet">
    <link href="<?= url('/'); ?>/assets/css/animate.css" rel="stylesheet">
    <link href="<?= url('/'); ?>/assets/css/style.css" rel="stylesheet">
    <link href="<?= url('/'); ?>/assets/css/custom.css" rel="stylesheet">

</head>

<body class="gray-bg">

	<div class="wrapper border-bottom" style="width: 90%;margin: 0 auto;">

		<h2 style="text-align: center;margin: 50px 0;font-weight: 400;font-size: 30px;">Select a branch to proceed in</h2>
		
		<div class="row">

			<?php foreach($branches as $row){ ?>
			    <div class="col-md-3">
			        <div class="ibox-content text-center">
			            <div class="m-b-sm">
			            	<?php
			            	$branch_logo = base_path().'/uploads/branches/'.$row['branch_logo'];
			            	if(is_file($branch_logo))
			            	{
			            	    $branch_logo = url('/').'/uploads/branches/'.$row['branch_logo'];
			            	}
			            	else
			            	{
			            	    $branch_logo = url('/assets/img/invoices/select-branch.png');
			            	}
			            	?>
			                <img alt="image" class="img-circle img-md" src="<?= $branch_logo; ?>">
			            </div>
			            <p class="font-bold" style="margin: 25px 0;"><?= $row['branch_name']; ?></p>
			            <div class="text-center">
			                <a href="<?= url('/activate-branch').'/'.$row['uid']; ?>" class="btn btn-sm btn-primary"><i class="fa fa-thumbs-up"></i> Proceed In</a>
			            </div>
			        </div>
			    </div>
			<?php } ?>
			
		</div>

	</div>

    <!-- Mainly scripts -->
    <script src="<?= url('/'); ?>/assets/js/jquery-3.1.1.min.js"></script>
    <script src="<?= url('/'); ?>/assets/js/bootstrap.min.js"></script>

</body>

</html>