<!DOCTYPE html>
<html>

<head>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?= csrf_token(); ?>">
    <link rel="shortcut icon" type="image/png" href="<?= url('/assets/img/favicon.png'); ?>"/>

    <title>Add Branch | <?= Config::get('constants.title'); ?></title>

    <link href="<?= url('/'); ?>/assets/css/bootstrap.min.css" rel="stylesheet">
    <link href="<?= url('/'); ?>/assets/font-awesome/css/font-awesome.css" rel="stylesheet">

    <!-- Toastr style -->
    <link href="<?php echo url('/'); ?>/assets/css/plugins/toastr/toastr.min.css" rel="stylesheet">

    <!-- choose css -->
    <link href="<?php echo url('/'); ?>/assets/css/plugins/chosen/bootstrap-chosen.css" rel="stylesheet">

    <link href="<?= url('/'); ?>/assets/css/animate.css" rel="stylesheet">
    <link href="<?= url('/'); ?>/assets/css/style.css" rel="stylesheet">
    <link href="<?= url('/'); ?>/assets/css/custom.css" rel="stylesheet">

</head>

<body class="gray-bg">

	<h2 style="text-align: center;margin: 50px 0;font-weight: 400;font-size: 30px;">Add New Branch</h2>

	<div class="wrapper wrapper-content animated fadeInRight">
	    <div class="ibox-title">
	        <h5>Fields with <strong class="text-danger">*</strong> are mandatory</h5>
	    </div>
	    <div class="ibox-content">
	        <!-- spinner -->
	        <div class="sk-spinner sk-spinner-three-bounce">
	            <div class="sk-bounce1"></div>
	            <div class="sk-bounce2"></div>
	            <div class="sk-bounce3"></div>
	        </div>
	        <!-- spinner -->
	        <div class="row">
	            <div class="col-sm-12 b-r">
	                <form role="form" id="branches-form" action="<?php echo url('/branches-setup/save'); ?>" enctype="multipart/form-data">

	                    <div class="row extra-mar-botm">
	                        <div class="col-md-4">
	                            <div class="form-group">
	                                <label>Number <strong class="text-danger">*</strong></label>
	                                <input type="text" class="form-control" name="branch_number" placeholder="Branch Number">
	                            </div>
	                        </div>
	                        <div class="col-md-4">
	                            <div class="form-group">
	                                <label>Name <strong class="text-danger">*</strong></label>
	                                <input type="text" class="form-control" name="branch_name" placeholder="Branch Name">
	                            </div>
	                        </div>
	                        <div class="col-md-4">
	                            <div class="form-group">
	                                <label>Mobile <strong class="text-danger">*</strong></label>
	                                <input type="text" class="form-control" name="branch_mobile" placeholder="Branch Mobile">
	                            </div>
	                        </div>
	                    </div>

	                    <div class="row extra-mar-botm">
	                        <div class="col-md-4">
	                            <div class="form-group">
	                                <label>Logo</label>
	                                <input type="file" class="form-control" name="branch_logo">
	                            </div>
	                        </div>
	                        <div class="col-md-4">
	                            <div class="form-group">
	                                <label>Banner For Reports</label>
	                                <input type="file" class="form-control" name="branch_banner_reports">
	                            </div>
	                        </div>
	                        <div class="col-md-4">
	                            <div class="form-group">
	                                <label>Banner For Invoices</label>
	                                <input type="file" class="form-control" name="branch_banner_invoices">
	                            </div>
	                        </div>
	                        <div class="col-md-6">
	                            <div class="form-group">
	                                <label>Banner For Invoices Return</label>
	                                <input type="file" class="form-control" name="branch_banner_return">
	                            </div>
	                        </div>
	                        <div class="col-md-6">
	                            <div class="form-group">
	                                <label>Banner For Bookings</label>
	                                <input type="file" class="form-control" name="branch_banner_bookings">
	                            </div>
	                        </div>
	                    </div>

	                    <div class="row extra-mar-botm">
	                        <div class="col-md-8">
	                            <div class="form-group">
	                                <label>Address <strong class="text-danger">*</strong></label>
	                                <input type="text" class="form-control" name="branch_address" placeholder="Branch Address">
	                            </div>
	                        </div>
	                        <div class="col-md-4">
	                            <div class="form-group">
	                                <label>Language <strong class="text-danger">*</strong></label>
	                                <select class="form-control chosen-select" name="branch_language">
	                                    <option disabled="" selected="">-- Language --</option>
	                                    <?php foreach($languages as $row){ ?>
	                                        <option value="<?= $row['uid']; ?>"><?= $row['name']; ?></option>
	                                    <?php } ?>
	                                </select>
	                            </div>
	                        </div>
	                    </div>

	                    <div class="row extra-mar-botm">
	                        <div class="col-md-12 text-right">
	                            <a class="btn btn-w-m btn-outline btn-danger url-elem" href="<?php echo url('/branches'); ?>">Cancel</a>
	                            <button class="btn btn-w-m btn-primary" type="submit">Save</button>
	                        </div>
	                    </div>

	                </form>
	            </div>
	        </div>
	    </div>

	</div>

    <!-- Mainly scripts -->
    <script src="<?= url('/'); ?>/assets/js/jquery-3.1.1.min.js"></script>
    <script src="<?= url('/'); ?>/assets/js/bootstrap.min.js"></script>

    <!-- Toastr -->
    <script src="<?php echo url('/'); ?>/assets/js/plugins/toastr/toastr.min.js"></script>

    <!-- Jquery Validate -->
    <script src="<?php echo url('/'); ?>/assets/js/plugins/validate/jquery.validate.min.js"></script>

    <!-- Chosen -->
    <script src="<?php echo url('/'); ?>/assets/js/plugins/chosen/chosen.jquery.js"></script>

    <!-- custom js file -->
    <script src="<?php echo url('/'); ?>/assets/js/custom.js"></script>

</body>

</html>
