<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'edit_branch'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/branches'); ?>"><?= print_lang($app_lang,'branches'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'edit_branch'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="ibox-title">
        <h5><?= print_lang($app_lang,'fields_with'); ?> <strong class="text-danger">*</strong> <?= print_lang($app_lang,'are_mandatory'); ?></h5>
    </div>
    <div class="ibox-content">
        <!-- spinner -->
        <div class="sk-spinner sk-spinner-three-bounce">
            <div class="sk-bounce1"></div>
            <div class="sk-bounce2"></div>
            <div class="sk-bounce3"></div>
        </div>
        <!-- spinner -->
        <div class="row">
            <div class="col-sm-12 b-r">
                <form role="form" id="branches-form" action="<?php echo url('/branches/update').'/'.$editing_data['uid']; ?>" enctype="multipart/form-data">

                    <div class="row extra-mar-botm">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'number'); ?> <strong class="text-danger">*</strong></label>
                                <input type="text" class="form-control" name="branch_number" value="<?= $editing_data['branch_number']; ?>" placeholder="<?= print_lang($app_lang,'number'); ?>">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'name'); ?> <strong class="text-danger">*</strong></label>
                                <input type="text" class="form-control" name="branch_name" value="<?= $editing_data['branch_name']; ?>" placeholder="<?= print_lang($app_lang,'name'); ?>">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'mobile'); ?> <strong class="text-danger">*</strong></label>
                                <input type="text" class="form-control" name="branch_mobile" value="<?= $editing_data['branch_mobile']; ?>" placeholder="<?= print_lang($app_lang,'mobile'); ?>">
                            </div>
                        </div>
                    </div>

                    <div class="row extra-mar-botm">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'logo'); ?></label>
                                <input type="file" class="form-control" name="branch_logo">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'banner_for_reports'); ?></label>
                                <input type="file" class="form-control" name="branch_banner_reports">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'banner_for_invoices'); ?></label>
                                <input type="file" class="form-control" name="branch_banner_invoices">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'banner_for_return'); ?></label>
                                <input type="file" class="form-control" name="branch_banner_return">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'banner_for_bookings'); ?></label>
                                <input type="file" class="form-control" name="branch_banner_bookings">
                            </div>
                        </div>
                    </div>

                    <div class="row extra-mar-botm">
                        <div class="col-md-8">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'address'); ?> <strong class="text-danger">*</strong></label>
                                <input type="text" class="form-control" name="branch_address" value="<?= $editing_data['branch_address']; ?>" placeholder="<?= print_lang($app_lang,'address'); ?>">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'language'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="branch_language">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'language'); ?> --</option>
                                    <?php foreach($languages as $row){ ?>
                                        <option value="<?= $row['uid']; ?>" <?php if($editing_data['branch_language'] == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="row extra-mar-botm">
                        <div class="col-md-12 text-right">
                            <a class="btn btn-w-m btn-outline btn-danger url-elem" href="<?php echo url('/branches'); ?>"><?= print_lang($app_lang,'cancel'); ?></a>
                            <button class="btn btn-w-m btn-primary" type="submit"><?= print_lang($app_lang,'update'); ?></button>
                        </div>
                    </div>

                </form>
            </div>
        </div>
    </div>

</div>

