<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'add_new_buy_car'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/buy-cars'); ?>"><?= print_lang($app_lang,'buy_cars'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'new_buy_car'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="ibox-title">
        <h5><?= print_lang($app_lang,'fields_with'); ?> <strong class="text-danger">*</strong> <?= print_lang($app_lang,'are_mandatory'); ?></h5>
    </div>
    <div class="ibox-content">
        <!-- spinner -->
        <div class="sk-spinner sk-spinner-three-bounce">
            <div class="sk-bounce1"></div>
            <div class="sk-bounce2"></div>
            <div class="sk-bounce3"></div>
        </div>
        <!-- spinner -->
        <div class="row">
            <div class="col-sm-12 b-r">
                <form role="form" id="buy-cars-form" action="<?php echo url('/buy-cars/save'); ?>">

                    <div class="row extra-mar-botm">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'car_type'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="car_type">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'select_car'); ?> --</option>
                                    <option value="containery"><?= print_lang($app_lang,'containery'); ?></option>
                                    <option value="imported"><?= print_lang($app_lang,'imported'); ?></option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'currency'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="currency">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'select_currency'); ?> --</option>
                                    <?php foreach($currencies as $row){ ?>
                                        <option value="<?= $row['uid']; ?>" data-usd-equalance="<?= $row['usd_equalance']; ?>"><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'car_name'); ?> <strong class="text-danger">*</strong></label>
                                <input type="text" class="form-control" name="car_name" placeholder="<?= print_lang($app_lang,'car_name'); ?>">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'shasi_num'); ?> <strong class="text-danger">*</strong></label>
                                <input type="text" class="form-control" name="shasi_num" placeholder="<?= print_lang($app_lang,'shasi_num'); ?>">
                            </div>
                        </div>
                    </div>

                    <div class="row extra-mar-botm">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'car_model'); ?></label>
                                <input type="text" class="form-control" name="car_model" placeholder="<?= print_lang($app_lang,'car_model'); ?>">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'car_color'); ?></label>
                                <input type="text" class="form-control" name="car_color" placeholder="<?= print_lang($app_lang,'car_color'); ?>">
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'car_makes'); ?></label>
                                <input type="text" class="form-control" name="car_makes" placeholder="<?= print_lang($app_lang,'car_makes'); ?>">
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'car_cost'); ?></label>
                                <input type="text" class="form-control" name="car_cost" placeholder="<?= print_lang($app_lang,'car_cost'); ?>">
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'total_expense'); ?></label>
                                <input type="text" class="form-control" name="expense_totals" placeholder="<?= print_lang($app_lang,'total_expense'); ?>" readonly>
                            </div>
                        </div>

                        
                    </div>

                    <div class="row extra-mar-botm">
                        <div class="col-md-12">
                            <h3><?= print_lang($app_lang,'car_expenses'); ?></h3>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'expense_date'); ?></label>
                                <?php if($branch_calander == 'persian'){ ?>
                                    <input type="text" class="form-control persian-date" name="expense_date" placeholder="<?= print_lang($app_lang,'expense_date'); ?>" readonly="" style="background: #fff;">
                                <?php }else{ ?>
                                    <input type="date" class="form-control" id="expense_date" >
                                <?php } ?>
                            </div>
                        </div>

                        <div class="col-md-2">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'expense_currency'); ?></label>
                                <select class="form-control chosen-select" id="expense_currency">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'select_currency'); ?> --</option>
                                    <?php foreach($currencies as $row){ ?>
                                        <option value="<?= $row['uid']; ?>" data-usd-equalance="<?= $row['usd_equalance']; ?>"><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>

                        <div class="col-md-2">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'expense_amount'); ?></label>
                                <input type="text" class="form-control" id="expense_amount" placeholder="<?= print_lang($app_lang,'expense_amount'); ?>">
                            </div>
                        </div>

                        <div class="col-md-2">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'expense_agent'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" id="expense_agent">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'select_agent'); ?> --</option>
                                    <?php foreach($suppliers as $row){ ?>
                                        <option value="<?= $row['uid']; ?>"><?= $row['name']; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>

                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'expense_details'); ?></label>
                                <input type="text" class="form-control" id="expense_details" placeholder="<?= print_lang($app_lang,'expense_details'); ?>">
                            </div>
                        </div>

                        <div class="col-md-1">
                            <a class="btn btn-primary sm buy-car-expense-trigger" href="javascript:void(0);" style="margin-top: 23px;"><i class="fa fa-plus"></i></a>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <div class="table-responsive">
                                <table class="table table-bordered" style="width: 100%;">
                                    <thead>
                                        <tr>
                                            <th>Date</th>
                                            <th>Currency</th>
                                            <th>Amount</th>
                                            <th>Agent</th>
                                            <th>Details</th>
                                            <th style="width: 5%; text-align: center;">Remove</th>
                                        </tr>
                                    </thead>
                                    <tbody id="car-buy-expenses-tbody">
                                        
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                    <div class="row extra-mar-botm">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'seller_name'); ?></label>
                                <input type="text" class="form-control" name="seller_name" placeholder="<?= print_lang($app_lang,'seller_name'); ?>">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'seller_tazkira'); ?></label>
                                <input type="text" class="form-control" name="seller_tazkira" placeholder="<?= print_lang($app_lang,'seller_tazkira'); ?>">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'seller_address'); ?></label>
                                <input type="text" class="form-control" name="seller_address" placeholder="<?= print_lang($app_lang,'seller_address'); ?>">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'seller_mobile'); ?></label>
                                <input type="text" class="form-control" name="seller_mobile" placeholder="<?= print_lang($app_lang,'seller_mobile'); ?>">
                            </div>
                        </div>
                    </div>

                    <div class="row extra-mar-botm">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'car_images'); ?></label>
                                <input type="file" class="form-control" name="car_images[]" multiple>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'seller_image'); ?></label>
                                <input type="file" class="form-control" name="seller_image">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'payment'); ?></label>
                                <input type="text" class="form-control" name="payment" placeholder="<?= print_lang($app_lang,'payment'); ?>">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'payment_account'); ?></label>
                                <select class="form-control chosen-select" name="payment_account">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'select_account'); ?> --</option>
                                    <?php foreach($accounts as $row){ ?>
                                        <option value="<?= $row['uid']; ?>"><?= $row['name']; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="row extra-mar-botm">
                        <div class="col-md-12 text-right">
                            <a class="btn btn-w-m btn-outline btn-danger url-elem" href="<?php echo url('/buy-cars'); ?>"><?= print_lang($app_lang,'cancel'); ?></a>
                            <button class="btn btn-w-m btn-primary" type="submit"><?= print_lang($app_lang,'save'); ?></button>
                        </div>
                    </div>

                </form>
            </div>
        </div>
    </div>

</div>
