<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-8">
        <h2><?= print_lang($app_lang,'showroom_sales'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'showroom_sales'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-4">
        <div class="title-action">
            
        </div>
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'showroom_sales_listing'); ?></h2>
                    
                    <form id="showroom-sales-search-form" action="<?= url('/showroom-sales'); ?>">
                    <div class="row">
                        <div class="col-md-9">
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <select class="form-control chosen-select" name="currency">
                                            <option value="" selected="">-- <?= print_lang($app_lang,'currency'); ?> --</option>
                                            <?php foreach($currencies as $row){ ?>
                                                <option value="<?= $row['uid']; ?>" <?php if($search_currency == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <select class="form-control chosen-select" name="client">
                                            <option value="" selected="">-- <?= print_lang($app_lang,'client'); ?> --</option>
                                            <?php foreach($accounts as $row){ ?>
                                                <?php if($row['type'] == 'client'){ ?>
                                                <option value="<?= $row['uid']; ?>" <?php if($search_client == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                            <?php } } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($search_from); ?>" name="from" placeholder="<?= print_lang($app_lang,'from'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="from" value="<?= true_date_for_inputs($search_from); ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($search_to); ?>" name="to" placeholder="<?= print_lang($app_lang,'to'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="to" value="<?= true_date_for_inputs($search_to); ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3 text-right">
                            <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                            <a href="#" data-date="<?= display_true_date(date('Y-m-d')); ?>" class="today-date-form-trigger btn btn-primary custom-font-btn-search"><?= print_lang($app_lang,'today'); ?></a>
                        </div>
                    </div>
                    </form>

                    <hr>

                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center" style="min-width:30px;"><?= print_lang($app_lang,'buy_cars_sale_thead_sr_num'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'buy_cars_sale_thead_invoice'); ?></th>
                                    <th class="text-center" style="min-width:120px;"><?= print_lang($app_lang,'buy_cars_sale_thead_car'); ?></th>
                                    <th class="text-center" style="min-width:100px;"><?= print_lang($app_lang,'buy_cars_sale_thead_cost'); ?></th>
                                    <th class="text-center" style="min-width:100px;"><?= print_lang($app_lang,'buy_cars_sale_thead_sale_price'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'buy_cars_sale_thead_profit'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'buy_cars_sale_thead_discount'); ?></th>
                                    <th class="text-center" style="min-width:100px;"><?= print_lang($app_lang,'buy_cars_sale_thead_total'); ?></th>
                                    <th class="text-center" style="min-width:100px;"><?= print_lang($app_lang,'buy_cars_sale_thead_paid'); ?></th>
                                    <th class="text-center" style="min-width:100px;"><?= print_lang($app_lang,'buy_cars_sale_thead_pending'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'buy_cars_sale_thead_buyer'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'buy_cars_sale_thead_seller'); ?></th>
                                    <th class="text-center" style="min-width:120px;"><?= print_lang($app_lang,'action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $i = 1;
                                $total_amount = array();
                                $total_cost = array();
                                $total_sale_price = array();
                                $total_profit = array();
                                $total_total = array();
                                $total_discount = array();
                                $total_gross_total = array();
                                $total_cash_paid = array();
                                $total_pending_amount = array();

                                foreach($pageData as $row){

                                    $row_currency = array_key_exists($row['currency'],$currencies) ? $currencies[$row['currency']]['symbol'] : NULL;
                                ?>
                                    <tr class="text-center">
                                        <td><?= $i++; ?></td>
                                        <td><?= $row['invoice']; ?></td>
                                        <td><?= array_key_exists($row['car'],$car_details) ? $car_details[$row['car']]['car_name'].' '.$car_details[$row['car']]['car_model'] : NULL; ?></td>
                                        
                                        <td><?= $row_currency; ?><?= amount_number_format((float)$row['real_cost']); $total_cost[] = (float)$row['real_cost']; ?></td>
                                        <td><?= $row_currency; ?><?= amount_number_format((float)$row['sale_price']); $total_sale_price[] = (float)$row['sale_price']; ?></td>
                                        <td><?= $row_currency; ?><?= amount_number_format((float)$row['profit']); $total_profit[] = (float)$row['profit']; ?></td>
                                        <td><?= amount_number_format((float)$row['discount']); $total_discount[] = (float)$row['discount']; ?></td>
                                        <td><?= $row_currency; ?><?= amount_number_format((float)$row['gross_total']); $total_gross_total[] = (float)$row['gross_total']; ?></td>
                                        <td><?= $row_currency; ?><?= amount_number_format((float)$row['cash_paid']); $total_cash_paid[] = (float)$row['cash_paid']; ?></td>
                                        <td><?= $row_currency; ?><?= amount_number_format((float)$row['pending_amount']); $total_pending_amount[] = (float)$row['pending_amount']; ?></td>
                                        <td>
                                            <a href="javascript:void(0);" class="btn btn-xs btn-outline btn-warning buyer-info-popup-trigger" data-name="<?= $row['name']; ?>" data-f-name="<?= $row['father_name']; ?>" data-tazkira="<?= $row['tazkira']; ?>" data-mobile="<?= $row['mobile']; ?>" data-address="<?= $row['address']; ?>"><i class="fa fa-eye">&nbsp; </i><?= print_lang($app_lang,'buy_cars_sale_thead_buyer_info'); ?></a>
                                        </td>
                                        <td>
                                            <a href="javascript:void(0);" class="btn btn-xs btn-outline btn-warning seller-info-popup-trigger" data-name="<?= array_key_exists($row['car'],$car_details) ? $car_details[$row['car']]['seller_name'] : NULL; ?>" data-tazkira="<?= array_key_exists($row['car'],$car_details) ? $car_details[$row['car']]['seller_tazkira'] : NULL; ?>" data-address="<?= array_key_exists($row['car'],$car_details) ? $car_details[$row['car']]['seller_address'] : NULL; ?>" data-mobile="<?= array_key_exists($row['car'],$car_details) ? $car_details[$row['car']]['seller_mobile'] : NULL; ?>"><i class="fa fa-eye">&nbsp; </i><?= print_lang($app_lang,'buy_cars_sale_thead_seller_info'); ?></a>
                                        </td>
                                        <td>
                                            <?php if(check_user_access('sale_edit_shor_buy_cars') === TRUE){ ?>
                                                <a href="<?= url('/buy-cars/sale/edit').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-primary url-elem"><i class="fa fa-pencil">&nbsp; </i><?= print_lang($app_lang,'edit'); ?></a>
                                            <?php } ?>
                                            <?php if(check_user_access('sale_delete_shor_buy_cars') === TRUE){ ?>
                                                <a href="<?= url('/buy-cars/sale/delete').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-danger delete-btn-trigger" data-msg="You will not be able to revert this" data-mood="Delete"><i class="fa fa-trash"></i>&nbsp; <?= print_lang($app_lang,'delete'); ?></a>
                                            <?php } ?>
                                        </td>
                                    </tr>
                                <?php } ?>

                                <tr class="text-center">
                                    <td><?= $i++; ?></td>
                                    <td><?= print_lang($app_lang,'total'); ?></td>
                                    <td>---</td>

                                    <td><?= amount_number_format( array_sum($total_cost) ); ?></td>
                                    <td><?= amount_number_format( array_sum($total_sale_price) ); ?></td>
                                    <td><?= amount_number_format( array_sum($total_profit) ); ?></td>
                                    <td><?= amount_number_format( array_sum($total_discount) ); ?></td>
                                    <td><?= amount_number_format( array_sum($total_gross_total) ); ?></td>
                                    <td><?= amount_number_format( array_sum($total_cash_paid) ); ?></td>
                                    <td><?= amount_number_format( array_sum($total_pending_amount) ); ?></td>

                                    <td>---</td>
                                    <td>---</td>
                                    <td>---</td>
                                </tr>

                            </tbody>
                        </table>    
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>


<div class="modal inmodal" id="buyerInfoModal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog">
    <div class="modal-content animated bounceInRight">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
                <i class="fa fa-laptop modal-icon"></i>
                <h4 class="modal-title"><?= print_lang($app_lang,'buy_cars_buyer_info_modal'); ?></h4>
            </div>
            <div class="modal-body">
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th><?= print_lang($app_lang,'buy_cars_sale_thead_buyer_name'); ?></th>
                            <th><?= print_lang($app_lang,'buy_cars_sale_thead_buyer_f_name'); ?></th>
                            <th><?= print_lang($app_lang,'buy_cars_sale_thead_buyer_mobile'); ?></th>
                            <th><?= print_lang($app_lang,'buy_cars_sale_thead_buyer_tazkira'); ?></th>
                            <th><?= print_lang($app_lang,'buy_cars_sale_thead_buyer_address'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>
                                <span id="buyer-info-name"></span>
                            </td>
                            <td>
                                <span id="buyer-info-f-name"></span>
                            </td>
                            <td>
                                <span id="buyer-mobile"></span>
                            </td>
                            <td>
                                <span id="buyer-tazkira"></span>
                            </td>
                            <td>
                                <span id="buyer-address"></span>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-white" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>



<div class="modal inmodal" id="sellerInfoModal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog">
    <div class="modal-content animated bounceInRight">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
                <i class="fa fa-laptop modal-icon"></i>
                <h4 class="modal-title"><?= print_lang($app_lang,'buy_cars_seller_info_modal'); ?></h4>
            </div>
            <div class="modal-body">
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th><?= print_lang($app_lang,'buy_cars_sale_thead_seller_name'); ?></th>
                            <th><?= print_lang($app_lang,'buy_cars_sale_thead_seller_mobile'); ?></th>
                            <th><?= print_lang($app_lang,'buy_cars_sale_thead_seller_tazkira'); ?></th>
                            <th><?= print_lang($app_lang,'buy_cars_sale_thead_seller_address'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>
                                <span id="seller-info-name"></span>
                            </td>
                            <td>
                                <span id="seller-mobile"></span>
                            </td>
                            <td>
                                <span id="seller-tazkira"></span>
                            </td>
                            <td>
                                <span id="seller-address"></span>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-white" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>