<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-8">
        <h2><?= print_lang($app_lang,'buy_cars'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'buy_cars'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-4">
        <div class="title-action">
            <?php if(check_user_access('add_shor_buy_cars') === TRUE){ ?>
                <a href="<?php echo url('/buy-cars/add'); ?>" class="btn btn-primary btn-sm custom-font-btn"><i class="fa fa-plus"></i>&nbsp; <?= print_lang($app_lang,'add_new_buy_car'); ?></a>
            <?php } ?>
        </div>
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'buy_cars_listing'); ?></h2>
                    
                    <form id="buy-cars-search-form" action="<?= url('/buy-cars'); ?>">
                    <div class="row">
                        <div class="col-md-9">
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <select class="form-control chosen-select" name="currency">
                                            <option disabled="" selected="">-- <?= print_lang($app_lang,'currency'); ?> --</option>
                                            <?php foreach($currencies as $row){ ?>
                                                <option value="<?= $row['uid']; ?>" <?php if($search_currency == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($search_from); ?>" name="from" placeholder="<?= print_lang($app_lang,'from'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="from" value="<?= true_date_for_inputs($search_from); ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($search_to); ?>" name="to" placeholder="<?= print_lang($app_lang,'to'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="to" value="<?= true_date_for_inputs($search_to); ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3 text-right">
                            <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                            <a href="#" data-date="<?= display_true_date(date('Y-m-d')); ?>" class="today-date-form-trigger btn btn-primary custom-font-btn-search"><?= print_lang($app_lang,'today'); ?></a>
                        </div>
                    </div>
                    </form>

                    <hr>

                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center" style="min-width:50px; max-width:50px;"><?= print_lang($app_lang,'sr_#'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'date'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'currency'); ?></th>
                                    <th class="text-center" style="min-width:100px; max-width:100px;"><?= print_lang($app_lang,'car_type'); ?></th>
                                    <th class="text-center" style="min-width:100px; max-width:100px;"><?= print_lang($app_lang,'car_name'); ?></th>
                                    <th class="text-center" style="min-width:100px; max-width:100px;"><?= print_lang($app_lang,'shasi_num'); ?></th>
                                    <th class="text-center" style="min-width:100px; max-width:100px;"><?= print_lang($app_lang,'car_model'); ?></th>
                                    <th class="text-center" style="min-width:100px; max-width:100px;"><?= print_lang($app_lang,'car_color'); ?></th>
                                    <th class="text-center" style="min-width:100px; max-width:100px;"><?= print_lang($app_lang,'car_makes'); ?></th>
                                    <th class="text-center" style="min-width:100px; max-width:100px;"><?= print_lang($app_lang,'car_cost'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'car_expense'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'car_real_cost'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'payment'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'pending'); ?></th>
                                    <th class="text-center" style="min-width:100px; max-width:100px;"><?= print_lang($app_lang,'seller_name'); ?></th>
                                    <th class="text-center" style="min-width:100px; max-width:100px;"><?= print_lang($app_lang,'seller_tazkira'); ?></th>
                                    <th class="text-center" style="min-width:100px; max-width:100px;"><?= print_lang($app_lang,'seller_mobile'); ?></th>
                                    <th class="text-center" style="min-width:100px; max-width:100px;"><?= print_lang($app_lang,'seller_image'); ?></th>
                                    <th class="text-center" style="min-width:100px; max-width:100px;"><?= print_lang($app_lang,'car_images'); ?></th>
                                    <th class="text-center" style="min-width:200px; max-width:200px;"><?= print_lang($app_lang,'action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $i = 1; foreach($pageData as $row){ ?>
                                    <tr class="text-center">
                                        <td><?= $i++; ?></td>
                                        <td><?= display_true_date($row['created_at']); ?></td>
                                        <td><?= array_key_exists($row['currency'],$currencies) ? $currencies[$row['currency']]['name'] : NULL; ?></td>
                                        <td><?= print_lang($app_lang,$row['car_type']); ?></td>
                                        <td><?= $row['car_name']; ?></td>
                                        <td><?= $row['shasi_num']; ?></td>
                                        <td><?= $row['car_model']; ?></td>
                                        <td><?= $row['car_color']; ?></td>
                                        <td><?= $row['car_makes']; ?></td>
                                        <td><?= $row['car_cost']; ?></td>
                                        <td><?= $row['total_convert_expense']; ?></td>
                                        <td><?= $row['real_cost']; ?></td>
                                        <td><?= $row['payment']; ?></td>
                                        <td><?= $row['pending']; ?></td>
                                        <td><?= $row['seller_name']; ?></td>
                                        <td><?= $row['seller_tazkira']; ?></td>
                                        <td><?= $row['seller_mobile']; ?></td>
                                        <td>
                                            <?php if(!empty($row['seller_image'])){ ?>
                                                <a href="<?= url('/uploads/buy_cars').'/'.$row['seller_image']; ?>" target="_blank" class="btn btn-xs btn-outline btn-info"><i class="fa fa-eye">&nbsp;&nbsp; </i><?= print_lang($app_lang,'preview'); ?></a>
                                            <?php } ?>
                                        </td>
                                        <td>
                                            <a id="<?= $row['uid']; ?>" data-images="<?= $row['car_images']; ?>" href="javascript:void(0);" class="btn btn-xs btn-outline btn-info buy-cars-images-preview-btn"><i class="fa fa-eye">&nbsp;&nbsp; </i><?= print_lang($app_lang,'preview'); ?></a>
                                        </td>
                                        <td>

                                            <?php if(check_user_access('sale_shor_buy_cars') === TRUE){ ?>
                                                <?php if($row['sold'] == 'sold'){ ?>
                                                    <span class="btn btn-xs btn-outline btn-warning"><i class="fa fa-check"></i>&nbsp;&nbsp;<?= print_lang($app_lang,'sold'); ?></span>
                                                <?php }else{ ?>
                                                    <a href="<?= url('/buy-cars/sale').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-primary url-elem"><i class="fa fa-send"></i>&nbsp;&nbsp;<?= print_lang($app_lang,'sale'); ?></a>
                                                <?php } ?>
                                            <?php } ?>


                                            <?php if(check_user_access('edit_shor_buy_cars') === TRUE){ ?>
                                                <a href="<?= url('/buy-cars/edit').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-primary url-elem"><i class="fa fa-pencil"></i>&nbsp; <?= print_lang($app_lang,'edit'); ?></a>
                                            <?php } ?>
                                            <?php if(check_user_access('delete_shor_buy_cars') === TRUE){ ?>
                                                <a href="<?= url('/buy-cars/delete').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-danger delete-btn-trigger"><i class="fa fa-trash"></i>&nbsp; <?= print_lang($app_lang,'delete'); ?></a>
                                            <?php } ?>
                                        </td>
                                    </tr>
                                <?php } ?>
                            </tbody>
                        </table>    
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>





<div class="modal inmodal" id="buy-cars-images-modal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content animated flipInX">
                
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
                <h4 class="modal-title"><?= print_lang($app_lang,'buy_cars_images_modal_title'); ?></h4>
                <small class="font-bold"><?= print_lang($app_lang,'buy_cars_images_modal_tag_line'); ?></small>
            </div>
            <div class="modal-body bg-white">

                <div class="row buy-cars-images-wrapper" style="margin-bottom: 20px;"></div>

            </div>
        </div>
    </div>
</div>