<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'mod_share_capitals_view_breadcrumb'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/share-capitals'); ?>"><?= print_lang($app_lang,'mod_share_capitals_view_breadcrumb'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'mod_share_capitals_edit_title'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="ibox-title">
        <h5><?= print_lang($app_lang,'fields_with'); ?> <strong class="text-danger">*</strong> <?= print_lang($app_lang,'are_mandatory'); ?></h5>
    </div>
    <div class="ibox-content">
        <!-- spinner -->
        <div class="sk-spinner sk-spinner-three-bounce">
            <div class="sk-bounce1"></div>
            <div class="sk-bounce2"></div>
            <div class="sk-bounce3"></div>
        </div>
        <!-- spinner -->
        <div class="row">
            <div class="col-sm-12 b-r">
                <form role="form" id="share-capitals-form" action="<?php echo url('/share-capitals/update').'/'.$editing_data['uid']; ?>">


                    <div class="row extra-mar-botm">
                        <div class="col-md-4">
                            <?php
                                $event_date = display_true_date($editing_data['event_date']);
                            ?>
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'date'); ?> <strong class="text-danger">*</strong></label>
                                <?php if($branch_calander == 'persian'){ ?>
                                    <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($event_date); ?>" name="event_date" placeholder="<?= print_lang($app_lang,'date'); ?>" readonly="" style="background: #fff;">
                                <?php }else{ ?>
                                    <input type="date" class="form-control" name="event_date" value="<?= true_date_for_inputs($event_date); ?>">
                                <?php } ?>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'mod_share_capitals_add_input_category'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="type">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'select_type'); ?> --</option>
                                    <?php foreach($capitals_categories as $row){ ?>
                                        <option <?php if($editing_data['type'] == $row['uid']){ echo 'selected="selected"'; } ?> value="<?= $row['uid']; ?>"><?= $row['name']; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'mod_share_capitals_add_input_account'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="account">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'select_account'); ?> --</option>
                                    <option <?php if($editing_data['account'] == 'simple_capital'){ echo 'selected="selected"'; } ?> value="simple_capital"><?= print_lang($app_lang,'mod_share_capitals_add_input_account_simple_capital'); ?></option>
                                    <?php foreach($accounts as $row){ ?>
                                        <option <?php if($editing_data['account'] == $row['uid']){ echo 'selected="selected"'; } ?> value="<?= $row['uid']; ?>"><?= $row['name']; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="row extra-mar-botm">
                        
                        <div class="col-md-4">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'mod_share_capitals_add_input_currency'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="currency">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'select_currency'); ?> --</option>
                                    <?php foreach($currencies as $row){ ?>
                                        <option <?php if($editing_data['currency'] == $row['uid']){ echo 'selected="selected"'; } ?> value="<?= $row['uid']; ?>"><?= $row['name']; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'mod_share_capitals_add_input_amount'); ?> <strong class="text-danger">*</strong></label>
                                <input type="number" class="form-control" name="amount" value="<?= $editing_data['amount']; ?>">
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'mod_share_capitals_add_input_details'); ?></label>
                                <input type="text" class="form-control" name="details" value="<?= $editing_data['details']; ?>">
                            </div>
                        </div>
                    </div>

                    <div class="row extra-mar-botm">
                        
                        <div class="col-md-6">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'mod_share_capitals_add_input_shareholder'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select shareholder-capitals-select" name="shareholder">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'mod_share_capitals_add_input_shareholder'); ?> --</option>
                                    <?php foreach($shareholder as $row){ ?>
                                        <option data-percentage="<?= $row['percentage']; ?>" <?php if($editing_data['shareholder'] == $row['uid']){ echo 'selected="selected"'; } ?> value="<?= $row['uid']; ?>"><?= $row['name'].' '.$row['last_name']; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'mod_share_capitals_add_input_percentage'); ?> <strong class="text-danger">*</strong></label>
                                <input type="number" class="form-control find-percentage" name="percentage" readonly value="<?= $editing_data['percentage']; ?>">
                            </div>
                        </div>

                    </div>

                    <div class="row extra-mar-botm">
                        <div class="col-md-12 text-right">
                            <a class="btn btn-w-m btn-outline btn-danger url-elem" href="<?php echo url('/share-capitals'); ?>"><?= print_lang($app_lang,'cancel'); ?></a>
                            <button class="btn btn-w-m btn-primary" type="submit"><?= print_lang($app_lang,'update'); ?></button>
                        </div>
                    </div>

                </form>
            </div>
        </div>
    </div>

</div>