<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-8">
        <h2><?= print_lang($app_lang,'mod_share_capitals_view_breadcrumb'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'mod_share_capitals_view_breadcrumb'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-4">
        <div class="title-action">
            <?php if(check_user_access('add_share_capital_right') === TRUE){ ?>
                <a href="<?php echo url('/share-capitals/add'); ?>" class="btn btn-primary btn-sm custom-font-btn"><i class="fa fa-plus"></i>&nbsp; <?= print_lang($app_lang,'mod_share_capitals_view_add_btn'); ?></a>
            <?php } ?>
        </div>
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'mod_share_capitals_view_title_listing'); ?></h2>

                    <form id="share-capitals-search-form" action="<?= url('/share-capitals'); ?>">
                    <div class="row">
                        <div class="col-md-10">
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'currency'); ?></label>
                                        <select class="form-control chosen-select" name="currency">
                                            <option value="" selected="">-- <?= print_lang($app_lang,'select_currency'); ?> --</option>
                                            <?php foreach($currencies as $row){ ?>
                                                <option value="<?= $row['uid']; ?>" <?php if($search_currency == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>

                                <div class="col-md-3" style="padding: 2px;">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'type'); ?></label>
                                        <select class="form-control chosen-select" name="type">
                                            <option value="" selected="">-- <?= print_lang($app_lang,'select_type'); ?> --</option>
                                            <?php foreach($capitals_categories as $row){ ?>
                                                <option value="<?= $row['uid']; ?>" <?php if($search_type == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'from'); ?></label>
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= $search_from; ?>" name="from" placeholder="<?= print_lang($app_lang,'from'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="from" value="<?= $search_from; ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'to'); ?></label>
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= $search_to; ?>" name="to" placeholder="<?= print_lang($app_lang,'to'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="to" value="<?= $search_to; ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-2 text-right" style="margin-top: 23px;">
                            <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                        </div>
                    </div>
                    </form>
                    <hr>

                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center" style="width:40px;"><?= print_lang($app_lang,'mod_share_capitals_view_thead_sr'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_share_capitals_view_thead_date'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_share_capitals_view_thead_category'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_share_capitals_view_thead_account'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_share_capitals_view_thead_shareholder'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_share_capitals_view_thead_amount'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_share_capitals_view_thead_percentage'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_share_capitals_view_thead_details'); ?></th>
                                    <th class="text-center" style="min-width:120px; max-width:120px;"><?= print_lang($app_lang,'action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $total_amount = array(); $i = 1; foreach($pageData as $row){ ?>
                                    <tr class="text-center">
                                        <td><?= $i++; ?></td>
                                        <td><?= display_true_date($row['event_date']); ?></td>
                                        <td><?= ucfirst($row['type_name']); ?></td>
                                        <td><?= ucfirst($row['account_name']); ?></td>
                                        <td><?= ucfirst($row['shareholder_name']); ?></td>
                                        <td><?= $row['currency_symbol'].' '.round_decimels_digits_3($row['amount']); $total_amount[] = $row['amount']; ?></td>
                                        <td><?= $row['percentage']; ?></td>
                                        <td><?= $row['details']; ?></td>
                                        <td>
                                            <?php if(check_user_access('edit_share_capital_right') === TRUE){ ?>
                                                <a href="<?= url('/share-capitals/edit').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-primary url-elem"><i class="fa fa-pencil">&nbsp; </i><?= print_lang($app_lang,'edit'); ?></a>
                                            <?php } ?>
                                            <?php if(check_user_access('delete_share_capital_right') === TRUE){ ?>
                                                <a href="<?= url('/share-capitals/delete').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-danger delete-btn-trigger" data-msg="You will not be able to revert this" data-mood="Delete"><i class="fa fa-trash"></i>&nbsp; <?= print_lang($app_lang,'delete'); ?></a>
                                            <?php } ?>
                                        </td>
                                    </tr>
                                <?php } ?>
                                <tr class="text-center">
                                    <td><?= $i++; ?></td>
                                    <td></td>
                                    <td><?= print_lang($app_lang,'total'); ?></td>
                                    <td></td>
                                    <td></td>
                                    <td><?= round_decimels_digits(array_sum($total_amount)); ?></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                </tr>
                            </tbody>
                        </table>    
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>