<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-8">
        <h2><?= print_lang($app_lang,'car_purchases'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'car_purchases'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-4">
        <div class="title-action">
            <?php if(check_user_access('add_shor_car_purchases') === TRUE){ ?>
                <a href="<?= url('/car-purchases/add'); ?>" class="btn btn-primary btn-sm custom-font-btn"><i class="fa fa-plus"></i>&nbsp; <?= print_lang($app_lang,'add_new_car_purchase'); ?></a>
            <?php } ?>
        </div>
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'car_purchases_listing'); ?></h2>

                    <form id="car-purchases-search-form" action="<?= url('/car-purchases'); ?>">
                    <div class="row">
                        <div class="col-md-9">
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <select class="form-control chosen-select" name="currency">
                                            <option value="" selected="">-- <?= print_lang($app_lang,'currency'); ?> --</option>
                                            <?php foreach($currencies as $row){ ?>
                                                <option value="<?= $row['uid']; ?>" <?php if($search_currency == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <select class="form-control chosen-select" name="agent">
                                            <option value="" selected="">-- <?= print_lang($app_lang,'agent'); ?> --</option>
                                            <?php foreach($suppliers as $row){ ?>
                                                <option value="<?= $row['uid']; ?>" <?php if($search_agent == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($search_from); ?>" name="from" placeholder="<?= print_lang($app_lang,'from'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="from" value="<?= true_date_for_inputs($search_from); ?>">
                                        <?php } ?>
                                    </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($search_to); ?>" name="to" placeholder="<?= print_lang($app_lang,'to'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="to" value="<?= true_date_for_inputs($search_to); ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3 text-right">
                            <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                            <a href="#" data-date="<?= display_true_date(date('Y-m-d')); ?>" class="today-date-form-trigger btn btn-primary custom-font-btn-search"><?= print_lang($app_lang,'today'); ?></a>
                        </div>
                    </div>
                    </form>
                    <hr>

                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center"><?= print_lang($app_lang,'sr_#'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'date'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'invoice'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'agent'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'currency'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'cost'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'transfer_exp'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'agent_commission'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'other_expenses'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'total_amount'); ?></th>
                                    <th class="text-center" style="min-width:190px; max-width:190px;"><?= print_lang($app_lang,'action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $total_cost = array();
                                $total_transfer_expenses = array();
                                $total_agent_commission = array();
                                $total_other_expenses = array();
                                $total_total_amount = array();
                                ?>
                                <?php $i = 1; foreach($pageData as $row){ ?>
                                    <tr class="text-center">
                                        <td><?= $i++; ?></td>
                                        <td><?= display_true_date(explode(' ',$row['created_at'])[0]); ?></td>
                                        <td><?= $row['invoice']; ?></td>
                                        <td><?= array_key_exists($row['agent'], $suppliers) ? $suppliers[$row['agent']]['name'] : NULL; ?></td>
                                        <td><?= array_key_exists($row['currency'], $currencies) ? $currencies[$row['currency']]['name'] : NULL; ?></td>
                                        <td><?= round_decimels_digits($row['cost']); $total_cost[] = (float)$row['cost']; ?></td>
                                        <td><?= round_decimels_digits($row['transfer_expenses']); $total_transfer_expenses[] = (float)$row['transfer_expenses']; ?></td>
                                        <td><?= round_decimels_digits($row['agent_commission']); $total_agent_commission[] = (float)$row['agent_commission']; ?></td>
                                        <td><?= round_decimels_digits($row['other_expenses']); $total_other_expenses[] = (float)$row['other_expenses']; ?></td>
                                        <td><?= round_decimels_digits($row['total_amount']); $total_total_amount[] = (float)$row['total_amount']; ?></td>

                                        <td>
                                            <?php if(check_user_access('invoice_shor_car_purchases') === TRUE){ ?>
                                                <a href="<?= url('/car-purchases/invoice').'/'.$row['uid']; ?>" target="_blank" class="btn btn-xs btn-outline btn-warning url-elem"><i class="fa fa-external-link">&nbsp; </i><?= print_lang($app_lang,'invoice'); ?></a>
                                            <?php } ?>
                                            <?php if(check_user_access('edit_shor_car_purchases') === TRUE){ ?>
                                                <a href="<?= url('/car-purchases/edit').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-primary url-elem"><i class="fa fa-pencil">&nbsp; </i><?= print_lang($app_lang,'edit'); ?></a>
                                            <?php } ?>
                                            <?php if(check_user_access('delete_shor_car_purchases') === TRUE){ ?>
                                                <a href="<?= url('/car-purchases/delete').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-danger delete-btn-trigger" data-msg="You will not be able to revert this" data-mood="Delete"><i class="fa fa-trash"></i>&nbsp; <?= print_lang($app_lang,'delete'); ?></a>
                                            <?php } ?>
                                        </td>
                                    </tr>
                                <?php } ?>
                                <tr class="text-center">
                                    <td><?= $i++; ?></td>
                                    <td><?= display_true_date(date('Y-m-d')); ?></td>
                                    <td><?= print_lang($app_lang,'total'); ?></td>
                                    <td></td>
                                    <td></td>
                                    <td><?= round_decimels_digits(array_sum($total_cost)); ?></td>
                                    <td><?= round_decimels_digits(array_sum($total_transfer_expenses)); ?></td>
                                    <td><?= round_decimels_digits(array_sum($total_agent_commission)); ?></td>
                                    <td><?= round_decimels_digits(array_sum($total_other_expenses)); ?></td>
                                    <td><?= round_decimels_digits(array_sum($total_total_amount)); ?></td>
                                    <td>---</td>
                                </tr>
                            </tbody>
                        </table>    
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>