<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'mode_cn_purchases_edit_breadcrumb'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/cn-purchases'); ?>"><?= print_lang($app_lang,'batch'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'mode_cn_purchases_edit_breadcrumb'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="ibox-title">
        <h5><?= print_lang($app_lang,'fields_with'); ?> <strong class="text-danger">*</strong> <?= print_lang($app_lang,'are_mandatory'); ?></h5>
    </div>
    <div class="ibox-content">
        <!-- spinner -->
        <div class="sk-spinner sk-spinner-three-bounce">
            <div class="sk-bounce1"></div>
            <div class="sk-bounce2"></div>
            <div class="sk-bounce3"></div>
        </div>
        <!-- spinner -->
        <div class="row">
            <div class="col-sm-12 b-r">
                <form role="form" id="cn-purchases-form" action="<?php echo url('/cn-purchases/update').'/'.$editing_data['uid']; ?>">


                    <div class="row">

                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'mode_cn_purchases_add_input_invoice'); ?> <strong class="text-danger">*</strong></label>
                                <input type="text" class="form-control" name="invoice" value="<?= $editing_data['invoice']; ?>" placeholder="<?= print_lang($app_lang,'mode_cn_purchases_add_input_invoice'); ?>">
                            </div>
                        </div>


                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'mode_cn_purchases_add_input_date'); ?></label>
                                <?php $edate = display_true_date( explode(' ',$editing_data['cn_date'])[0] ); $edate = date('Y-m-d',strtotime($edate)); ?>
                                <?php if($branch_calander == 'persian'){ ?>
                                    <input type="text" class="form-control persian-date" name="cn_date" value="<?= true_date_for_inputs($edate); ?>" placeholder="<?= print_lang($app_lang,'mode_cn_purchases_add_input_date'); ?>" readonly="" style="background: #fff;">
                                <?php }else{ ?>
                                    <input type="date" class="form-control" name="cn_date" value="<?= date("Y-m-d",strtotime(true_date_for_inputs($edate))); ?>">
                                <?php } ?>
                            </div>
                        </div>

                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'mode_cn_purchases_add_input_currency'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="currency">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'select_currency'); ?> --</option>
                                    <?php foreach($currencies as $row){ ?>
                                        <option <?php if($editing_data['currency'] == $row['uid']){echo "selected='selected'";}?> value="<?= $row['uid']; ?>"><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>

                        <?php
                            $item_data = fetch_table_where('items','uid',$editing_data['item'],true);
                            $item_purchase_unit = fetch_table_where('units','uid',$item_data['purchase_unit'],true);
                            $item_sale_unit = fetch_table_where('units','uid',$item_data['sale_unit'],true);
                            $item_production_unit = fetch_table_where('units','uid',$item_data['production_unit'],true);
                        ?>

                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'mode_cn_purchases_add_input_item'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="item" id="purchases-temp-item">
                                    <option disabled="" selected="" value="">-- <?= print_lang($app_lang,'select_item'); ?> --</option>
                                    <?php foreach($items as $row){
                                        $item_stats = json_decode($row['stats'],true);
                                        $item_tp = (float)$item_stats['last_cost'] + (float)$item_stats['last_profit'];
                                    ?>
                                        <option <?php if($editing_data['item'] == $row['uid']){echo "selected='selected'";}?> value="<?= $row['uid']; ?>" data-item-cbm-width="<?= $row['item_width']; ?>" data-item-cbm-length="<?= $row['item_length']; ?>" data-item-cbm-height="<?= $row['item_height']; ?>" data-item-cbm="<?= $row['cbm']; ?>" data-item-weight="<?= $row['weight']; ?>" data-last-cost="<?= $item_stats['last_cost']; ?>" data-tp="<?= $item_tp; ?>" data-last-profit="<?= $item_stats['last_profit']; ?>" data-width="<?= $row['width']; ?>" data-height="<?= $row['height']; ?>" data-purchase-unit="<?= array_key_exists($row['purchase_unit'],$units) ? $units[$row['purchase_unit']]['name'] : NULL; ?>" data-sale-unit="<?= array_key_exists($row['sale_unit'],$units) ? $units[$row['sale_unit']]['name'] : NULL; ?>" data-production-unit="<?= array_key_exists($row['production_unit'],$units) ? $units[$row['production_unit']]['name'] : NULL; ?>" data-opt-type="<?= $row['type']; ?>"><?= $row['name'].', '.$row['item_id']; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>


                    </div>

                    <div class="row">
                        
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'mode_cn_purchases_add_input_warehouse'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="warehouse">
                                    <option disabled="" selected="" data-opt-type="default">-- <?= print_lang($app_lang,'select_warehouse'); ?> --</option>
                                    <?php foreach($warehouse as $row){ ?>
                                        <option <?php if($editing_data['warehouse'] == $row['uid']){echo "selected='selected'";}?> <?php if($item_data['type'] != $row['type']){echo "class='display-none'";}?> value="<?= $row['uid']; ?>" data-opt-type="<?= $row['type']; ?>"><?= $row['name']; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>

                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'mode_cn_purchases_add_input_supplier'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select temp_supplier_edit" name="supplier">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'mode_cn_purchases_add_input_supplier'); ?> --</option>
                                    <?php foreach($suppliers as $row){ ?>
                                        <option <?php if($editing_data['supplier'] == $row['uid']){echo "selected='selected'";}?> value="<?= $row['uid']; ?>"><?= $row['name']; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>

                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'mode_cn_purchases_add_input_unit'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="unit">
                                    <option <?php if($editing_data['unit'] == 'purchase'){echo "selected='selected'";}?> value="purchase"><?= $item_purchase_unit['name']; ?></option>
                                    <option <?php if($editing_data['unit'] == 'sale'){echo "selected='selected'";}?> value="sale"><?= $item_sale_unit['name']; ?></option>
                                    <option <?php if($editing_data['unit'] == 'production'){echo "selected='selected'";}?> value="production"><?= $item_production_unit['name']; ?></option>
                                </select>
                            </div>
                        </div>

                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'mode_cn_purchases_add_input_batch'); ?><strong class="text-danger">*</strong></label>
                                <input type="text" class="form-control" name="batch" value="<?= $editing_data['batch']; ?>" placeholder="<?= print_lang($app_lang,'mode_cn_purchases_add_input_batch'); ?>">
                            </div>
                        </div>

                    </div>

                    <div class="row">
                        <div class="col-md-2">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'mode_cn_purchases_add_input_qty'); ?><strong class="text-danger">*</strong></label>
                                <input type="text" class="form-control" name="qty" value="<?= $editing_data['qty']; ?>" placeholder="<?= print_lang($app_lang,'mode_cn_purchases_add_input_qty'); ?>">
                            </div>
                        </div>

                        <div class="col-md-2">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'mode_cn_purchases_add_input_cost'); ?><strong class="text-danger">*</strong></label>
                                <input type="text" class="form-control" name="cost" value="<?= $editing_data['cost']; ?>" placeholder="<?= print_lang($app_lang,'mode_cn_purchases_add_input_cost'); ?>">
                            </div>
                        </div>

                        <div class="col-md-2">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'mode_cn_purchases_add_input_total'); ?><strong class="text-danger">*</strong></label>
                                <input type="text" class="form-control" name="total" value="<?= $editing_data['total']; ?>" placeholder="<?= print_lang($app_lang,'mode_cn_purchases_add_input_total'); ?>" readonly>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'mode_cn_purchases_add_details'); ?></label>
                                <input type="text" class="form-control" name="details" value="<?= $editing_data['details']; ?>" placeholder="<?= print_lang($app_lang,'mode_cn_purchases_add_details'); ?>">
                            </div>
                        </div>

                    </div>
                    

                    <div class="row extra-mar-botm">
                        <div class="col-md-12 text-right">
                            <a class="btn btn-w-m btn-outline btn-danger url-elem" href="<?php echo url('/cn-purchases'); ?>"><?= print_lang($app_lang,'cancel'); ?></a>
                            <button class="btn btn-w-m btn-primary" type="submit"><?= print_lang($app_lang,'update'); ?></button>
                        </div>
                    </div>

                </form>
            </div>
        </div>
    </div>

</div>

