<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'add_new_custom_expenses'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/custom-expenses'); ?>"><?= print_lang($app_lang,'custom_expenses'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'new_custom_expenses'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="ibox-title">
        <h5><?= print_lang($app_lang,'fields_with'); ?> <strong class="text-danger">*</strong> <?= print_lang($app_lang,'are_mandatory'); ?></h5>
    </div>
    <div class="ibox-content">
        <!-- spinner -->
        <div class="sk-spinner sk-spinner-three-bounce">
            <div class="sk-bounce1"></div>
            <div class="sk-bounce2"></div>
            <div class="sk-bounce3"></div>
        </div>
        <!-- spinner -->
        <div class="row">
            <div class="col-sm-12 b-r">
                <form role="form" id="custom-expenses-form" action="<?php echo url('/custom-expenses/save'); ?>">

                    <div class="row extra-mar-botm">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'currency'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="currency">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'select_currency'); ?> --</option>
                                    <?php foreach($currencies as $row){ ?>
                                        <option value="<?= $row['uid']; ?>" data-usd-equalance="<?= $row['usd_equalance']; ?>"><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'rate'); ?> <strong class="text-danger">*</strong></label>
                                <input type="text" class="form-control" name="rate" placeholder="<?= print_lang($app_lang,'rate'); ?>">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'invoice'); ?> <strong class="text-danger">*</strong></label>
                                <input type="text" class="form-control" name="invoice" placeholder="<?= print_lang($app_lang,'invoice'); ?>">
                            </div>
                        </div>
                    </div>

                    <div class="row extra-mar-botm">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'load_delivery'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="load_delivery">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'select_delivery'); ?> --</option>
                                    <?php foreach($load_delivery as $row){ ?>
                                        <option value="<?= $row['uid']; ?>"><?= $row['load_plate']; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'agent'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="agent">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'select_agent'); ?> --</option>
                                    <?php foreach($accounts as $row){ ?>
                                        <?php if($row['type'] == 'transit'){ ?>
                                            <option value="<?= $row['uid']; ?>"><?= $row['name']; ?></option>
                                        <?php } ?>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'amount'); ?> <strong class="text-danger">*</strong></label>
                                <input type="text" class="form-control" name="amount" placeholder="<?= print_lang($app_lang,'amount'); ?>">
                            </div>
                        </div>
                    </div>

                    <div class="row extra-mar-botm">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'details'); ?></label>
                                <textarea class="form-control" name="details" placeholder="<?= print_lang($app_lang,'details'); ?>"></textarea>
                            </div>
                        </div>
                    </div>

                    <div class="row extra-mar-botm">
                        <div class="col-md-12 text-right">
                            <a class="btn btn-w-m btn-outline btn-danger url-elem" href="<?php echo url('/custom-expenses'); ?>"><?= print_lang($app_lang,'cancel'); ?></a>
                            <button class="btn btn-w-m btn-primary" type="submit"><?= print_lang($app_lang,'save'); ?></button>
                        </div>
                    </div>

                </form>
            </div>
        </div>
    </div>

</div>