<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'edit_damage_stock'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/damage-stock'); ?>"><?= print_lang($app_lang,'damage_stock'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'edit_damage_stock'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="ibox-title">
        <h5><?= print_lang($app_lang,'fields_with'); ?> <strong class="text-danger">*</strong> <?= print_lang($app_lang,'are_mandatory'); ?></h5>
    </div>
    <div class="ibox-content">
        <!-- spinner -->
        <div class="sk-spinner sk-spinner-three-bounce">
            <div class="sk-bounce1"></div>
            <div class="sk-bounce2"></div>
            <div class="sk-bounce3"></div>
        </div>
        <!-- spinner -->
        <div class="row">
            <div class="col-sm-12 b-r">
                <form role="form" id="damage-stock-form" action="<?php echo url('/damage-stock/update').'/'.$editing_data['uid']; ?>">

                    <div class="row extra-mar-botm">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'warehouse'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="warehouse">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'select_warehouse'); ?> --</option>
                                    <?php foreach($warehouse as $row){ ?>
                                        <option value="<?= $row['uid']; ?>" <?php if($editing_data['warehouse'] == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'item'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="item">
                                    <option class="default-opt" disabled="" selected="">-- <?= print_lang($app_lang,'select_item'); ?> --</option>
                                    <?php foreach($items as $row){
                                        $item_data = isset($items_data[$row['item']]) ? $items_data[$row['item']] : [];
                                        if(empty($item_data))
                                        {
                                            $item_data = fetch_table_where('items','uid',$row['item'],true);
                                        }
                                        $hidden = 'display-none';
                                        if($row['warehouse'] == $editing_data['warehouse'])
                                        {
                                            $hidden = null;
                                        }
                                    ?>
                                        <option class="item-opt <?= $hidden; ?>" <?php if($row['item'] == $editing_data['item']){echo "selected='selected'";}?> data-warehouse="<?= $row['warehouse']; ?>" data-purchase-unit-equalance="<?= $item_data['purchase_unit_equalance']; ?>" data-sale-unit-equalance="<?= $item_data['sale_unit_equalance']; ?>" data-production-unit-equalance="<?= $item_data['production_unit_equalance']; ?>" data-purchase-unit="<?= array_key_exists($item_data['purchase_unit'],$units) ? $units[$item_data['purchase_unit']]['name'] : NULL; ?>" data-sale-unit="<?= array_key_exists($item_data['sale_unit'],$units) ? $units[$item_data['sale_unit']]['name'] : NULL; ?>" data-production-unit="<?= array_key_exists($item_data['production_unit'],$units) ? $units[$item_data['production_unit']]['name'] : NULL; ?>" data-usd-equalance="<?= $item_data['currency_usd_equalance']; ?>" data-item-currency="<?= $item_data['currency']; ?>" value="<?= $row['item']; ?>"><?= $row['item_name']; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'batch'); ?></label>
                                <select class="form-control chosen-select" name="batch">
                                    <?php 
                                    $items_batch = get_item_warehouse_wise_batch($editing_data['item'],$editing_data['warehouse']);
                                    ?>
                                    <?php foreach($items_batch as $row){ ?>
                                        <option <?php if($editing_data['batch'] == $row['batch']){ echo 'selected="selected"'; } ?> value="<?= $row['batch']; ?>"><?= $row['batch'].' ('.$row['stock_ava'].')'; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="row extra-mar-botm">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'qty'); ?> <strong class="text-danger">*</strong></label>
                                <input type="number" class="form-control" name="qty" value="<?= $editing_data['qty']; ?>" placeholder="<?= print_lang($app_lang,'qty'); ?>">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'unit'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="unit">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'select_unit'); ?> --</option>
                                    <?php if(isset($selected_item['production_unit'])){ ?>
                                        <option value="purchase" <?php if($editing_data['unit'] == 'purchase'){ echo 'selected="selected"'; } ?>><?= array_key_exists($selected_item['purchase_unit'],$units) ? $units[$selected_item['purchase_unit']]['name'] : NULL; ?></option>
                                        <option value="sale" <?php if($editing_data['unit'] == 'sale'){ echo 'selected="selected"'; } ?>><?= array_key_exists($selected_item['sale_unit'],$units) ? $units[$selected_item['sale_unit']]['name'] : NULL; ?></option>
                                        <option value="production" <?php if($editing_data['unit'] == 'production'){ echo 'selected="selected"'; } ?>><?= array_key_exists($selected_item['production_unit'],$units) ? $units[$selected_item['production_unit']]['name'] : NULL; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'narration'); ?></label>
                                <textarea style="height: 35px;" class="form-control" name="narration" rows="3" placeholder="<?= print_lang($app_lang,'narration'); ?>"><?= $editing_data['narration']; ?></textarea>
                            </div>
                        </div>
                    </div>

                    <div class="row extra-mar-botm">
                        <div class="col-md-12 text-right">
                            <a class="btn btn-w-m btn-outline btn-danger url-elem" href="<?php echo url('/damage-stock'); ?>"><?= print_lang($app_lang,'cancel'); ?></a>
                            <button class="btn btn-w-m btn-primary" type="submit"><?= print_lang($app_lang,'update'); ?></button>
                        </div>
                    </div>

                </form>
            </div>
        </div>
    </div>

</div>