<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-8">
        <h2><?= print_lang($app_lang,'damage_stock'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'damage_stock'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-4">
        <div class="title-action">
            <?php if(check_user_access('add_damage_stock') === TRUE){ ?>
                <a href="<?php echo url('/damage-stock/add'); ?>" class="btn btn-primary btn-sm custom-font-btn"><i class="fa fa-plus"></i>&nbsp; <?= print_lang($app_lang,'add_new_damage'); ?></a>
            <?php } ?>
        </div>
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'damage_stock_listing'); ?></h2>
                    <hr>

                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center" style="width:40px;"><?= print_lang($app_lang,'sr_#'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'date'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'item'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'warehouse'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'batch'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'qty'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'unit'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'narration'); ?></th>
                                    <th class="text-center" style="min-width:120px; max-width:120px;"><?= print_lang($app_lang,'action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $total_qty = array(); $i = 1; foreach($pageData as $row){ ?>
                                    <?php
                                        $unit_name = NULL;
                                        $item_name = NULL;
                                        if(array_key_exists($row['item'], $items))
                                        {
                                            $selected_item = $items[$row['item']];
                                            $item_name = $selected_item['name'];
                                            if($row['unit'] == 'purchase')
                                            {
                                                $unit_name = array_key_exists($selected_item['purchase_unit'],$units) ? $units[$selected_item['purchase_unit']]['name'] : NULL;
                                            }
                                            if($row['unit'] == 'sale')
                                            {
                                                $unit_name = array_key_exists($selected_item['sale_unit'],$units) ? $units[$selected_item['sale_unit']]['name'] : NULL;
                                            }
                                            if($row['unit'] == 'production')
                                            {
                                                $unit_name = array_key_exists($selected_item['production_unit'],$units) ? $units[$selected_item['production_unit']]['name'] : NULL;
                                            }
                                        }
                                    ?>
                                    <tr class="text-center">
                                        <td><?= $i++; ?></td>
                                        <td><?= display_true_date(explode(' ',$row['created_at'])[0]); ?></td>
                                        <td><?= $item_name; ?></td>
                                        <td><?= array_key_exists($row['warehouse'], $warehouse) ? $warehouse[$row['warehouse']]['name'] : NULL; ?></td>
                                        <td><?= $row['batch']; ?></td>
                                        <td><?= $row['qty']; $total_qty[] = $row['qty']; ?></td>
                                        <td><?= $unit_name; ?></td>
                                        <td><?= $row['narration']; ?></td>
                                        <td>
                                            <?php if(check_user_access('edit_damage_stock') === TRUE){ ?>
                                                <a href="<?= url('/damage-stock/edit').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-primary url-elem"><i class="fa fa-pencil">&nbsp; </i><?= print_lang($app_lang,'edit'); ?></a>
                                            <?php } ?>
                                            <?php if(check_user_access('delete_damage_stock') === TRUE){ ?>
                                                <a href="<?= url('/damage-stock/delete').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-danger delete-btn-trigger" data-msg="You will not be able to revert this" data-mood="Delete"><i class="fa fa-trash"></i>&nbsp; <?= print_lang($app_lang,'delete'); ?></a>
                                            <?php } ?>
                                        </td>
                                    </tr>
                                <?php } ?>

                                <tr class="text-center">
                                    <td><?= $i++; ?></td>
                                    <td><?= display_true_date(date('Y-m-d')); ?></td>
                                    <td><?= print_lang($app_lang,'total'); ?></td>
                                    <td></td>
                                    <td></td>
                                    <td><?= round_decimels_digits(array_sum($total_qty)); ?></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                </tr>

                            </tbody>
                        </table>    
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>