<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-8">
        <h2><?= print_lang($app_lang,'mod_db_cr_nt_view_breadcrumb'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'mod_db_cr_nt_view_breadcrumb'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-4">
        <div class="title-action">
            <?php if(check_user_access('add_debit_credit_note') === TRUE){ ?>
                <a href="<?= url('/debit-credit-note/add'); ?>" class="btn btn-primary btn-sm custom-font-btn"><i class="fa fa-plus"></i>&nbsp; <?= print_lang($app_lang,'mod_db_cr_nt_view_add_btn'); ?></a>
            <?php } ?>
        </div>
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'mod_db_cr_nt_view_title'); ?></h2>

                    <form id="debit-credit-note-search-form" action="<?= url('/debit-credit-note'); ?>">
                    <div class="row">
                        <div class="col-md-8">
                            <div class="row">
                                <div class="col-md-3" style="padding: 2px;">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'currency'); ?></label>
                                        <select class="form-control chosen-select" name="currency">
                                            <option value="" selected="">-- <?= print_lang($app_lang,'currency'); ?> --</option>
                                            <?php foreach($currencies as $row){ ?>
                                                <option value="<?= $row['uid']; ?>" <?php if($search_currency == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3" style="padding: 2px;">
                                    <div class="form-group">
                                        <div class="form-group">
                                            <label><?= print_lang($app_lang,'from'); ?></label>
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($search_from); ?>" name="from" placeholder="<?= print_lang($app_lang,'from'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="from" value="<?= true_date_for_inputs($search_from); ?>">
                                        <?php } ?>
                                    </div>
                                    </div>
                                </div>
                                <div class="col-md-3" style="padding: 2px;">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'to'); ?></label>
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($search_to); ?>" name="to" placeholder="<?= print_lang($app_lang,'to'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="to" value="<?= true_date_for_inputs($search_to); ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                                <div class="col-md-3" style="padding: 2px;">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'mod_db_cr_nt_view_filter_status'); ?></label>
                                        <select class="form-control chosen-select" name="status">
                                            <option value="" selected="">-- <?= print_lang($app_lang,'mod_db_cr_nt_view_filter_status'); ?> --</option>
                                            <option <?php if($search_status == 'pending'){ echo 'selected="selected"'; } ?> value="pending"><?= print_lang($app_lang,'mod_db_cr_nt_view_filter_status_pending'); ?></option>
                                            <option <?php if($search_status == 'passed'){ echo 'selected="selected"'; } ?> value="passed"><?= print_lang($app_lang,'mod_db_cr_nt_view_filter_status_passed'); ?></option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-2 text-right" style="margin-top: 23px;">
                            <button class="btn btn-w-m btn-danger custom-font-btn-search dbcn-note-pass-elm" data-url="<?= url('/debit-credit-note/update-status'); ?>" type="button"><?= print_lang($app_lang,'pass'); ?></button>
                        </div>
                        <div class="col-md-2 text-right" style="margin-top: 23px;">
                            <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                        </div>
                    </div>
                    </form>
                    <hr>

                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center">
                                        <input type="checkbox" id="dbcn-check-all" style="margin: 5px;" name="">
                                        <?= print_lang($app_lang,'mod_db_cr_nt_view_thead_sr'); ?>
                                    </th>
                                    <th class="text-center" style="min-width:100px; max-width:100px;"><?= print_lang($app_lang,'mod_db_cr_nt_view_thead_date'); ?></th>
                                    <th class="text-center" ><?= print_lang($app_lang,'mod_db_cr_nt_view_thead_invoice'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_db_cr_nt_view_thead_account'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_db_cr_nt_view_thead_currency'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_db_cr_nt_view_thead_total'); ?></th>
                                    <th class="text-center" style="min-width:190px; max-width:190px;"><?= print_lang($app_lang,'mod_db_cr_nt_view_thead_details'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_db_cr_nt_view_thead_status'); ?></th>
                                    <th class="text-center" style="min-width:190px; max-width:190px;"><?= print_lang($app_lang,'mod_db_cr_nt_view_thead_action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $total_amount = array();
                                ?>
                                <?php $i = 1; foreach($pageData as $row){
                                    $currency_show = array_key_exists($row['currency'], $currencies) ? $currencies[$row['currency']]['name'] : NULL;
                                ?>
                                    <tr class="text-center">
                                        <td>
                                            <?php if($row['status'] == 'pending'){?>
                                                <input type="checkbox" style="margin: 5px;" class="dbcn-passing-checkbox" name="passing_checkbox" value="<?= $row['uid']; ?>">
                                            <?php } ?>
                                            <?= $i++; ?></td>
                                        <td><?= display_true_date(explode(' ',$row['created_at'])[0]); ?></td>
                                        <td><?= $row['invoice']; ?></td>
                                        <td><?= array_key_exists($row['account'], $accounts) ? $accounts[$row['account']]['name'] : NULL; ?></td>
                                        <td><?= $currency_show; ?></td>
                                        <td><?= amount_number_format((float)$row['amount']); $total_amount[] = (float)$row['amount']; ?></td>
                                        <td><?= $row['narration']; ?></td>
                                        <td>
                                            <a href="javascript:void(0);" data-url="<?= url('/debit-credit-note/update-status').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-danger url-elem dbcn-pending-item <?php if($row['status'] != 'pending'){ echo 'display-none'; } ?>"><i class="fa fa-refresh">&nbsp; </i><?= print_lang($app_lang,'pending'); ?></a>
                                            <a href="javascript:void(0);" class="btn btn-xs btn-outline btn-primary url-elem dbcn-passed-item <?php if($row['status'] == 'pending'){ echo 'display-none'; } ?>"><i class="fa fa-check">&nbsp; </i><?= print_lang($app_lang,'passed'); ?></a>
                                        </td>

                                        <td>
                                            <?php if(check_user_access('invoice_debit_credit_note') === TRUE){ ?>
                                                <a href="<?= url('/debit-credit-note/invoice').'/'.$row['uid']; ?>" target="_blank" class="btn btn-xs btn-outline btn-warning url-elem"><i class="fa fa-external-link"></i><?= print_lang($app_lang,'invoice'); ?></a>
                                            <?php } ?>
                                            <?php if(check_user_access('edit_debit_credit_note') === TRUE){ ?>
                                                <a href="<?= url('/debit-credit-note/edit').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-primary url-elem"><i class="fa fa-pencil">&nbsp; </i><?= print_lang($app_lang,'edit'); ?></a>
                                            <?php } ?>
                                            <?php if(check_user_access('delete_debit_credit_note') === TRUE){ ?>
                                                <a href="<?= url('/debit-credit-note/delete').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-danger delete-btn-trigger" data-msg="You will not be able to revert this" data-mood="Delete"><i class="fa fa-trash"></i>&nbsp; <?= print_lang($app_lang,'delete'); ?></a>
                                            <?php } ?>
                                        </td>
                                    </tr>
                                <?php } ?>
                                <tr class="text-center">
                                    <td></td>
                                    <td><strong><?= display_true_date(date('Y-m-d')); ?></strong></td>
                                    <td><strong><?= print_lang($app_lang,'total'); ?></strong></td>
                                    <td>---</td>
                                    <td></td>
                                    <td><strong><?= amount_number_format(array_sum($total_amount)); ?></strong></td>
                                    <td></td>
                                    <td>---</td>
                                    <td>---</td>
                                </tr>
                            </tbody>
                        </table>    
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>