<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'edit_employee'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/employees'); ?>"><?= print_lang($app_lang,'employees'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'edit_employee'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="ibox-title">
        <h5><?= print_lang($app_lang,'fields_with'); ?> <strong class="text-danger">*</strong> <?= print_lang($app_lang,'are_mandatory'); ?></h5>
    </div>
    <div class="ibox-content">
        <!-- spinner -->
        <div class="sk-spinner sk-spinner-three-bounce">
            <div class="sk-bounce1"></div>
            <div class="sk-bounce2"></div>
            <div class="sk-bounce3"></div>
        </div>
        <!-- spinner -->
        <div class="row">
            <div class="col-sm-12 b-r">
                <form role="form" id="employees-form" action="<?php echo url('/employees/update').'/'.$editing_data['uid']; ?>">

                    <div class="row extra-mar-botm">
                        <div class="col-md-12">
                            <h3><?= print_lang($app_lang,'personal_information'); ?></h3>
                        </div>
                    </div>

                    <div class="row extra-mar-botm">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'employee_name'); ?> <strong class="text-danger">*</strong></label>
                                <input type="text" class="form-control" name="name" value="<?= $editing_data['name']; ?>" placeholder="<?= print_lang($app_lang,'employee_name'); ?>">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'father_name'); ?> <strong class="text-danger">*</strong></label>
                                <input type="text" class="form-control" name="father_name" value="<?= $editing_data['father_name']; ?>" placeholder="<?= print_lang($app_lang,'father_name'); ?>">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'date_of_birth'); ?> <strong class="text-danger">*</strong></label>
                                <input type="date" class="form-control" name="date_of_birth" value="<?= $editing_data['date_of_birth']; ?>">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'phone'); ?> <strong class="text-danger">*</strong></label>
                                <input type="text" class="form-control" name="phone" value="<?= $editing_data['phone']; ?>" placeholder="<?= print_lang($app_lang,'phone'); ?>">
                            </div>
                        </div>
                    </div>

                    <div class="row extra-mar-botm">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'gender'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="gender">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'gender'); ?> --</option>
                                    <option value="male" <?php if($editing_data['gender'] == 'male'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'gender_male'); ?></option>
                                    <option value="female" <?php if($editing_data['gender'] == 'female'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'gender_female'); ?></option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'marital_status'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="marital_status">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'marital_status'); ?> --</option>
                                    <option value="single" <?php if($editing_data['marital_status'] == 'single'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'marital_status_single'); ?></option>
                                    <option value="married" <?php if($editing_data['marital_status'] == 'married'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'marital_status_married'); ?></option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'nationality'); ?> <strong class="text-danger">*</strong></label>
                                <input type="text" class="form-control" name="nationality" value="<?= $editing_data['nationality']; ?>" placeholder="<?= print_lang($app_lang,'nationality'); ?>">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'profile_pic'); ?></label>
                                <input type="file" class="form-control" name="profile_pic">
                            </div>
                        </div>
                    </div>

                    <div class="row extra-mar-botm">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'local_address'); ?></label>
                                <textarea class="form-control" name="local_address" rows="1" placeholder="<?= print_lang($app_lang,'local_address'); ?>"><?= $editing_data['local_address']; ?></textarea>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'permanent_address'); ?></label>
                                <textarea class="form-control" name="permanent_address" rows="1" placeholder="<?= print_lang($app_lang,'permanent_address'); ?>"><?= $editing_data['permanent_address']; ?></textarea>
                            </div>
                        </div>
                    </div>

                    <div class="row extra-mar-botm">
                        <div class="col-md-12">
                            <h3><?= print_lang($app_lang,'company_information'); ?></h3>
                        </div>
                    </div>

                    <div class="row extra-mar-botm">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'designation'); ?> <strong class="text-danger">*</strong></label>
                                <input type="text" class="form-control" name="designation" value="<?= $editing_data['designation']; ?>" placeholder="<?= print_lang($app_lang,'designation'); ?>">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'date_of_joining'); ?> <strong class="text-danger">*</strong></label>
                                <input type="date" class="form-control" name="date_of_joining" value="<?= $editing_data['date_of_joining']; ?>">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'joining_salary'); ?> <strong class="text-danger">*</strong></label>
                                <input type="number" class="form-control" name="joining_salary" value="<?= $editing_data['joining_salary']; ?>" placeholder="<?= print_lang($app_lang,'joining_salary'); ?>">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'currency'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="currency">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'currency'); ?> --</option>
                                    <?php foreach($currencies as $row){ ?>
                                        <option value="<?= $row['uid']; ?>" data-usd-equalance="<?= $row['usd_equalance']; ?>" <?php if($editing_data['currency'] == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="row extra-mar-botm">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'division'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="division">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'division'); ?> --</option>
                                    <?php foreach($division as $row){ ?>
                                        <option <?php if($editing_data['division'] == $row['uid']){ echo 'selected="selected"'; } ?> value="<?= $row['uid']; ?>"><?= $row['name']; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'employee_documents'); ?></label>
                                <input type="file" class="form-control" name="employee_documents[]" multiple="">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'employee_status'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="employee_status">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'employee_status'); ?> --</option>
                                    <option value="active" <?php if($editing_data['employee_status'] == 'active'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'active'); ?></option>
                                    <option value="not_active" <?php if($editing_data['employee_status'] == 'not_active'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'not_active'); ?></option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'employee_details'); ?></label>
                                <textarea style="height: 35px;" class="form-control" name="employee_details" rows="1" placeholder="<?= print_lang($app_lang,'employee_details'); ?>"><?= $editing_data['employee_details']; ?></textarea>
                            </div>
                        </div>
                    </div>

                    <?php
                    $employee_documents = json_decode($editing_data['employee_documents'],true);
                    ?>

                    <div class="row extra-mar-botm">
                        <?php $dcount = 1; foreach($employee_documents as $doc){ ?>
                            <div class="col-md-3 emp-doc-col text-center" style="margin-bottom: 20px;">
                                <p><?= print_lang($app_lang,'document'); ?> <?= $dcount++; ?></p>
                                <div>
                                    <a href="<?= url('/uploads/employees/').'/'.$doc; ?>" target="_blank" class="btn btn-primary btn-xs">View</a>
                                    <a href="<?= url('/employees/delete-document').'/'.$editing_data['uid'].'?name='.$doc; ?>" class="btn btn-danger btn-xs emp-doc delete-btn-trigger">Delete</a>
                                </div>
                            </div>
                        <?php } ?>
                    </div>

                    <div class="row extra-mar-botm">
                        <div class="col-md-12 text-right">
                            <a class="btn btn-w-m btn-outline btn-danger url-elem" href="<?php echo url('/employees'); ?>"><?= print_lang($app_lang,'cancel'); ?></a>
                            <button class="btn btn-w-m btn-primary" type="submit"><?= print_lang($app_lang,'update'); ?></button>
                        </div>
                    </div>

                </form>
            </div>
        </div>
    </div>

</div>