<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-8">
        <h2><?= print_lang($app_lang,'employees'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'employees'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-4">
        <div class="title-action">
            <?php if(check_user_access('add_employee') === TRUE){ ?>
                <a href="<?php echo url('/employees/add'); ?>" class="btn btn-primary btn-sm custom-font-btn"><i class="fa fa-plus"></i>&nbsp; <?= print_lang($app_lang,'add_new_employee'); ?></a>
            <?php } ?>
        </div>
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'employees_listing'); ?></h2>

                    <form id="employees-search-form" action="<?= url('/employees'); ?>">
                        <div class="row">
                            <div class="col-md-10">
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label><?= print_lang($app_lang,'division'); ?></label>
                                            <select class="form-control chosen-select" name="division">
                                                <option value="" selected="">-- <?= print_lang($app_lang,'division'); ?> --</option>
                                                <?php foreach($division as $row){ ?>
                                                    <option value="<?= $row['uid']; ?>" <?php if($search_division == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-2 text-right" style="margin-top: 23px;">
                                <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                            </div>
                        </div>
                    </form>
                    
                    <hr>

                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center" style="min-width:50px; max-width:50px;"><?= print_lang($app_lang,'sr_#'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'name'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'designation'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'phone'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'joining_date'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'joining_salary'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'currency'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'division'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'status'); ?></th>
                                    <th class="text-center" style="min-width:120px; max-width:120px;"><?= print_lang($app_lang,'action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $i = 1; foreach($pageData as $row){ ?>
                                    <tr class="text-center">
                                        <td><?= $i++; ?></td>
                                        <td><?= $row['name']; ?></td>
                                        <td><?= $row['designation']; ?></td>
                                        <td><?= $row['phone']; ?></td>
                                        <td><?= $row['date_of_joining']; ?></td>
                                        <td><?= $row['joining_salary']; ?></td>
                                        <td><?= array_key_exists($row['currency'], $currencies) ? $currencies[$row['currency']]['name'] : NULL; ?></td>
                                        <td><?= $row['division_name']; ?></td>
                                        <td><?= print_lang($app_lang,$row['employee_status']); ?></td>
                                        <td>
                                            <?php if(check_user_access('edit_employee') === TRUE){ ?>
                                                <a href="<?= url('/employees/edit').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-primary url-elem"><i class="fa fa-pencil">&nbsp; </i><?= print_lang($app_lang,'edit'); ?></a>
                                            <?php } ?>
                                            <?php if(check_user_access('delete_employee') === TRUE){ ?>
                                                <a href="<?= url('/employees/delete').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-danger delete-btn-trigger"><i class="fa fa-trash"></i>&nbsp; <?= print_lang($app_lang,'delete'); ?></a>
                                            <?php } ?>
                                        </td>
                                    </tr>
                                <?php } ?>
                            </tbody>
                        </table>    
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>