<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'add_new_expenses'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/expenses'); ?>"><?= print_lang($app_lang,'expenses'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'new_expense'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="ibox-title">
        <h5><?= print_lang($app_lang,'fields_with'); ?> <strong class="text-danger">*</strong> <?= print_lang($app_lang,'are_mandatory'); ?></h5>

        <div class="text-<?php if($app_direction == 'rtl'){echo 'left';}else{echo 'right';} ?>">
            <input style="width: 100px; border: none; background: #e0e0e0; padding: 9px 5px; text-align: center; border-radius: 2px; color: black;" type="text" class="pointer-none" value="<?= print_lang($app_lang,'add_entry_sr_num').' '.get_serial_id('expenses'); ?>" readonly="">
        </div>
    </div>
    <div class="ibox-content">
        <!-- spinner -->
        <div class="sk-spinner sk-spinner-three-bounce">
            <div class="sk-bounce1"></div>
            <div class="sk-bounce2"></div>
            <div class="sk-bounce3"></div>
        </div>
        <!-- spinner -->
        <div class="row">
            <div class="col-sm-12 b-r">
                <form role="form" id="expenses-form" action="<?php echo url('/expenses/save'); ?>">

                    <div class="row extra-mar-botm">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'type'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="type">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'select_type'); ?> --</option>
                                    <?php foreach($expenses_types as $row){ ?>
                                        <option value="<?= $row['uid']; ?>"><?= $row['name']; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'date'); ?> <strong class="text-danger">*</strong></label>
                                <?php $edate = display_true_date( date('y-m-d') ); ?>
                                <?php if($branch_calander == 'persian'){ ?>
                                    <input type="text" class="form-control persian-date" name="exp_date" value="<?= true_date_for_inputs($edate); ?>" placeholder="<?= print_lang($app_lang,'date'); ?>" readonly="" style="background: #fff;">
                                <?php }else{ ?>
                                    <input type="date" class="form-control" name="exp_date" value="<?= true_date_for_inputs($edate); ?>">
                                <?php } ?>
                            </div>
                        </div>
                    </div>

                    <div class="row extra-mar-botm">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'account'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="account">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'select_account'); ?> --</option>
                                    <?php foreach($accounts as $row){ ?>
                                        <option value="<?= $row['uid']; ?>"><?= $row['display_name']; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'amount'); ?> <strong class="text-danger">*</strong></label>
                                <input type="number" class="form-control" name="amount" placeholder="<?= print_lang($app_lang,'amount'); ?>">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'currency'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="currency">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'select_currency'); ?> --</option>
                                    <?php foreach($currencies as $row){ ?>
                                        <option value="<?= $row['uid']; ?>"><?= $row['name']; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="row extra-mar-botm">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'narration'); ?> <strong class="text-danger">*</strong></label>
                                <textarea class="form-control" name="narration" rows="3" placeholder="<?= print_lang($app_lang,'narration'); ?>"></textarea>
                            </div>
                        </div>
                    </div>

                    <div class="row extra-mar-botm">
                        <div class="col-md-12 text-right">
                            <a class="btn btn-w-m btn-outline btn-danger url-elem" href="<?php echo url('/expenses'); ?>"><?= print_lang($app_lang,'cancel'); ?></a>
                            <button class="btn btn-w-m btn-primary" type="submit"><?= print_lang($app_lang,'save'); ?></button>
                        </div>
                    </div>

                </form>
            </div>
        </div>
    </div>

</div>