<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'add_new_expense_deduction'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/expenses-deductions'); ?>"><?= print_lang($app_lang,'expenses_deductions'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'add_expense_deduction'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
    </div>
</div>

<form role="form" id="expenses-deductions-form" action="<?php echo url('/expenses-deductions/save'); ?>">
<div class="wrapper wrapper-content animated fadeInRight">
    <div class="ibox-title">
        <h5><?= print_lang($app_lang,'fields_with'); ?> <strong class="text-danger">*</strong> <?= print_lang($app_lang,'are_mandatory'); ?></h5>
        
        <div style="display: inline-block; margin-left: 150px;" id="expenses-deductions-types">
            <label class="checkbox-inline i-checks">
                <input checked="checked" type="radio" name="expenses_mood" value="cash_expenses"> &nbsp;&nbsp; <?= print_lang($app_lang,'cash_expenses'); ?>
            </label>
            <label class="checkbox-inline i-checks" style="margin-left: 30px;">
                <input type="radio" name="expenses_mood" value="inventory_expenses"> &nbsp;&nbsp; <?= print_lang($app_lang,'inventory_expenses'); ?>
            </label>
        </div>

    </div>
    <div class="ibox-content">
        <!-- spinner -->
        <div class="sk-spinner sk-spinner-three-bounce">
            <div class="sk-bounce1"></div>
            <div class="sk-bounce2"></div>
            <div class="sk-bounce3"></div>
        </div>
        <!-- spinner -->
        <div class="row">
            <div class="col-sm-12 b-r">

                    <!-- cash expenses fields -->
                    <div class="row extra-mar-botm cash-expenses-row">
                        <div class="col-md-5">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'supervisor'); ?></label>
                                        <select class="form-control chosen-select" name="supervisor">
                                            <option disabled="" selected="">-- <?= print_lang($app_lang,'select_supervisor'); ?> --</option>
                                            <?php foreach($users as $row){ ?>
                                                <option value="<?= $row['uid']; ?>"><?= $row['name']; ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'currency'); ?> <strong class="text-danger">*</strong></label>
                                        <select class="form-control chosen-select" name="currency">
                                            <option disabled="" selected="">-- <?= print_lang($app_lang,'select_currency'); ?> --</option>
                                            <?php foreach($currencies as $row){ ?>
                                                <option value="<?= $row['uid']; ?>" data-usd-equalance="<?= $row['usd_equalance']; ?>"><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-7">
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'amount'); ?> <strong class="text-danger">*</strong></label>
                                        <input type="text" class="form-control" name="amount" placeholder="<?= print_lang($app_lang,'amount'); ?>">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'date'); ?> <strong class="text-danger">*</strong></label>
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" name="cash_date" placeholder="<?= print_lang($app_lang,'date'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="cash_date">
                                        <?php } ?>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'scan_copy'); ?></label>
                                        <input type="file" class="form-control" name="scan_copy">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row extra-mar-botm cash-expenses-row">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'expense_type'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="expense_type">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'select_type'); ?> --</option>
                                    <option value="private"><?= print_lang($app_lang,'private'); ?></option>
                                    <option value="other"><?= print_lang($app_lang,'other'); ?></option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'project'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="project">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'select_project'); ?> --</option>
                                    <?php foreach($projects as $row){ ?>
                                        <option value="<?= $row['uid']; ?>" data-currency="<?= $row['currency']; ?>" data-usd-equalance="<?= $row['currency_usd_equalance']; ?>"><?= $row['name']; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'project_currency_amount'); ?></label>
                                <input type="text" class="form-control pointer-none" name="project_according_amount" placeholder="<?= print_lang($app_lang,'project_currency_amount'); ?>">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'account'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="account">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'select_account'); ?> --</option>
                                    <?php foreach($accounts as $row){ ?>
                                        <?php if($row['type'] == 'client'){ continue; } ?>
                                        <?php if($row['type'] == 'supplier'){ continue; } ?>
                                        <?php if($row['type'] == 'transit'){ continue; } ?>
                                        <option value="<?= $row['uid']; ?>"><?= $row['name']; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                    </div>
                    <!-- cash expenses fields -->


                    <!-- inventory expenses fields -->
                    <div class="row extra-mar-botm inventory-expenses-row display-none">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'supervisor'); ?></label>
                                <select class="form-control chosen-select" name="inv_supervisor">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'select_supervisor'); ?> --</option>
                                    <?php foreach($users as $row){ ?>
                                        <option value="<?= $row['uid']; ?>"><?= $row['name']; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'project'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="inv_project">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'select_project'); ?> --</option>
                                    <?php foreach($projects as $row){ ?>
                                        <option value="<?= $row['uid']; ?>" data-currency="<?= $row['currency']; ?>" data-usd-equalance="<?= $row['currency_usd_equalance']; ?>"><?= $row['name']; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'date'); ?> <strong class="text-danger">*</strong></label>
                                <?php if($branch_calander == 'persian'){ ?>
                                    <input type="text" class="form-control persian-date" name="inv_date" placeholder="<?= print_lang($app_lang,'date'); ?>" readonly="" style="background: #fff;">
                                <?php }else{ ?>
                                    <input type="date" class="form-control" name="inv_date">
                                <?php } ?>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'items'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="inv_item">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'select_item'); ?> --</option>
                                    <?php foreach($items as $row){ ?>
                                        <option value="<?= $row['uid']; ?>" data-purchase-unit-equalance="<?= $row['purchase_unit_equalance']; ?>" data-sale-unit-equalance="<?= $row['sale_unit_equalance']; ?>" data-production-unit-equalance="<?= $row['production_unit_equalance']; ?>" data-purchase-unit="<?= array_key_exists($row['purchase_unit'],$units) ? $units[$row['purchase_unit']]['name'] : NULL; ?>" data-sale-unit="<?= array_key_exists($row['sale_unit'],$units) ? $units[$row['sale_unit']]['name'] : NULL; ?>" data-production-unit="<?= array_key_exists($row['production_unit'],$units) ? $units[$row['production_unit']]['name'] : NULL; ?>" data-usd-equalance="<?= $row['currency_usd_equalance']; ?>"><?= $row['name']; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="row extra-mar-botm inventory-expenses-row display-none">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'warehouse'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="inv_warehouse">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'select_warehouse'); ?> --</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'unit'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="inv_unit">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'select_unit'); ?> --</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'qty'); ?> <strong class="text-danger">*</strong></label>
                                <input type="text" class="form-control" name="inv_qty" placeholder="<?= print_lang($app_lang,'qty'); ?>">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'total_amount'); ?></label>
                                <input type="text" class="form-control pointer-none" name="inv_total_amount" placeholder="<?= print_lang($app_lang,'total_amount'); ?>">
                                <input type="hidden" name="inv_avg_cost_usd" value="">
                            </div>
                        </div>
                    </div>
                    <!-- inventory expenses fields -->

                    <div class="row extra-mar-botm">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'comments'); ?></label>
                                <textarea rows="4" class="form-control" name="comments" placeholder="<?= print_lang($app_lang,'comments'); ?>"></textarea>
                            </div>
                        </div>
                    </div>

                    <div class="row extra-mar-botm">
                        <div class="col-md-12 text-right">
                            <a class="btn btn-w-m btn-outline btn-danger url-elem" href="<?php echo url('/expenses-deductions'); ?>"><?= print_lang($app_lang,'cancel'); ?></a>
                            <button class="btn btn-w-m btn-primary" type="submit"><?= print_lang($app_lang,'save'); ?></button>
                        </div>
                    </div>

            </div>
        </div>
    </div>

</div>

</form>