<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-8">
        <h2><?= print_lang($app_lang,'approved_expenses_deductions'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'approved_expenses_deductions'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-4">
        
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <!-- spinner -->
                    <div class="sk-spinner sk-spinner-three-bounce">
                        <div class="sk-bounce1"></div>
                        <div class="sk-bounce2"></div>
                        <div class="sk-bounce3"></div>
                    </div>
                    <!-- spinner -->

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'approved_expenses_deductions_listing'); ?></h2>
                    
                    <form id="approved-expenses-deductions-search-form" action="<?= url('/expenses-deductions/approved'); ?>">
                    <div class="row">
                        <div class="col-md-3">
                            <div class="form-group">
                                <select class="form-control chosen-select" name="expense_type">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'expense_type'); ?> --</option>
                                    <option value="cash_expenses" <?php if($search_expense_type == 'cash_expenses'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'cash_expenses'); ?></option>
                                    <option value="inventory_expenses" <?php if($search_expense_type == 'inventory_expenses'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'inventory_expenses'); ?></option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <select class="form-control chosen-select" name="project_type">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'project_type'); ?> --</option>
                                    <option value="private" <?php if($search_project_type == 'private'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'private'); ?></option>
                                    <option value="other" <?php if($search_project_type == 'other'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'other'); ?></option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <select class="form-control chosen-select" name="currency">
                                    <option value="" selected="">-- <?= print_lang($app_lang,'currency'); ?> --</option>
                                    <?php foreach($currencies as $row){ ?>
                                        <option value="<?= $row['uid']; ?>" <?php if($search_currency == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <select class="form-control chosen-select" name="project">
                                    <option value="" selected="">-- <?= print_lang($app_lang,'project'); ?> --</option>
                                    <?php foreach($projects as $row){ ?>
                                        <option value="<?= $row['uid']; ?>" <?php if($search_project == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>

                        <div class="col-md-9">
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <select class="form-control chosen-select" name="user">
                                            <option value="" selected="">-- <?= print_lang($app_lang,'user'); ?> --</option>
                                            <?php foreach($users as $row){ ?>
                                                <option value="<?= $row['uid']; ?>" <?php if($search_user == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <input type="text" class="form-control" value="<?= $search_details; ?>" name="details" placeholder="<?= print_lang($app_lang,'details'); ?>">
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($search_from); ?>" name="from" placeholder="<?= print_lang($app_lang,'from'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="from" value="<?= true_date_for_inputs($search_from); ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($search_to); ?>" name="to" placeholder="<?= print_lang($app_lang,'to'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="to" value="<?= true_date_for_inputs($search_to); ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3 text-right">
                            <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                            <a href="#" data-date="<?= display_true_date(date('Y-m-d')); ?>" class="today-date-form-trigger btn btn-primary custom-font-btn-search"><?= print_lang($app_lang,'today'); ?></a>
                        </div>
                    </div>
                    </form>

                    <hr>

                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center"><?= print_lang($app_lang,'sr_#'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'date'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'user'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'expense_type'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'account'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'unit'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'qty'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'amount'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'comments'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'receipt'); ?></th>
                                    <th class="text-center" style="min-width:200px; max-width:200px;"><?= print_lang($app_lang,'action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $i = 1;
                                $total_amount = array();

                                foreach($pageData as $row){
                                    
                                    $row_currency = array_key_exists($row['currency'],$currencies) ? $currencies[$row['currency']]['symbol'] : NULL;
                                    $image_path = '/uploads/expenses-deductions/'.$row['scan_copy'];
                                    if(is_file(base_path().$image_path))
                                    {
                                        $image_html = '<a class="btn btn-primary btn-xs" target="_blank" href="'.url('/').$image_path.'">'.print_lang($app_lang,'preview').'</a>'; // data-gallery=""
                                    }
                                    else
                                    {
                                        $image_html = '<span class="label label-info">'.print_lang($app_lang,'no_image').'</span>';
                                    }

                                    // fetch item unit
                                    $unit = NULL;
                                    if($row['expenses_mood'] == 'inventory_expenses')
                                    {
                                        $item_data = fetch_table_where('items','uid',$row['item'],true);
                                        if(isset($item_data['uid']))
                                        {
                                            if($row['unit'] == 'purchase'){ $unit = $item_data['purchase_unit']; }
                                            if($row['unit'] == 'sale'){ $unit = $item_data['sale_unit']; }
                                            if($row['unit'] == 'production'){ $unit = $item_data['production_unit']; }
                                            $unit = array_key_exists($unit,$units) ? $units[$unit]['short'] : NULL;
                                        }
                                    }
                                ?>
                                    <tr class="text-center">
                                        <td><label class="checkbox-inline"><input class="multi-checker-input" type="checkbox" value="<?= $row['uid']; ?>"><?= $i++; ?></label></td>
                                        <td><?= $row['edate']; ?></td>
                                        <td><?= array_key_exists($row['user'],$users) ? $users[$row['user']]['name'] : NULL; ?></td>
                                        <td><?= print_lang($app_lang,$row['expenses_mood']); ?></td>
                                        <td><?= array_key_exists($row['account'],$accounts) ? $accounts[$row['account']]['name'] : NULL; ?></td>
                                        <td><?= $unit; ?></td>
                                        <td><?= amount_number_format($row['qty']); ?></td>
                                        <td><?= $row_currency; ?><?= amount_number_format($row['amount']); ?><?php $total_amount[] = (float)$row['amount']; ?></td>
                                        <td><?= $row['comments']; ?></td>
                                        <td><?= $image_html; ?></td>
                                        <td>
                                            <?php if(check_user_access('disapprove_project_approved_expenses_deductions') === TRUE){ ?>
                                                <a href="<?= url('/expenses-deductions/disapprove').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-success confirm-btn-trigger"><i class="fa fa-exclamation"></i>&nbsp; <?= print_lang($app_lang,'disapprove'); ?></a>
                                            <?php } ?>
                                            <?php if(check_user_access('edit_project_approved_expenses_deductions') === TRUE){ ?>
                                                <a href="<?= url('/expenses-deductions/edit').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-primary url-elem"><i class="fa fa-pencil">&nbsp; </i><?= print_lang($app_lang,'edit'); ?></a>
                                            <?php } ?>
                                            <?php if(check_user_access('delete_project_approved_expenses_deductions') === TRUE){ ?>
                                                <a href="<?= url('/expenses-deductions/delete').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-danger delete-btn-trigger" data-msg="You will not be able to revert this" data-mood="Delete"><i class="fa fa-trash"></i>&nbsp; <?= print_lang($app_lang,'delete'); ?></a>
                                            <?php } ?>
                                        </td>
                                    </tr>
                                <?php } ?>

                                <tr class="text-center">
                                    <td><?= $i++; ?></td>
                                    <td><?= print_lang($app_lang,'total'); ?></td>
                                    <td>---</td>
                                    <td>---</td>
                                    <td>---</td>
                                    <td>---</td>
                                    <td>---</td>
                                    <td><?= amount_number_format( array_sum($total_amount) ); ?></td>
                                    <td>---</td>
                                    <td>---</td>
                                    <td>---</td>
                                </tr>

                            </tbody>
                        </table>    
                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <?php if(check_user_access('delete_batch') === TRUE){ ?>
                                <a style="margin-left: 5px;" href="javascript:void(0);" class="check-all-btn-trigger text-primary"><i class="fa fa-arrow-up"></i>&nbsp; <?= print_lang($app_lang,'check_all'); ?></a>
                                <span style="display: inline-block;margin: 0 15px; font-weight: bold;">|</span>
                                <a href="<?= url('/expenses-deductions/disapprove-all'); ?>" class="multi-approve-btn-trigger text-success"><i class="fa fa-exclamation"></i>&nbsp; <?= print_lang($app_lang,'disapprove_all'); ?></a>
                                <span style="display: inline-block;margin: 0 15px; font-weight: bold;">|</span>
                                <a href="<?= url('/expenses-deductions/delete-all'); ?>" class="multi-delete-btn-trigger text-danger"><i class="fa fa-trash"></i>&nbsp; <?= print_lang($app_lang,'delete_all'); ?></a>
                            <?php } ?>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>