<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'edit_expense_deduction'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/expenses-deductions'); ?>"><?= print_lang($app_lang,'expenses_deductions'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'edit_expense_deduction'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
    </div>
</div>


<form role="form" id="expenses-deductions-form" action="<?php echo url('/expenses-deductions/update').'/'.$editing_data['uid']; ?>">

<div class="wrapper wrapper-content animated fadeInRight">
    <div class="ibox-title">
        <h5><?= print_lang($app_lang,'fields_with'); ?> <strong class="text-danger">*</strong> <?= print_lang($app_lang,'are_mandatory'); ?></h5>
        
        <div style="display: inline-block; margin-left: 150px;" id="expenses-deductions-types">
            <label class="checkbox-inline i-checks">
                <input <?php if($editing_data['expenses_mood'] == 'cash_expenses'){ echo 'checked="checked"'; } ?> type="radio" name="expenses_mood" value="cash_expenses"> &nbsp;&nbsp; <?= print_lang($app_lang,'cash_expenses'); ?>
            </label>
            <label class="checkbox-inline i-checks" style="margin-left: 30px;">
                <input <?php if($editing_data['expenses_mood'] == 'inventory_expenses'){ echo 'checked="checked"'; } ?> type="radio" name="expenses_mood" value="inventory_expenses"> &nbsp;&nbsp; <?= print_lang($app_lang,'inventory_expenses'); ?>
            </label>
        </div>

    </div>
    <div class="ibox-content">
        <!-- spinner -->
        <div class="sk-spinner sk-spinner-three-bounce">
            <div class="sk-bounce1"></div>
            <div class="sk-bounce2"></div>
            <div class="sk-bounce3"></div>
        </div>
        <!-- spinner -->
        <div class="row">
            <div class="col-sm-12 b-r">

                    <!-- cash expenses fields -->
                    <div class="row extra-mar-botm cash-expenses-row <?php if($editing_data['expenses_mood'] == 'inventory_expenses'){ echo 'display-none'; } ?>">
                        <div class="col-md-5">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'supervisor'); ?></label>
                                        <select class="form-control chosen-select" name="supervisor">
                                            <option disabled="" selected="">-- <?= print_lang($app_lang,'select_supervisor'); ?> --</option>
                                            <?php foreach($users as $row){ ?>
                                                <option value="<?= $row['uid']; ?>" <?php if($editing_data['user'] == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'currency'); ?> <strong class="text-danger">*</strong></label>
                                        <select class="form-control chosen-select" name="currency">
                                            <option disabled="" selected="">-- <?= print_lang($app_lang,'select_currency'); ?> --</option>
                                            <?php foreach($currencies as $row){ ?>
                                                <option value="<?= $row['uid']; ?>" <?php if($editing_data['currency'] == $row['uid']){ echo 'selected="selected"'; } ?> data-usd-equalance="<?= $row['usd_equalance']; ?>"><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-7">
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'amount'); ?> <strong class="text-danger">*</strong></label>
                                        <input type="text" class="form-control" name="amount" value="<?= $editing_data['amount']; ?>" placeholder="<?= print_lang($app_lang,'amount'); ?>">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'date'); ?> <strong class="text-danger">*</strong></label>
                                        <?php $cash_date = display_true_date($editing_data['edate']); ?>
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" name="cash_date" value="<?= true_date_for_inputs($cash_date); ?>" placeholder="<?= print_lang($app_lang,'date'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="cash_date" value="<?= true_date_for_inputs($cash_date); ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'scan_copy'); ?></label>
                                        <input type="file" class="form-control" name="scan_copy">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row extra-mar-botm cash-expenses-row <?php if($editing_data['expenses_mood'] == 'inventory_expenses'){ echo 'display-none'; } ?>">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'expense_type'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="expense_type">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'select_type'); ?> --</option>
                                    <option value="private" <?php if($editing_data['expense_type'] == 'private'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'private'); ?></option>
                                    <option value="other" <?php if($editing_data['expense_type'] == 'other'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'other'); ?></option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'project'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="project">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'select_project'); ?> --</option>
                                    <?php foreach($projects as $row){ ?>
                                        <option value="<?= $row['uid']; ?>" <?php if($editing_data['project'] == $row['uid']){ echo 'selected="selected"'; } ?> data-currency="<?= $row['currency']; ?>" data-usd-equalance="<?= $row['currency_usd_equalance']; ?>"><?= $row['name']; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'project_currency_amount'); ?></label>
                                <input type="text" class="form-control pointer-none" name="project_according_amount" value="<?= $editing_data['project_according_amount']; ?>" placeholder="<?= print_lang($app_lang,'project_currency_amount'); ?>">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'account'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="account">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'select_account'); ?> --</option>
                                    <?php foreach($accounts as $row){ ?>
                                        <?php if($row['type'] == 'client'){ continue; } ?>
                                        <?php if($row['type'] == 'supplier'){ continue; } ?>
                                        <?php if($row['type'] == 'transit'){ continue; } ?>
                                        <option value="<?= $row['uid']; ?>" <?php if($editing_data['account'] == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                    </div>
                    <!-- cash expenses fields -->


                    <!-- inventory expenses fields -->
                    <div class="row extra-mar-botm inventory-expenses-row <?php if($editing_data['expenses_mood'] == 'cash_expenses'){ echo 'display-none'; } ?>">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'supervisor'); ?></label>
                                <select class="form-control chosen-select" name="inv_supervisor">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'select_supervisor'); ?> --</option>
                                    <?php foreach($users as $row){ ?>
                                        <option value="<?= $row['uid']; ?>" <?php if($editing_data['user'] == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'project'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="inv_project">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'select_project'); ?> --</option>
                                    <?php foreach($projects as $row){ ?>
                                        <option value="<?= $row['uid']; ?>" <?php if($editing_data['project'] == $row['uid']){ echo 'selected="selected"'; } ?> data-currency="<?= $row['currency']; ?>" data-usd-equalance="<?= $row['currency_usd_equalance']; ?>"><?= $row['name']; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'date'); ?> <strong class="text-danger">*</strong></label>
                                <?php $inv_date = display_true_date($editing_data['edate']); ?>
                                <?php if($branch_calander == 'persian'){ ?>
                                    <input type="text" class="form-control persian-date" name="inv_date" value="<?= true_date_for_inputs($inv_date); ?>" placeholder="<?= print_lang($app_lang,'date'); ?>" readonly="" style="background: #fff;">
                                <?php }else{ ?>
                                    <input type="date" class="form-control" name="inv_date" value="<?= true_date_for_inputs($inv_date); ?>">
                                <?php } ?>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'items'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="inv_item">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'select_item'); ?> --</option>
                                    <?php foreach($items as $row){ ?>
                                        <option value="<?= $row['uid']; ?>" <?php if($editing_data['item'] == $row['uid']){ echo 'selected="selected"'; } ?> data-purchase-unit-equalance="<?= $row['purchase_unit_equalance']; ?>" data-sale-unit-equalance="<?= $row['sale_unit_equalance']; ?>" data-production-unit-equalance="<?= $row['production_unit_equalance']; ?>" data-purchase-unit="<?= array_key_exists($row['purchase_unit'],$units) ? $units[$row['purchase_unit']]['name'] : NULL; ?>" data-sale-unit="<?= array_key_exists($row['sale_unit'],$units) ? $units[$row['sale_unit']]['name'] : NULL; ?>" data-production-unit="<?= array_key_exists($row['production_unit'],$units) ? $units[$row['production_unit']]['name'] : NULL; ?>" data-usd-equalance="<?= $row['currency_usd_equalance']; ?>"><?= $row['name']; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="row extra-mar-botm inventory-expenses-row <?php if($editing_data['expenses_mood'] == 'cash_expenses'){ echo 'display-none'; } ?>">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'warehouse'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="inv_warehouse">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'select_warehouse'); ?> --</option>
                                    <?php if(isset($item_helpers['warehouse_options'])){ foreach($item_helpers['warehouse_options'] as $warehouse_uid => $warehouse_name){ ?>
                                        <option value="<?= $warehouse_uid; ?>" <?php if($editing_data['warehouse'] == $warehouse_uid){ echo 'selected="selected"'; } ?>><?= $warehouse_name; ?></option>
                                    <?php } } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'unit'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="inv_unit">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'select_unit'); ?> --</option>
                                    <?php if(isset($item_helpers['units_options'])){ foreach($item_helpers['units_options'] as $unit => $unit_info){ ?>
                                        <option value="<?= $unit; ?>" data-unit-equalance="<?= explode('-,-',$unit_info)[0]; ?>" <?php if($editing_data['unit'] == $unit){ echo 'selected="selected"'; } ?>><?= explode('-,-',$unit_info)[1]; ?></option>
                                    <?php } } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'qty'); ?> <strong class="text-danger">*</strong></label>
                                <input type="text" class="form-control" name="inv_qty" value="<?= $editing_data['qty']; ?>" placeholder="<?= print_lang($app_lang,'qty'); ?>">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'total_amount'); ?></label>
                                <input type="text" class="form-control pointer-none" name="inv_total_amount" value="<?= $editing_data['amount']; ?>" placeholder="<?= print_lang($app_lang,'total_amount'); ?>">
                                <input type="hidden" name="inv_avg_cost_usd" value="<?= $editing_data['item_avg_cost_usd']; ?>">
                            </div>
                        </div>
                    </div>
                    <!-- inventory expenses fields -->

                    <div class="row extra-mar-botm">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'comments'); ?></label>
                                <textarea rows="4" class="form-control" name="comments" placeholder="<?= print_lang($app_lang,'comments'); ?>"><?= $editing_data['comments']; ?></textarea>
                            </div>
                        </div>
                    </div>

                    <div class="row extra-mar-botm">
                        <div class="col-md-12 text-right">
                            <a class="btn btn-w-m btn-outline btn-danger url-elem" href="<?php echo url('/expenses-deductions'); ?>"><?= print_lang($app_lang,'cancel'); ?></a>
                            <button class="btn btn-w-m btn-primary" type="submit"><?= print_lang($app_lang,'update'); ?></button>
                        </div>
                    </div>

            </div>
        </div>
    </div>

</div>

</form>