<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'edit_extra_income'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/extra-income'); ?>"><?= print_lang($app_lang,'extra_income'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'edit_extra_income'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="ibox-title">
        <h5><?= print_lang($app_lang,'fields_with'); ?> <strong class="text-danger">*</strong> <?= print_lang($app_lang,'are_mandatory'); ?></h5>

        <div class="text-<?php if($app_direction == 'rtl'){echo 'left';}else{echo 'right';} ?>">
            <input style="width: 100px; border: none; background: #e0e0e0; padding: 9px 5px; text-align: center; border-radius: 2px; color: black;" type="text" class="pointer-none" value="<?= print_lang($app_lang,'add_entry_sr_num').' '.$editing_data['serial_id']; ?>" readonly="">
        </div>
    </div>
    <div class="ibox-content">
        <!-- spinner -->
        <div class="sk-spinner sk-spinner-three-bounce">
            <div class="sk-bounce1"></div>
            <div class="sk-bounce2"></div>
            <div class="sk-bounce3"></div>
        </div>
        <!-- spinner -->
        
        <div class="row">
            <div class="col-sm-12 b-r">
                <form role="form" id="extra-income-form" action="<?php echo url('/extra-income/update').'/'.$editing_data['uid']; ?>">
                    <div class="row extra-mar-botm">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'currency'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="currency">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'select_currency'); ?> --</option>
                                    <?php foreach($currencies as $row){ ?>
                                        <option value="<?= $row['uid']; ?>" <?php if($editing_data['currency'] == $row['uid']){echo "selected='selected'";}?> data-usd-equalance="<?= $row['usd_equalance']; ?>" ><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'account'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="account">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'select_account'); ?> --</option>
                                    <?php foreach($accounts as $row){ ?>
                                        <option value="<?= $row['uid']; ?>" <?php if($editing_data['account'] == $row['uid']){echo "selected='selected'";}?>><?= $row['name']; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'amount'); ?> <strong class="text-danger">*</strong></label>
                                <input type="number" name="amount" class="form-control" placeholder="1000" value="<?= $editing_data['amount']; ?>">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'date'); ?></label>
                                <?php $edate = display_true_date( explode(' ',$editing_data['created_at'])[0] ); ?>
                                <?php if($branch_calander == 'persian'){ ?>
                                    <input type="text" class="form-control persian-date" name="edate" value="<?= true_date_for_inputs($edate); ?>" placeholder="<?= print_lang($app_lang,'date'); ?>" readonly="" style="background: #fff;">
                                <?php }else{ ?>
                                    <input type="date" class="form-control" name="edate" value="<?= true_date_for_inputs($edate); ?>">
                                <?php } ?>
                            </div>
                        </div>
                    </div>

                    <div class="row extra-mar-botm">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'extra_income_type'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="type">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'select_type'); ?> --</option>
                                    <?php foreach($extra_income_type as $row){ ?>
                                        <option <?php if($editing_data['type'] == $row['uid']){ echo 'selected="selected"'; } ?> value="<?= $row['uid']; ?>"><?= $row['name']; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-9">
                            <label><?= print_lang($app_lang,'extra_income_description'); ?></label>
                            <textarea class="form-control" rows="1" name="description" placeholder="<?= print_lang($app_lang,'extra_income_description'); ?>"><?= $editing_data['description']; ?></textarea>
                        </div>
                    </div>

                    <div class="row extra-mar-botm">
                        <div class="col-md-12 text-right">
                            <button class="btn btn-w-m btn-primary" type="submit"><?= print_lang($app_lang,'update'); ?></button>
                        </div>
                    </div>

                </form>
            </div>
        </div>

    </div>

</div>