<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-8">
        <h2><?= print_lang($app_lang,'extra_income'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'extra_income'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-4">
        <div class="title-action">
            <?php if(check_user_access('add_production') === TRUE){ ?>
                <a href="<?= url('/extra-income/add'); ?>" class="btn btn-primary btn-sm custom-font-btn"><i class="fa fa-plus"></i>&nbsp; <?= print_lang($app_lang,'add_new_extra_income'); ?></a>
            <?php } ?>
        </div>
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'extra_income_listing'); ?></h2>

                    <form id="extra-income-search-form" action="<?= url('/extra-income'); ?>">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="row">
                                <div class="col-md-3" style="padding: 2px;">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'currency'); ?></label>
                                        <select class="form-control chosen-select" name="currency">
                                            <option value="" selected="">-- <?= print_lang($app_lang,'currency'); ?> --</option>
                                            <?php foreach($currencies as $row){ ?>
                                                <option value="<?= $row['uid']; ?>" <?php if($search_currency == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3" style="padding: 2px;">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'convert_currency'); ?></label>
                                        <select class="form-control chosen-select" name="convert_currency">
                                            <option value="" selected="">-- <?= print_lang($app_lang,'convert_currency'); ?> --</option>
                                            <?php foreach($currencies as $row){ ?>
                                                <option value="<?= $row['uid']; ?>" <?php if($search_convert_currency == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3" style="padding: 2px;">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'type'); ?></label>
                                        <select class="form-control chosen-select" name="type">
                                            <option value="" selected="">-- <?= print_lang($app_lang,'select_type'); ?> --</option>
                                            <?php foreach($extra_income_type as $row){ ?>
                                                <option value="<?= $row['uid']; ?>" <?php if($search_type == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3" style="padding: 2px;">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'account'); ?></label>
                                        <select class="form-control chosen-select" name="account">
                                            <option value="" selected="">-- <?= print_lang($app_lang,'account'); ?> --</option>
                                            <?php foreach($accounts as $row){ ?>
                                                <option value="<?= $row['uid']; ?>" <?php if($search_account == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3" style="padding: 2px;">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'from'); ?></label>
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($search_from); ?>" name="from" placeholder="<?= print_lang($app_lang,'from'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="from" value="<?= true_date_for_inputs($search_from); ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                                <div class="col-md-3" style="padding: 2px;">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'to'); ?></label>
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($search_to); ?>" name="to" placeholder="<?= print_lang($app_lang,'to'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="to" value="<?= true_date_for_inputs($search_to); ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                                <div class="col-md-3" style="margin-top: 23px;">
                                    <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                                    <a href="#" data-date="<?= display_true_date(date('Y-m-d')); ?>" class="today-date-form-trigger btn btn-primary custom-font-btn-search"><?= print_lang($app_lang,'today'); ?></a>
                                </div>
                            </div>
                        </div>
                        
                    </div>
                    </form>
                    <hr>

                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center"><?= print_lang($app_lang,'sr_#'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'date'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'type'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'account'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'currency'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'amount'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'extra_income_description'); ?></th>
                                    <th class="text-center" style="min-width:120px; max-width:120px;"><?= print_lang($app_lang,'action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $total_amount = array();
                                ?>
                                <?php $i = 1; foreach($pageData as $row){

                                    $currency_show = array_key_exists($row['currency'], $currencies) ? $currencies[$row['currency']]['name'] : NULL;
                                    $amount = $row['amount'];
                                    if(!empty($search_convert_currency))
                                    {
                                        $convert_currency_record = fetch_table_where('currency','uid',$search_convert_currency,true);
                                        $currency_show = $convert_currency_record['name'];
                                        $amount_currency_equalance = $row['currency_usd_equalance'];
                                        $convert_currency_equalance = $convert_currency_record['usd_equalance'];
                                        if($row['currency'] == $search_convert_currency)
                                        {
                                            $amount_currency_equalance = 1;
                                            $convert_currency_equalance = 1;
                                        }
                                        $amount = amount_conversion($row['amount'], $amount_currency_equalance, $convert_currency_equalance);
                                    }
                                    $total_amount[] = $amount;
                                ?>
                                    <tr class="text-center">
                                        <td><?= $i++; ?></td>
                                        <td><?= display_true_date($row['created_at']); ?></td>
                                        <td><?= $row['type_name']; ?></td>
                                        <td><?= $currency_show; ?></td>
                                        <td><?= array_key_exists($row['account'], $accounts) ? $accounts[$row['account']]['name'] : NULL; ?></td>
                                        <td><?= round_decimels_digits($amount); ?></td>
                                        <td><?= $row['description']; ?></td>
                                        <td>
                                            <?php 
                                            $edit_url = url('/extra-income/edit').'/'.$row['uid'];
                                            if($row['is_journal'] == 'yes')
                                            {
                                                $edit_url = url('/journal/edit').'/'.$row['journal_uid'];
                                            }
                                            ?>
                                            <?php if(check_user_access('edit_production') === TRUE){ ?>
                                                <a href="<?= $edit_url; ?>" class="btn btn-xs btn-outline btn-primary url-elem"><i class="fa fa-pencil">&nbsp; </i><?= print_lang($app_lang,'edit'); ?></a>
                                            <?php } ?>
                                            <?php if($row['is_journal'] == 'no'){?>
                                            <?php if(check_user_access('delete_production') === TRUE){ ?>
                                                <a href="<?= url('/extra-income/delete').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-danger delete-btn-trigger" data-msg="You will not be able to revert this" data-mood="Delete"><i class="fa fa-trash"></i>&nbsp; <?= print_lang($app_lang,'delete'); ?></a>
                                            <?php } ?>
                                            <?php } ?>
                                        </td>
                                    </tr>
                                <?php } ?>
                                <tr class="text-center">
                                    <td><strong></strong></td>
                                    <td><strong><?= display_true_date(date('Y-m-d')); ?></strong></td>
                                    <td></td>
                                    <td><strong><?= print_lang($app_lang,'total'); ?></strong></td>
                                    <td></td>
                                    <td><strong><?= round_decimels_digits(array_sum($total_amount)); ?></strong></td>
                                    <td></td>
                                    <td></td>
                                </tr>
                            </tbody>
                        </table>    
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>