<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'day_closing_financial_view_title'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/reports'); ?>"><?= print_lang($app_lang,'reports'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'day_closing_breadcrumb'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
        
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'day_closing_view_title_heading'); ?></h2>

                    <form id="day-closing-report-search-form" action="<?= url('/day-closing'); ?>">
                    <div class="row">
                        <div class="col-md-9">
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <div class="input-group date" style="width: 100%;">
                                            <select class="form-control chosen-select" name="currency">
                                                <option disabled="" selected="">-- <?= print_lang($app_lang,'day_closing_view_title_filter_currency'); ?> --</option>
                                                <?php foreach($currencies as $row){ ?>
                                                    <option value="<?= $row['uid']; ?>" <?php if($search_currency == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <div class="input-group date" style="width: 100%;">
                                            <select class="form-control chosen-select" name="account">
                                                <option value="" selected="">-- <?= print_lang($app_lang,'day_closing_view_title_filter_account'); ?> --</option>
                                                <?php foreach($accounts as $row){ ?>
                                                    <option value="<?= $row['uid']; ?>" <?php if($search_account == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= $search_from; ?>" name="from" placeholder="<?= print_lang($app_lang,'day_closing_view_title_filter_from'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="from" value="<?= $search_from; ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= $search_to; ?>" name="to" placeholder="<?= print_lang($app_lang,'day_closing_view_title_filter_to'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="to" value="<?= $search_to; ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-2 text-right">
                            <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                        </div>
                        <div class="col-md-1">
                            <a target="_blank" href="<?= url('/day-closing-print').'?currency='.$search_currency.'&from='.$search_from.'&to='.$search_to.'&account='.$search_account.''; ?>" class="btn btn-outline btn-primary dim"><i class="fa fa-print"></i></a>
                        </div>
                    </div>
                    </form>
                    <hr>

                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center" style="width:40px;"><?= print_lang($app_lang,'day_closing_view_thead_sr'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'day_closing_view_thead_date'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'day_closing_view_thead_module'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'day_closing_view_thead_description'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'day_closing_view_thead_dr_account'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'day_closing_view_thead_debit'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'day_closing_view_thead_cr_account'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'day_closing_view_thead_credit'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $sr = 1; $debits = []; $credits = []; foreach($day_closing_records as $row){?>
                                    <tr class="text-center">
                                        <td><?= $sr++; ?></td>
                                        <td><?= date('d/m/Y',strtotime(display_true_date($row['date']))); ?></td>
                                        <td><?= $row['module']; ?></td>
                                        <td><?= $row['details']; ?></td>
                                        <td><?= $row['dr_account']; ?></td>
                                        <td><?= amount_number_format($row['debit']); $debits[] = $row['debit']; ?></td>
                                        <td><?= $row['cr_account']; ?></td>
                                        <td><?= amount_number_format($row['credit']); $credits[] = $row['credit']; ?></td>
                                    </tr>            
                                <?php } ?>
                                    <tr class="text-center">
                                        <td><strong><?= $sr++; ?></strong></td>
                                        <td><strong><?= print_lang($app_lang,'total'); ?></strong></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td><strong><?= amount_number_format(array_sum($debits)); ?></strong></td>
                                        <td></td>
                                        <td><strong><?= amount_number_format(array_sum($credits)); ?></strong></td>
                                    </tr>
                            </tbody>
                        </table>    
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>s