<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'financial_balance_sheet_title_top'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/reports'); ?>"><?= print_lang($app_lang,'reports'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'financial_balance_sheet_title'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
        
    </div>
</div>

<?php

$total_current_assets = [];
$total_fixed_assets = [];
$total_liabilities = [];
$total_equity = [];


$cash_calculated_balance = isset($pageData['cash_all_in_main_currency']) ? $pageData['cash_all_in_main_currency'] : null;
$total_current_assets[] = $cash_calculated_balance;

$bank_calculated_balance = isset($pageData['banks_all_in_main_currency']) ? $pageData['banks_all_in_main_currency'] : null;
$total_current_assets[] = $bank_calculated_balance;

$inventory_amount = isset($pageData['inventory_all_in_main_currency']) ? $pageData['inventory_all_in_main_currency'] : null;
$purchase_order_amount = isset($pageData['purchase_order_all_in_main_currency']) ? $pageData['purchase_order_all_in_main_currency'] : null;
$ava_cars_amount = isset($pageData['cars_all_in_main_currency']) ? $pageData['cars_all_in_main_currency'] : null;
$ava_tankers_amount = isset($pageData['lots_all_in_main_currency']) ? $pageData['lots_all_in_main_currency'] : null;
$total_inventory = $inventory_amount + $purchase_order_amount + $ava_cars_amount + $ava_tankers_amount;
$total_current_assets[] = $total_inventory;

$receivable_amount = isset($pageData['receivable_all_in_main_currency']) ? $pageData['receivable_all_in_main_currency'] : null;
$total_current_assets[] = $receivable_amount;




if(!empty($pageData['assets'])){
    $assets_types_counts = count($pageData['assets']);
    foreach($pageData['assets'] as $row){
        if(!empty($row['amount']) AND array_sum($row['amount']) != 0){
            $total_fixed_assets[] = array_sum($row['amount']);
        }
    }
}




$payable_amount = isset($pageData['payable_all_in_main_currency']) ? $pageData['payable_all_in_main_currency'] : null;
$total_liabilities[] = $payable_amount;



$capital_amount = isset($pageData['capitals_all_in_main_currency']) ? $pageData['capitals_all_in_main_currency'] : null;
$shareholder_credit_amount = isset($pageData['shareholder_credit_all_in_main_currency']) ? $pageData['shareholder_credit_all_in_main_currency'] : null;
$items_amount = isset($pageData['items_all_in_main_currency']) ? $pageData['items_all_in_main_currency'] : null;
$opening_balance = isset($pageData['opening_balance_all_in_main_currency']) ? $pageData['opening_balance_all_in_main_currency'] : null;
$total_capital_amount = $capital_amount - $shareholder_credit_amount + $items_amount + $opening_balance;
$total_equity[] = $total_capital_amount;


$other_income = isset($pageData['other_income_all_in_main_currency']) ? $pageData['other_income_all_in_main_currency'] : null;
$total_equity[] = $other_income;

$sales_services_amount = isset($pageData['custom_sales_all_in_main_currency']) ? $pageData['custom_sales_all_in_main_currency'] : null;
$services_sales = isset($pageData['services_all_in_main_currency']) ? $pageData['services_all_in_main_currency'] : null;
$earnings = isset($pageData['earnings_all_in_main_currency']) ? $pageData['earnings_all_in_main_currency'] : null;
$expenses = isset($pageData['expenses_all_in_main_currency']) ? $pageData['expenses_all_in_main_currency'] : null;
$tokens = isset($pageData['tokens_all_in_main_currency']) ? $pageData['tokens_all_in_main_currency'] : null;
$turnover_amount = isset($pageData['turnover_all_in_main_currency']) ? $pageData['turnover_all_in_main_currency'] : null;
$total_earnings = $services_sales + $sales_services_amount + $earnings - $expenses - $tokens - $turnover_amount;

$total_equity[] = $total_earnings;
$total_equity[] = $turnover_amount;


$overall_assets = array_sum($total_current_assets) + array_sum($total_fixed_assets);
$overall_equity = array_sum($total_liabilities) + array_sum($total_equity);

$exchange_profit_loss = $overall_assets - $overall_equity;
$total_equity[] = $exchange_profit_loss;

$overall_assets = array_sum($total_current_assets) + array_sum($total_fixed_assets);
$overall_equity = array_sum($total_liabilities) + array_sum($total_equity);









?>


<div class="wrapper wrapper-content animated fadeInRight">

    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content" style="padding: 10px !important;">                    
                    <form id="financial-balance-sheet-search-form" action="<?= url('/balance-sheet'); ?>">
                    <div class="row">
                        <div class="col-md-10">
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group" style="margin-bottom: 0px;">
                                        <div class="input-group date">
                                            <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                            <select class="form-control chosen-select" name="currency">
                                                <option value="" selected="">-- <?= print_lang($app_lang,'select_currency'); ?> --</option>
                                                <?php foreach($currencies as $row){ ?>
                                                    <option value="<?= $row['uid']; ?>" <?php if($search_currency == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-2 text-right">
                            <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                        </div>
                    </div>
                    </form>

                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content" style="padding: 10px !important; background: #e2fbe1 !important;">

                    <div class="row" style="margin-bottom: 12px;">
                        <div class="col-lg-12 text-center">
                            <?php $branch_data = fetch_table_where('branches','uid',active_branch_id(),true); ?>
                            <h3 style="font-size: 30px; font-weight: 900; color: #000; font-style: italic; text-decoration: underline;"><?= ucwords($branch_data['branch_name']); ?></h3>
                            <h3 style="font-size: 24px; font-weight: 900; color: #000; font-style: italic;"><?= print_lang($app_lang,'financial_balance_sheet_title'); ?></h3>
                            <h3 style="font-size: 18px; font-weight: 900; color: #000; font-style: italic;"><?= print_lang($app_lang,'date').':'; ?>&nbsp;<?= get_persian_date(date('Y-m-d')).' - '.date('Y-m-d'); ?></h3>
                        </div>
                    </div>

                    <div class="row">

                        <div class="col-md-6">

                            <table style="width: 100%;">
                                <tr style="border-bottom: 3px solid #2B9C1B !important;">
                                    <td colspan="3" style="border-bottom: 3px solid #2B9C1B !important;"><span style="font-size: 20px; font-weight: 900; color: #000;"><?= print_lang($app_lang,'financial_balance_sheet_title_assets'); ?></span></td>
                                </tr>
                                <tr style="height: 25px;">
                                    <td colspan="3"></td>
                                </tr>
                                <tr>
                                    <td colspan="3" style="font-size: 18px; font-weight: 700; color: #000; font-style: italic; padding-bottom: 10px;"><?= print_lang($app_lang,'financial_balance_sheet_title_current_assets'); ?></td>
                                </tr>
                                <tr style="font-weight: 500 !important; height: 30px;">
                                    <td style="width: 70%; padding: 0px 30px; color: #000; font-weight: 500 !important; font-size: 14px;"><?= print_lang($app_lang,'financial_balance_sheet_title_cash'); ?></td>
                                    <td style="width: 10%; text-align: center; color: #000;"><?= $currency_data['symbol']; ?></td>

                                    <td style="width: 20%; text-align: center; color: #000;"><?= amount_number_format($cash_calculated_balance); ?></td>
                                </tr>
                                <tr style="font-weight: 500 !important; height: 30px;">
                                    <td style="width: 70%; padding: 0px 30px; color: #000; font-weight: 500 !important; font-size: 14px;"><?= print_lang($app_lang,'financial_balance_sheet_title_bank'); ?></td>
                                    <td style="width: 10%; text-align: center; color: #000;"><?= $currency_data['symbol']; ?></td>

                                    <td style="width: 20%; text-align: center; color: #000;"><?= amount_number_format($bank_calculated_balance); ?></td>
                                </tr>

                                <tr style="font-weight: 500 !important; height: 30px;">
                                    <td style="width: 70%; padding: 0px 30px; color: #000; font-weight: 500 !important; font-size: 14px;"><?= print_lang($app_lang,'financial_balance_sheet_title_inventory'); ?></td>
                                    <td style="width: 10%; text-align: center; color: #000;"><?= $currency_data['symbol']; ?></td>
                                    
                                    <td style="width: 20%; text-align: center; color: #000;"><?= amount_number_format($total_inventory); ?></td>
                                </tr>

                                <tr style="font-weight: 500 !important; height: 30px;">
                                    <td style="width: 70%; padding: 0px 30px; color: #000; font-weight: 500 !important; font-size: 14px;"><?= print_lang($app_lang,'financial_balance_sheet_title_receivable'); ?></td>
                                    <td style="width: 10%; text-align: center; color: #000;"><?= $currency_data['symbol']; ?></td>

                                    <td style="width: 20%; text-align: center; color: #000;"><?= amount_number_format($receivable_amount); ?></td>
                                </tr>

                                <tr style="border-bottom: 3px solid #2B9C1B !important;">
                                    <td style="width: 70%; padding-top: 10px; border-bottom: 3px solid #2B9C1B !important; font-style: italic;"><span style="font-size: 16px; font-weight: 900; color: #000;"><?= print_lang($app_lang,'financial_balance_sheet_title_total_current_assets'); ?></span></td>
                                    <td style="width: 10%; padding-top: 10px; text-align: center; border-bottom: 3px solid #2B9C1B !important;"><span style="font-size: 16px; font-weight: 900; color: #000;"><?= $currency_data['symbol']; ?></span></td>
                                    <td style="width: 20%; padding-top: 10px; text-align: center; border-bottom: 3px solid #2B9C1B !important;"><span style="font-size: 16px; font-weight: 900; color: #000;"><?= amount_number_format(array_sum($total_current_assets)); ?></span></td>
                                </tr>
                            </table>



                            <table style="width: 100%;">
                                <tr style="height: 25px;">
                                    <td colspan="3"></td>
                                </tr>
                                <tr>
                                    <td colspan="3" style="font-size: 18px; font-weight: 700; color: #000; font-style: italic; padding-bottom: 10px;"><?= print_lang($app_lang,'financial_balance_sheet_title_fixed_assets'); ?></td>
                                </tr>

                                <?php 
                                $assets_types_counts = 0;
                                if(!empty($pageData['assets'])){
                                    $assets_types_counts = count($pageData['assets']);
                                    foreach($pageData['assets'] as $row){
                                        if(!empty($row['amount']) AND array_sum($row['amount']) != 0){
                                ?>
                                    <tr style="font-weight: 500 !important; height: 30px;">
                                        <td style="width: 70%; padding: 0px 30px; color: #000; font-weight: 500 !important; font-size: 14px;"><?= $row['name']; ?></td>
                                        <td style="width: 10%; text-align: center; color: #000;"><?= $currency_data['symbol']; ?></td>
                                        <td style="width: 20%; text-align: center; color: #000;"><?= amount_number_format(array_sum($row['amount'])); ?></td>
                                    </tr>

                                <?php }}} ?>

                                <?php
                                    $missing_assets_rows = 5 - $assets_types_counts;
                                    for ($i=1; $i <= $missing_assets_rows; $i++){ ?>
                                        <tr style="height: 30px;">
                                            <td colspan="3"></td>
                                        </tr>
                                <?php } ?>

                                <tr style="border-bottom: 3px solid #2B9C1B !important;">
                                    <td style="width: 70%; padding-top: 10px; border-bottom: 3px solid #2B9C1B !important; font-style: italic;"><span style="font-size: 16px; font-weight: 900; color: #000;"><?= print_lang($app_lang,'financial_balance_sheet_title_total_fixed_assets'); ?></span></td>
                                    <td style="width: 10%; padding-top: 10px; text-align: center; border-bottom: 3px solid #2B9C1B !important;"><span style="font-size: 16px; font-weight: 900; color: #000;"><?= $currency_data['symbol']; ?></span></td>
                                    <td style="width: 20%; padding-top: 10px; text-align: center; border-bottom: 3px solid #2B9C1B !important;"><span style="font-size: 16px; font-weight: 900; color: #000;"><?= amount_number_format(array_sum($total_fixed_assets)); ?></span></td>
                                </tr>
                            </table>

                        </div>



                        <div class="col-md-6">

                            <table style="width: 100%;">
                                <tr style="border-bottom: 3px solid #2B9C1B !important;">
                                    <td colspan="3" style="border-bottom: 3px solid #2B9C1B !important;"><span style="font-size: 20px; font-weight: 900; color: #000;"><?= print_lang($app_lang,'financial_balance_sheet_title_liabilities_and_equity'); ?></span></td>
                                </tr>
                                <tr style="height: 25px;">
                                    <td colspan="3"></td>
                                </tr>
                                <tr>
                                    <td colspan="3" style="font-size: 18px; font-weight: 700; color: #000; font-style: italic; padding-bottom: 10px;"><?= print_lang($app_lang,'financial_balance_sheet_title_current_liabilities'); ?></td>
                                </tr>
                                <tr style="font-weight: 500 !important; height: 30px;">
                                    <td style="width: 70%; padding: 0px 30px; color: #000; font-weight: 500 !important; font-size: 14px;"><?= print_lang($app_lang,'financial_balance_sheet_title_accounts_payable'); ?></td>
                                    <td style="width: 10%; text-align: center; color: #000;"><?= $currency_data['symbol']; ?></td>
                                    
                                    <td style="width: 20%; text-align: center; color: #000;"><?= amount_number_format($payable_amount); ?></td>
                                </tr>
                                <tr style="font-weight: 500 !important; height: 30px;">
                                    <td style="width: 70%; padding: 0px 30px; color: #000; font-weight: 500 !important; font-size: 14px;"><?= print_lang($app_lang,'financial_balance_sheet_title_bank_loans'); ?></td>
                                    <td style="width: 10%; text-align: center; color: #000;"><?= $currency_data['symbol']; ?></td>
                                    <td style="width: 20%; text-align: center; color: #000;">0</td>
                                </tr>

                                <tr style="height: 30px;">
                                    <td colspan="3"></td>
                                </tr>
                                <tr style="height: 30px;">
                                    <td colspan="3"></td>
                                </tr>
                                <tr style="border-bottom: 3px solid #2B9C1B !important;">
                                    <td style="width: 70%; padding-top: 10px; border-bottom: 3px solid #2B9C1B !important; font-style: italic;"><span style="font-size: 16px; font-weight: 900; color: #000;"><?= print_lang($app_lang,'financial_balance_sheet_title_total_current_liabilities'); ?></span></td>
                                    <td style="width: 10%; padding-top: 10px; text-align: center; border-bottom: 3px solid #2B9C1B !important;"><span style="font-size: 16px; font-weight: 900; color: #000;"><?= $currency_data['symbol']; ?></span></td>
                                    <td style="width: 20%; padding-top: 10px; text-align: center; border-bottom: 3px solid #2B9C1B !important;"><span style="font-size: 16px; font-weight: 900; color: #000;"><?= amount_number_format(array_sum($total_liabilities)); ?></span></td>
                                </tr>
                            </table>



                            <table style="width: 100%;">
                                <tr style="height: 25px;">
                                    <td colspan="3"></td>
                                </tr>
                                <tr>
                                    <td colspan="3" style="font-size: 18px; font-weight: 700; color: #000; font-style: italic; padding-bottom: 10px;"><?= print_lang($app_lang,'financial_balance_sheet_title_equity'); ?></td>
                                </tr>
                                <tr style="font-weight: 500 !important; height: 30px;">
                                    <td style="width: 70%; padding: 0px 30px; color: #000; font-weight: 500 !important; font-size: 14px;"><?= print_lang($app_lang,'financial_balance_sheet_title_capital'); ?></td>
                                    <td style="width: 10%; text-align: center; color: #000;"><?= $currency_data['symbol']; ?></td>
                                    
                                    <td style="width: 20%; text-align: center; color: #000;"><?= amount_number_format($total_capital_amount); ?></td>
                                </tr>

                                <tr style="font-weight: 500 !important; height: 30px;">
                                    <td style="width: 70%; padding: 0px 30px; color: #000; font-weight: 500 !important; font-size: 14px;"><?= print_lang($app_lang,'financial_balance_sheet_title_others'); ?></td>
                                    <td style="width: 10%; text-align: center; color: #000;"><?= $currency_data['symbol']; ?></td>
                                    
                                    <td style="width: 20%; text-align: center; color: #000;"><?= amount_number_format($other_income); ?></td>
                                </tr>

                                <tr style="font-weight: 500 !important; height: 30px;">
                                    <td style="width: 70%; padding: 0px 30px; color: #000; font-weight: 500 !important; font-size: 14px;"><?= print_lang($app_lang,'financial_balance_sheet_title_earnings'); ?></td>
                                    <td style="width: 10%; text-align: center; color: #000;"><?= $currency_data['symbol']; ?></td>
                                    
                                    <td style="width: 20%; text-align: center; color: #000;"><?= amount_number_format($total_earnings); ?></td>
                                </tr>

                                <tr style="font-weight: 500 !important; height: 30px;">
                                    <td style="width: 70%; padding: 0px 30px; color: #000; font-weight: 500 !important; font-size: 14px;"><?= print_lang($app_lang,'financial_balance_sheet_title_turnover'); ?></td>
                                    <td style="width: 10%; text-align: center; color: #000;"><?= $currency_data['symbol']; ?></td>
                                    
                                    <td style="width: 20%; text-align: center; color: #000;"><?= amount_number_format($turnover_amount); ?></td>
                                </tr>

                                <tr style="font-weight: 500 !important; height: 30px;">
                                    <td style="width: 70%; padding: 0px 30px; color: #000; font-weight: 500 !important; font-size: 14px;"><?= print_lang($app_lang,'financial_balance_sheet_title_exchange_profit_loss'); ?></td>
                                    <td style="width: 10%; text-align: center; color: #000;"><?= $currency_data['symbol']; ?></td>
                                    
                                    <td style="width: 20%; text-align: center; color: #000;"><?= amount_number_format($exchange_profit_loss); ?></td>
                                </tr>

                                <?php
                                    $extra_assets_rows = $assets_types_counts - 3;
                                    if($extra_assets_rows > 0){
                                    for ($i=1; $i <= $extra_assets_rows; $i++){ ?>
                                        <tr style="height: 30px;">
                                            <td colspan="3"></td>
                                        </tr>
                                <?php }} ?>

                                <tr style="border-bottom: 3px solid #2B9C1B !important;">
                                    <td style="width: 70%; padding-top: 10px; border-bottom: 3px solid #2B9C1B !important; font-style: italic;"><span style="font-size: 16px; font-weight: 900; color: #000;"><?= print_lang($app_lang,'financial_balance_sheet_title_total_equity'); ?></span></td>
                                    <td style="width: 10%; padding-top: 10px; text-align: center; border-bottom: 3px solid #2B9C1B !important;"><span style="font-size: 16px; font-weight: 900; color: #000;"><?= $currency_data['symbol']; ?></span></td>
                                    <td style="width: 20%; padding-top: 10px; text-align: center; border-bottom: 3px solid #2B9C1B !important;"><span style="font-size: 16px; font-weight: 900; color: #000;"><?= amount_number_format(array_sum($total_equity)); ?></span></span></td>
                                </tr>
                            </table>

                        </div>


                    </div>

                    <div class="row" style="margin-top: 30px; padding-bottom: 20px;">
                        <div class="col-md-6">
                            <table style="width: 100%;">
                                <tr style="border-bottom: 3px solid #2B9C1B !important;">
                                    <td style="border-bottom: 3px solid #2B9C1B !important; width: 70%;"><span style="font-size: 20px; font-weight: 900; color: #000;"><?= print_lang($app_lang,'financial_balance_sheet_title_total_assets'); ?></span></td>
                                    <td style="text-align: center; border-bottom: 3px solid #2B9C1B !important; width: 10%;"><span style="font-size: 20px; font-weight: 900; color: #000;"><?= $currency_data['symbol']; ?></span></td>
                                    
                                    <td style="text-align: center; border-bottom: 3px solid #2B9C1B !important; width: 20%;"><span style="font-size: 20px; font-weight: 900; color: #000;"><?= amount_number_format($overall_assets); ?></span></td>
                                </tr>
                            </table>
                        </div>
                        <div class="col-md-6">
                            <table style="width: 100%;">
                                <tr style="border-bottom: 3px solid #2B9C1B !important;">
                                    <td style="border-bottom: 3px solid #2B9C1B !important; width: 70%;"><span style="font-size: 20px; font-weight: 900; color: #000;"><?= print_lang($app_lang,'financial_balance_sheet_title_total_liabilities_equity'); ?></span></td>
                                    <td style="text-align: center; border-bottom: 3px solid #2B9C1B !important; width: 10%;"><span style="font-size: 20px; font-weight: 900; color: #000;"><?= $currency_data['symbol']; ?></span></td>
                                    
                                    <td style="text-align: center; border-bottom: 3px solid #2B9C1B !important; width: 20%;"><span style="font-size: 20px; font-weight: 900; color: #000;"><?= amount_number_format($overall_equity); ?></span></td>
                                </tr>
                            </table>
                        </div>
                    </div>


                </div>
            </div>
        </div>
    </div>

</div>