<style type="text/css">
    td{padding: 5px !important;}
</style>
<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'financial_income_statement_title_top'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/reports'); ?>"><?= print_lang($app_lang,'reports'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'financial_income_statement_title'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
        
    </div>
</div>

<div class="wrapper wrapper-content animated fadeInRight">

    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins" style="margin-bottom: 10px;">
                <div class="ibox-content" style="padding-bottom: 0px;">                   
                    <form id="financial-income-statement-search-form" action="<?= url('/income-statement'); ?>">
                    <div class="row">
                        <div class="col-md-10">
                            <div class="row">

                                <div class="col-md-4">
                                    <div class="form-group">
                                        <div class="input-group date">
                                            <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                            <select class="form-control chosen-select" name="currency">
                                                <option value="" selected="">-- <?= print_lang($app_lang,'select_currency'); ?> --</option>
                                                <?php foreach($currencies as $row){ ?>
                                                    <option value="<?= $row['uid']; ?>" <?php if($search_currency == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-4">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($search_from); ?>" name="from" placeholder="<?= print_lang($app_lang,'from'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="from" value="<?= true_date_for_inputs($search_from); ?>">
                                        <?php } ?>
                                    </div>
                                </div>

                                <div class="col-md-4">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($search_to); ?>" name="to" placeholder="<?= print_lang($app_lang,'to'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="to" value="<?= true_date_for_inputs($search_to); ?>">
                                        <?php } ?>
                                    </div>
                                </div>

                            </div>
                        </div>
                        <div class="col-md-2 text-right">
                            <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                        </div>
                    </div>
                    </form>

                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <div class="table-responsive">
                        <table class="table" style="width: 100%;">
                            <thead>
                                <tr>
                                    <th colspan="3" style="border: 1px solid #000 !important; padding: 3px; background: #2b9c1b !important; font-size: 18px; font-style: italic; text-decoration: underline; color: #fff !important; font-size: 18px !important; vertical-align: middle;"><?= print_lang($app_lang,'financial_income_statement_title'); ?></th>
                                </tr>

                                <?php
                                    $active_branch_id = active_branch_id();
                                    $branch_data = std_obj_to_array(DB::table('branches')->where('uid',$active_branch_id)->get()->first());
                                ?>
                                <tr>
                                    <td style="width: 10%; padding: 3px;"></td>
                                    <td style="width: 60%; color: #000; padding: 3px; font-size: 15px;"><?= print_lang($app_lang,'financial_income_statement_title_branch_name'); ?></td>
                                    <td style="width: 30%; color: #000; padding: 3px; font-size: 15px; font-style: italic; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';}?>">
                                        <?= isset($branch_data['branch_name']) ? $branch_data['branch_name'] : null; ?>
                                    </td>
                                </tr>
                                <tr>
                                    <td style="width: 10%; padding: 3px;"></td>
                                    <td style="width: 60%; padding: 3px; color: #000; font-size: 15px;"><?= print_lang($app_lang,'financial_income_statement_title_mobile'); ?></td>
                                    <td style="width: 30%; padding: 3px; color: #000; font-size: 15px; font-style: italic; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';}?>">
                                        <?= isset($branch_data['branch_mobile']) ? $branch_data['branch_mobile'] : null; ?>
                                    </td>
                                </tr>
                                <tr>
                                    <td style="width: 10%; padding: 3px;"></td>
                                    <td style="width: 60%; padding: 3px; color: #000; font-size: 15px;"><?= print_lang($app_lang,'financial_income_statement_title_address'); ?></td>
                                    <td style="width: 30%; padding: 3px; color: #000; font-size: 15px; font-style: italic; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';}?>">
                                        <?= isset($branch_data['branch_address']) ? $branch_data['branch_address'] : null; ?>
                                    </td>
                                </tr>

                                <tr>
                                    <td style="width: 10%;"></td>
                                    <th colspan="2" style="border: 1px solid #000 !important; padding: 3px; background: #2b9c1b !important; font-size: 16px; font-style: italic; text-decoration: underline; color: #fff !important; font-size: 16px !important; vertical-align: middle;"><?= print_lang($app_lang,'financial_income_statement_title_date_range'); ?></th>
                                </tr>

                                <tr>
                                    <td style="width: 10%; padding: 3px;"></td>
                                    <td style="width: 60%; padding: 3px; color: #000; font-size: 15px;"><?= print_lang($app_lang,'financial_income_statement_title_begining_date'); ?></td>
                                    <td style="width: 30%; padding: 3px; color: #000; font-size: 15px; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';}?>">
                                        <?php
                                            if(!empty($search_from))
                                            {
                                                echo display_true_date($search_from);
                                            }
                                        ?>
                                    </td>
                                </tr>

                                <tr>
                                    <td style="width: 10%; padding: 3px;"></td>
                                    <td style="width: 60%; padding: 3px; color: #000; font-size: 15px;"><?= print_lang($app_lang,'financial_income_statement_title_end_date'); ?></td>
                                    <td style="width: 30%; padding: 3px; color: #000; font-size: 15px; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';}?>">
                                        <?php
                                            if(!empty($search_to))
                                            {
                                                echo display_true_date($search_to);
                                            }
                                        ?>
                                    </td>
                                </tr>

                                <tr>
                                    <td style="width: 10%; padding: 3px;"></td>
                                    <td style="width: 60%; padding: 3px; color: #000; font-size: 15px;"><?= print_lang($app_lang,'financial_income_statement_title_currency'); ?></td>
                                    <td style="width: 30%; padding: 3px; color: #000; font-size: 15px; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';}?>">
                                        <?php
                                            if(!empty($requested_currency_data))
                                            {
                                                echo isset($requested_currency_data['symbol']) ? $requested_currency_data['symbol'] : null;
                                            }
                                        ?>
                                    </td>
                                </tr>

                                <tr>
                                    <td style="width: 10%;"></td>
                                    <th colspan="2" style="border: 1px solid #000 !important; padding: 3px; background: #2b9c1b !important; font-size: 16px;; font-style: italic; text-decoration: underline; color: #fff !important; font-size: 16px; !important; vertical-align: middle;"><?= print_lang($app_lang,'financial_income_statement_title_revenue'); ?></th>
                                </tr>

                                <tr>
                                    <td style="width: 10%; padding: 3px;"></td>
                                    <td style="width: 60%; padding: 3px; color: #000; font-size: 15px;"><?= print_lang($app_lang,'financial_income_statement_title_sales_income'); ?></td>
                                    <td style="width: 30%; padding: 3px; color: #000; font-size: 15px; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';}?>">
                                        <?php
                                        $total_revenue = [];
                                        $total_expenses = [];
                                            $sales = isset($pageData['sales_all_in_main_currency']) ? $pageData['sales_all_in_main_currency'] : 0;
                                            $lots = isset($pageData['lots_sales_all_in_main_currency']) ? $pageData['lots_sales_all_in_main_currency'] : 0;
                                            $cars = isset($pageData['cars_sales_all_in_main_currency']) ? $pageData['cars_sales_all_in_main_currency'] : 0;
                                            $profits = isset($pageData['earnings_all_in_main_currency']) ? $pageData['earnings_all_in_main_currency'] : 0;
                                            $sales_income = $sales + $lots + $cars + $profits;
                                            $total_revenue[] = $sales_income;

                                            echo $requested_currency_data['symbol'].' '.amount_number_format($sales_income);
                                        ?>
                                    </td>
                                </tr>

                                <tr>
                                    <td style="width: 10%; padding: 3px;"></td>
                                    <td style="width: 60%; padding: 3px; color: #000; font-size: 15px;"><?= print_lang($app_lang,'financial_income_statement_title_services_income'); ?></td>
                                    <td style="width: 30%; padding: 3px; color: #000; font-size: 15px; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';}?>">
                                        <?php
                                            $services_income = isset($pageData['services_all_in_main_currency']) ? $pageData['services_all_in_main_currency'] : 0;
                                            $total_revenue[] = $services_income;

                                            echo $requested_currency_data['symbol'].' '.amount_number_format($services_income);
                                        ?>
                                    </td>
                                </tr>

                                <tr>
                                    <td style="width: 10%; padding: 3px;"></td>
                                    <td style="width: 60%; padding: 3px; color: #000; font-size: 15px;"><?= print_lang($app_lang,'financial_income_statement_title_other_income'); ?></td>
                                    <td style="width: 30%; padding: 3px; color: #000; font-size: 15px; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';}?>">
                                        <?php
                                            $other_income = isset($pageData['other_income_all_in_main_currency']) ? $pageData['other_income_all_in_main_currency'] : 0;
                                            $total_revenue[] = $other_income;

                                            echo $requested_currency_data['symbol'].' '.amount_number_format($other_income);
                                        ?>
                                    </td>
                                </tr>

                                <tr>
                                    <td style="width: 10%; padding: 3px;"></td>
                                    <td style="width: 60%; padding: 3px; color: #000; font-size: 15px; background: #efefef;"><?= print_lang($app_lang,'financial_income_statement_title_net_income'); ?></td>
                                    <td style="width: 30%; padding: 3px; color: #000; font-size: 15px; background: #efefef; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';}?>">
                                        <?php
                                            echo $requested_currency_data['symbol'].' '.amount_number_format(array_sum($total_revenue));
                                        ?>
                                    </td>
                                </tr>

                                <tr>
                                    <td style="width: 10%;"></td>
                                    <th colspan="2" style="border: 1px solid #000 !important; padding: 3px; background: #2b9c1b !important; font-size: 16px;; font-style: italic; text-decoration: underline; color: #fff !important; font-size: 16px; !important; vertical-align: middle;"><?= print_lang($app_lang,'financial_income_statement_title_operating_expenses'); ?></th>
                                </tr>

                                <tr>
                                    <td style="width: 10%; padding: 3px;"></td>
                                    <td style="width: 60%; padding: 3px; color: #000; font-size: 15px;"><?= print_lang($app_lang,'financial_income_statement_title_cost_of_goods'); ?></td>
                                    <td style="width: 30%; padding: 3px; color: #000; font-size: 15px; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';}?>">
                                        <?php
                                            $costs_of_goods_sold = isset($pageData['costs_of_goods_sold']) ? $pageData['costs_of_goods_sold'] : 0;
                                            $total_expenses[] = $costs_of_goods_sold;

                                            echo $requested_currency_data['symbol'].' '.amount_number_format($costs_of_goods_sold);
                                        ?>
                                    </td>
                                </tr>

                                <tr>
                                    <td style="width: 10%; padding: 3px;"></td>
                                    <td style="width: 60%; padding: 3px; color: #000; font-size: 15px;"><?= print_lang($app_lang,'financial_income_statement_title_salaries'); ?></td>
                                    <td style="width: 30%; padding: 3px; color: #000; font-size: 15px; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';}?>">
                                        <?php
                                            $salaries = isset($pageData['salaries_all_in_main_currency']) ? $pageData['salaries_all_in_main_currency'] : 0;
                                            $total_expenses[] = $salaries;

                                            echo $requested_currency_data['symbol'].' '.amount_number_format($salaries);
                                        ?>
                                    </td>
                                </tr>

                                <?php

                                if(!empty($pageData['expenses'])){
                                foreach($pageData['expenses'] as $row){
                                if(isset($row['amount']) AND array_sum($row['amount']) != 0){?>
                                    <tr>
                                        <td style="width: 10%; padding: 3px;"></td>
                                        <td style="width: 60%; padding: 3px; color: #000; font-size: 15px;"><?= $row['name']; ?></td>
                                        <td style="width: 30%; padding: 3px; color: #000; font-size: 15px; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';}?>">
                                            <?php
                                                $total_expenses[] = array_sum($row['amount']);
                                                echo $requested_currency_data['symbol'].' '.amount_number_format(array_sum($row['amount']));
                                            ?>
                                        </td>
                                    </tr>
                                <?php }}} ?>

                                <?php
                                
                                if(!empty($pageData['assets'])){
                                foreach($pageData['assets'] as $row){
                                if(isset($row['amount']) AND array_sum($row['amount']) != 0){?>
                                    <tr>
                                        <td style="width: 10%; padding: 3px;"></td>
                                        <td style="width: 60%; padding: 3px; color: #000; font-size: 15px;"><?= $row['name']; ?></td>
                                        <td style="width: 30%; padding: 3px; color: #000; font-size: 15px; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';}?>">
                                            <?php
                                                $total_expenses[] = array_sum($row['amount']);
                                                echo $requested_currency_data['symbol'].' '.amount_number_format(array_sum($row['amount']));
                                            ?>
                                        </td>
                                    </tr>
                                <?php }}} ?>

                                <tr>
                                    <td style="width: 10%; padding: 3px;"></td>
                                    <td style="width: 60%; padding: 3px; color: #000; font-size: 15px; background: #efefef;"><?= print_lang($app_lang,'financial_income_statement_title_total_expenses'); ?></td>
                                    <td style="width: 30%; padding: 3px; color: #000; font-size: 15px; background: #efefef; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';}?>">
                                        <?php
                                            echo $requested_currency_data['symbol'].' '.amount_number_format(array_sum($total_expenses));
                                        ?>
                                    </td>
                                </tr>

                                <tr>
                                    <td colspan="2" style="border: 1px solid #000 !important; padding: 3px; background: #2b9c1b !important; font-size: 18px; font-style: italic; text-decoration: underline; color: #fff !important; font-size: 18px !important; vertical-align: middle;"><?= print_lang($app_lang,'financial_income_statement_title_net_profit'); ?></td>
                                    <td style="border: 1px solid #000 !important; padding: 3px; background: #2b9c1b !important; font-size: 18px; font-style: italic; text-decoration: underline; color: #fff !important; font-size: 18px !important; vertical-align: middle; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';}?>">
                                        <?php
                                            $net_income = array_sum($total_revenue) - array_sum($total_expenses);
                                            echo $requested_currency_data['symbol'].' '.amount_number_format($net_income);
                                        ?>
                                    </td>
                                </tr>

                            </tbody>
                        </table>
                    </div>

                </div>
            </div>
        </div>
    </div>

</div>