<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'financial_trial_balance_title_top'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/reports'); ?>"><?= print_lang($app_lang,'reports'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'financial_trial_balance_title'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
        
    </div>
</div>


<?php


$i = 1;
$total_debits = [];
$total_credits = [];


$cash_amount = isset($pageData['cash_all_in_main_currency']) ? $pageData['cash_all_in_main_currency'] : null;
$total_debits[] = $cash_amount;

$bank_amount = isset($pageData['banks_all_in_main_currency']) ? $pageData['banks_all_in_main_currency'] : null;
$total_debits[] = $bank_amount;

$inventory_amount = isset($pageData['inventory_all_in_main_currency']) ? $pageData['inventory_all_in_main_currency'] : null;
$ava_cars_amount = isset($pageData['cars_all_in_main_currency']) ? $pageData['cars_all_in_main_currency'] : null;
$ava_tankers_amount = isset($pageData['lots_all_in_main_currency']) ? $pageData['lots_all_in_main_currency'] : null;
$total_inventory = $inventory_amount + $ava_cars_amount + $ava_tankers_amount;
$total_debits[] = $total_inventory;

$purchase_order_amount = isset($pageData['purchase_order_all_in_main_currency']) ? $pageData['purchase_order_all_in_main_currency'] : null;
$total_debits[] = $purchase_order_amount;

$receivable_amount = isset($pageData['receivable_all_in_main_currency']) ? $pageData['receivable_all_in_main_currency'] : null;
$total_debits[] = $receivable_amount;

$assets_amount = isset($pageData['assets_all_in_main_currency']) ? $pageData['assets_all_in_main_currency'] : null;
$total_debits[] = $assets_amount;

$tokens_amount = isset($pageData['tokens_all_in_main_currency']) ? $pageData['tokens_all_in_main_currency'] : null;
$total_debits[] = $tokens_amount;

$cost_of_goods_sold_amount = isset($pageData['costs_of_goods_sold']) ? $pageData['costs_of_goods_sold'] : null;
$total_debits[] = $cost_of_goods_sold_amount;


if(!empty($pageData['expenses'])){
    foreach($pageData['expenses'] as $row){
        if(!empty($row['amount']) AND array_sum($row['amount']) != 0){
            $total_debits[] = array_sum($row['amount']);
        }
    }
}


$salaries_amount = isset($pageData['salaries_all_in_main_currency']) ? $pageData['salaries_all_in_main_currency'] : null;
$total_debits[] = $salaries_amount;





$payable_amount = isset($pageData['payable_all_in_main_currency']) ? $pageData['payable_all_in_main_currency'] : null;
$total_credits[] = $payable_amount;

$capital_amount = isset($pageData['capitals_all_in_main_currency']) ? $pageData['capitals_all_in_main_currency'] : null;
$shareholder_credit_amount = isset($pageData['shareholder_credit_all_in_main_currency']) ? $pageData['shareholder_credit_all_in_main_currency'] : null;
$items_amount = isset($pageData['items_all_in_main_currency']) ? $pageData['items_all_in_main_currency'] : null;
$opening_balance_amount = isset($pageData['opening_balance_all_in_main_currency']) ? $pageData['opening_balance_all_in_main_currency'] : null;
$total_capital_amount = $capital_amount - $shareholder_credit_amount + $items_amount + $opening_balance_amount;
$total_credits[] = $total_capital_amount;

$earnings_amount = isset($pageData['earnings_all_in_main_currency']) ? $pageData['earnings_all_in_main_currency'] : null;
$turnover_amount = isset($pageData['turnover_all_in_main_currency']) ? $pageData['turnover_all_in_main_currency'] : null;
$earnings_amount = $earnings_amount - $turnover_amount;
$total_credits[] = $earnings_amount + $turnover_amount;

$other_income_amount = isset($pageData['other_income_all_in_main_currency']) ? $pageData['other_income_all_in_main_currency'] : null;
$total_credits[] = $other_income_amount;

$sales_amount = isset($pageData['sales_all_in_main_currency']) ? $pageData['sales_all_in_main_currency'] : null;
$car_sales_amount = isset($pageData['cars_sales_all_in_main_currency']) ? $pageData['cars_sales_all_in_main_currency'] : null;
$fuel_sales_amount = isset($pageData['lots_sales_all_in_main_currency']) ? $pageData['lots_sales_all_in_main_currency'] : null;
$total_sales_amount = $sales_amount + $car_sales_amount + $fuel_sales_amount;
$total_credits[] = $total_sales_amount;

$sales_services_amount = isset($pageData['custom_sales_all_in_main_currency']) ? $pageData['custom_sales_all_in_main_currency'] : null;
$services_balance = isset($pageData['services_all_in_main_currency']) ? $pageData['services_all_in_main_currency'] : null;
$services_amount = $sales_services_amount + $services_balance;
$total_credits[] = $services_amount;

$exchange_profit_loss = array_sum($total_debits) - array_sum($total_credits);
$total_credits[] = $exchange_profit_loss;





?>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'trial_balance'); ?></h2>
                    
                    <form id="financial-trial-balance-search-form" action="<?= url('/trial-balance'); ?>">
                    <div class="row">
                        <div class="col-md-10">
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <div class="input-group date">
                                            <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                            <select class="form-control chosen-select" name="currency">
                                                <option value="" selected="">-- <?= print_lang($app_lang,'select_currency'); ?> --</option>
                                                <?php foreach($currencies as $row){ ?>
                                                    <option value="<?= $row['uid']; ?>" <?php if($search_currency == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-2 text-right">
                            <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                        </div>
                    </div>
                    </form>
                    <hr>

                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th rowspan="2" class="text-center" style="border: 1px solid #000 !important; background: #2b9c1b !important; color: #000 !important; font-size: 18px !important; vertical-align: middle; width: 6%;"><?= print_lang($app_lang,'financial_trial_balance_thead_number'); ?></th>
                                    <th rowspan="2" style="border: 1px solid #000 !important; background: #2b9c1b !important; color: #000 !important; font-size: 18px !important; vertical-align: middle; width: 60%;"><?= print_lang($app_lang,'financial_trial_balance_thead_particulars'); ?></th>
                                    <th colspan="2" class="text-center" style="border: 1px solid #000 !important; background: #2b9c1b !important; color: #000 !important; font-size: 18px !important; "><?= print_lang($app_lang,'financial_trial_balance_thead_amount').' ('.$requested_currency_data['name'].')'; ?></th>
                                </tr>
                                <tr class="text-center">
                                    <th class="text-center" style="border: 1px solid #000 !important; background: #2b9c1b !important; color: #000 !important; font-size: 18px !important; width: 17%;"><?= print_lang($app_lang,'financial_trial_balance_thead_debit'); ?></th>
                                    <th class="text-center" style="border: 1px solid #000 !important; background: #2b9c1b !important; color: #000 !important; font-size: 18px !important; width: 17%;"><?= print_lang($app_lang,'financial_trial_balance_thead_credit'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                
                                <tr>
                                    <td class="text-center" style="border: 1px solid #000 !important;color: #000 !important;"><?= $i++; ?></td>
                                    <td style="border: 1px solid #000 !important;color: #000 !important;"><?= print_lang($app_lang,'financial_trial_balance_thead_cash'); ?></td>
                                    
                                    <td class="text-center" style="border: 1px solid #000 !important;color: #000 !important;"><?= amount_number_format($cash_amount); ?></td>
                                    <td class="text-center" style="border: 1px solid #000 !important;color: #000 !important;"></td>
                                </tr>

                                <tr>
                                    <td class="text-center" style="border: 1px solid #000 !important;color: #000 !important;"><?= $i++; ?></td>
                                    <td style="border: 1px solid #000 !important;color: #000 !important;"><?= print_lang($app_lang,'financial_trial_balance_thead_bank'); ?></td>
                                    
                                    <td class="text-center" style="border: 1px solid #000 !important;color: #000 !important;"><?= amount_number_format($bank_amount); ?></td>
                                    <td class="text-center" style="border: 1px solid #000 !important;color: #000 !important;"></td>
                                </tr>

                                <tr>
                                    <td class="text-center" style="border: 1px solid #000 !important;color: #000 !important;"><?= $i++; ?></td>
                                    <td style="border: 1px solid #000 !important;color: #000 !important;"><?= print_lang($app_lang,'financial_trial_balance_thead_inventory'); ?></td>
                                    
                                    <td class="text-center" style="border: 1px solid #000 !important;color: #000 !important;"><?= amount_number_format($total_inventory); ?></td>
                                    <td class="text-center" style="border: 1px solid #000 !important;color: #000 !important;"></td>
                                </tr>

                                <tr>
                                    <td class="text-center" style="border: 1px solid #000 !important;color: #000 !important;"><?= $i++; ?></td>
                                    <td style="border: 1px solid #000 !important;color: #000 !important;"><?= print_lang($app_lang,'financial_trial_balance_thead_purchase_order'); ?></td>
                                    
                                    <td class="text-center" style="border: 1px solid #000 !important;color: #000 !important;"><?= amount_number_format($purchase_order_amount); ?></td>
                                    <td class="text-center" style="border: 1px solid #000 !important;color: #000 !important;"></td>
                                </tr>

                                <tr>
                                    <td class="text-center" style="border: 1px solid #000 !important;color: #000 !important;"><?= $i++; ?></td>
                                    <td style="border: 1px solid #000 !important;color: #000 !important;"><?= print_lang($app_lang,'financial_trial_balance_thead_receivable'); ?></td>
                                    
                                    <td class="text-center" style="border: 1px solid #000 !important;color: #000 !important;"><?= amount_number_format($receivable_amount); ?></td>
                                    <td class="text-center" style="border: 1px solid #000 !important;color: #000 !important;"></td>
                                </tr>

                                <tr>
                                    <td class="text-center" style="border: 1px solid #000 !important;color: #000 !important;"><?= $i++; ?></td>
                                    <td style="border: 1px solid #000 !important;color: #000 !important;"><?= print_lang($app_lang,'financial_trial_balance_thead_assets'); ?></td>
                                    
                                    <td class="text-center" style="border: 1px solid #000 !important;color: #000 !important;"><?= amount_number_format($assets_amount); ?></td>
                                    <td class="text-center" style="border: 1px solid #000 !important;color: #000 !important;"></td>
                                </tr>

                                <tr>
                                    <td class="text-center" style="border: 1px solid #000 !important;color: #000 !important;"><?= $i++; ?></td>
                                    <td style="border: 1px solid #000 !important;color: #000 !important;"><?= print_lang($app_lang,'financial_trial_balance_thead_payable'); ?></td>
                                    
                                    <td class="text-center" style="border: 1px solid #000 !important;color: #000 !important;"></td>
                                    <td class="text-center" style="border: 1px solid #000 !important;color: #000 !important;"><?= amount_number_format($payable_amount); ?></td>
                                </tr>

                                <tr>
                                    <td class="text-center" style="border: 1px solid #000 !important;color: #000 !important;"><?= $i++; ?></td>
                                    <td style="border: 1px solid #000 !important;color: #000 !important;"><?= print_lang($app_lang,'financial_trial_balance_thead_capital'); ?></td>
                                    
                                    <td class="text-center" style="border: 1px solid #000 !important;color: #000 !important;"></td>
                                    <td class="text-center" style="border: 1px solid #000 !important;color: #000 !important;"><?= amount_number_format($total_capital_amount); ?></td>
                                </tr>

                                <tr>
                                    <td class="text-center" style="border: 1px solid #000 !important;color: #000 !important;"><?= $i++; ?></td>
                                    <td style="border: 1px solid #000 !important;color: #000 !important;"><?= print_lang($app_lang,'financial_trial_balance_thead_earnings'); ?></td>
                                    
                                    <td class="text-center" style="border: 1px solid #000 !important;color: #000 !important;"></td>
                                    <td class="text-center" style="border: 1px solid #000 !important;color: #000 !important;"><?= amount_number_format($earnings_amount); ?></td>
                                </tr>

                                <tr>
                                    <td class="text-center" style="border: 1px solid #000 !important;color: #000 !important;"><?= $i++; ?></td>
                                    <td style="border: 1px solid #000 !important;color: #000 !important;"><?= print_lang($app_lang,'financial_trial_balance_thead_turonver'); ?></td>
                                    
                                    <td class="text-center" style="border: 1px solid #000 !important;color: #000 !important;"></td>
                                    <td class="text-center" style="border: 1px solid #000 !important;color: #000 !important;"><?= amount_number_format($turnover_amount); ?></td>
                                </tr>

                                <tr>
                                    <td class="text-center" style="border: 1px solid #000 !important;color: #000 !important;"><?= $i++; ?></td>
                                    <td style="border: 1px solid #000 !important;color: #000 !important;"><?= print_lang($app_lang,'financial_trial_balance_thead_exchange_profit_loss'); ?></td>
                                    
                                    <td class="text-center" style="border: 1px solid #000 !important;color: #000 !important;"></td>
                                    <td class="text-center" style="border: 1px solid #000 !important;color: #000 !important;"><?= amount_number_format($exchange_profit_loss); ?></td>
                                </tr>

                                <tr>
                                    <td class="text-center" style="border: 1px solid #000 !important;color: #000 !important;"><?= $i++; ?></td>
                                    <td style="border: 1px solid #000 !important;color: #000 !important;"><?= print_lang($app_lang,'financial_trial_balance_thead_others'); ?></td>
                                    
                                    <td class="text-center" style="border: 1px solid #000 !important;color: #000 !important;"></td>
                                    <td class="text-center" style="border: 1px solid #000 !important;color: #000 !important;"><?= amount_number_format($other_income_amount); ?></td>
                                </tr>

                                <tr>
                                    <td class="text-center" style="border: 1px solid #000 !important;color: #000 !important;"><?= $i++; ?></td>
                                    <td style="border: 1px solid #000 !important;color: #000 !important;"><?= print_lang($app_lang,'financial_trial_balance_thead_sales'); ?></td>
                                    
                                    <td class="text-center" style="border: 1px solid #000 !important;color: #000 !important;"></td>
                                    <td class="text-center" style="border: 1px solid #000 !important;color: #000 !important;"><?= amount_number_format($total_sales_amount); ?></td>
                                </tr>

                                <tr>
                                    <td class="text-center" style="border: 1px solid #000 !important;color: #000 !important;"><?= $i++; ?></td>
                                    <td style="border: 1px solid #000 !important;color: #000 !important;"><?= print_lang($app_lang,'financial_trial_balance_thead_services'); ?></td>
                                    
                                    <td class="text-center" style="border: 1px solid #000 !important;color: #000 !important;"></td>
                                    <td class="text-center" style="border: 1px solid #000 !important;color: #000 !important;"><?= amount_number_format($services_amount); ?></td>
                                </tr>

                                <tr>
                                    <td class="text-center" style="border: 1px solid #000 !important;color: #000 !important;"><?= $i++; ?></td>
                                    <td style="border: 1px solid #000 !important;color: #000 !important;"><?= print_lang($app_lang,'financial_trial_balance_thead_cost_of_goods_sold'); ?></td>
                                    
                                    <td class="text-center" style="border: 1px solid #000 !important;color: #000 !important;"><?= amount_number_format($cost_of_goods_sold_amount); ?></td>
                                    <td class="text-center" style="border: 1px solid #000 !important;color: #000 !important;"></td>
                                </tr>

                                <?php if(!empty($pageData['expenses'])){
                                    foreach($pageData['expenses'] as $row){
                                        if(!empty($row['amount']) AND array_sum($row['amount']) != 0){
                                ?>
                                    <tr>
                                        <td class="text-center" style="border: 1px solid #000 !important;color: #000 !important;"><?= $i++; ?></td>
                                        <td style="border: 1px solid #000 !important;color: #000 !important;"><?= $row['name']; ?></td>
                                        <td class="text-center" style="border: 1px solid #000 !important;color: #000 !important;"><?= amount_number_format(array_sum($row['amount'])); ?></td>
                                        <td class="text-center" style="border: 1px solid #000 !important;color: #000 !important;"></td>
                                    </tr>

                                <?php }}} ?>

                                <tr>
                                    <td class="text-center" style="border: 1px solid #000 !important;color: #000 !important;"><?= $i++; ?></td>
                                    <td style="border: 1px solid #000 !important;color: #000 !important;"><?= print_lang($app_lang,'financial_trial_balance_thead_tokens'); ?></td>
                                    
                                    <td class="text-center" style="border: 1px solid #000 !important;color: #000 !important;"><?= amount_number_format($tokens_amount); ?></td>
                                    <td class="text-center" style="border: 1px solid #000 !important;color: #000 !important;"></td>
                                </tr>

                                <tr>
                                    <td class="text-center" style="border: 1px solid #000 !important;color: #000 !important;"><?= $i++; ?></td>
                                    <td style="border: 1px solid #000 !important;color: #000 !important;"><?= print_lang($app_lang,'financial_trial_balance_thead_salaries'); ?></td>
                                    
                                    <td class="text-center" style="border: 1px solid #000 !important;color: #000 !important;"><?= amount_number_format($salaries_amount); ?></td>
                                    <td class="text-center" style="border: 1px solid #000 !important;color: #000 !important;"></td>
                                </tr>

                                <tr>
                                    <td class="text-center" style="border: 1px solid #000 !important; background: #ffc027 !important; color: #000 !important;"></td>
                                    <td style="border: 1px solid #000 !important; background: #ffc027 !important; color: #000 !important;"><?= print_lang($app_lang,'financial_trial_balance_thead_totals'); ?></td>
                                    <td class="text-center" style="border: 1px solid #000 !important; background: #ffc027 !important; color: #000 !important;"><?= amount_number_format(array_sum($total_debits)); ?></td>
                                    <td class="text-center" style="border: 1px solid #000 !important; background: #ffc027 !important; color: #000 !important;"><?= amount_number_format(array_sum($total_credits)); ?></td>
                                </tr>


                            </tbody>
                        </table>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>