<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'income_statement'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/reports'); ?>"><?= print_lang($app_lang,'reports'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'income_statement'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
        
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'income_statement'); ?></h2>
                    
                    <form id="financial-balance-sheet-search-form" action="<?= url('/income-statement'); ?>">
                    <div class="row">
                        <div class="col-md-10">
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <div class="input-group date">
                                            <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                            <select class="form-control chosen-select" name="currency">
                                                <option value="" selected="">-- <?= print_lang($app_lang,'select_currency'); ?> --</option>
                                                <?php foreach($currencies as $row){ ?>
                                                    <option value="<?= $row['uid']; ?>" <?php if($search_currency == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= $search_from; ?>" name="from" placeholder="<?= print_lang($app_lang,'from'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="from" value="<?= $search_from; ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= $search_to; ?>" name="to" placeholder="<?= print_lang($app_lang,'to'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="to" value="<?= $search_to; ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-2 text-right">
                            <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                        </div>
                    </div>
                    </form>
                    <hr>

                    <div class="table-responsive">
                            <table style="width: 100%;">
                                <tr style="vertical-align: top;">
                                    <!-- INCOME SECTION -->
                                    <td style="width: 50%; border: 1px solid lightgray;">
                                        <h4 class="text-center"><?= print_lang($app_lang,'income_statement_incomes_heading'); ?></h4>
                                        <table class="table table-striped" style="width: 100%;">
                                            <thead>
                                                <tr>
                                                    <th style="width: 5%; background: #2B9C1B !important; color: #fff !important;"><?= print_lang($app_lang,'income_statement_incomes_1st_head'); ?></th>
                                                    <th style="width: 20%; background: #2B9C1B !important; color: #fff !important;"><?= print_lang($app_lang,'income_statement_incomes_2nd_head'); ?></th>
                                                    <th style="width: 25%; background: #2B9C1B !important; color: #fff !important;"><?= print_lang($app_lang,'income_statement_incomes_3rd_head'); ?></th>
                                                    <th style="width: 35%; background: #2B9C1B !important; color: #fff !important;"><?= print_lang($app_lang,'income_statement_incomes_4th_head'); ?></th>
                                                    <th style="width: 15%; background: #2B9C1B !important; color: #fff !important;"><?= print_lang($app_lang,'income_statement_incomes_5th_head'); ?></th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php $income_sr = 1; foreach($pageData['income_records'] as $income_row){ ?>
                                                    <tr>
                                                        <td><?= $income_sr++; ?></td>
                                                        <td><?= display_true_date(date('Y-m-d',strtotime($income_row['date']))); ?></td>
                                                        <td><?= $income_row['account']; ?></td>
                                                        <td><?= $income_row['narration']; ?></td>
                                                        <td><?= round_decimels_digits($income_row['amount']); ?></td>
                                                    </tr>
                                                <?php } ?>
                                            </tbody>
                                        </table>
                                    </td>
                                    <!-- INCOME SECTION -->

                                    <!-- EXPENSES SECTION -->
                                    <td style="width: 50%; border: 1px solid lightgray;">
                                        <h4 class="text-center"><?= print_lang($app_lang,'income_statement_expenses_heading'); ?></h4>
                                        <table class="table table-striped" style="width: 100%;">
                                            <thead>
                                                <tr>
                                                    <th style="width: 5%; background: #2B9C1B !important; color: #fff !important;"><?= print_lang($app_lang,'income_statement_expenses_1st_head'); ?></th>
                                                    <th style="width: 20%; background: #2B9C1B !important; color: #fff !important;"><?= print_lang($app_lang,'income_statement_expenses_2nd_head'); ?></th>
                                                    <th style="width: 25%; background: #2B9C1B !important; color: #fff !important;"><?= print_lang($app_lang,'income_statement_expenses_3rd_head'); ?></th>
                                                    <th style="width: 35%; background: #2B9C1B !important; color: #fff !important;"><?= print_lang($app_lang,'income_statement_expenses_4th_head'); ?></th>
                                                    <th style="width: 15%; background: #2B9C1B !important; color: #fff !important;"><?= print_lang($app_lang,'income_statement_expenses_5th_head'); ?></th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php $expense_sr = 1; foreach($pageData['expenses_records'] as $expense_row){ ?>
                                                    <tr>
                                                        <td><?= $expense_sr++; ?></td>
                                                        <td><?= display_true_date(date('Y-m-d',strtotime($expense_row['date']))); ?></td>
                                                        <td><?= $expense_row['account']; ?></td>
                                                        <td><?= $expense_row['narration']; ?></td>
                                                        <td><?= round_decimels_digits($expense_row['amount']); ?></td>
                                                    </tr>
                                                <?php } ?>
                                            </tbody>
                                        </table>
                                    </td>
                                    <!-- EXPENSES SECTION -->
                                </tr>
                            </table>
                            <table style="width: 80%; margin: 0 auto; margin-top: 50px;">
                                <tr>
                                    <td style="width: 33.3%; text-align: center;"><strong><?= print_lang($app_lang,'income_statement_gross_income'); ?>:</strong>&nbsp;&nbsp;&nbsp;<span><?= round_decimels_digits($pageData['incomes']); ?></span></td>
                                    <td style="width: 33.3%; text-align: center;"><strong><?= print_lang($app_lang,'income_statement_gross_expenses'); ?>:</strong>&nbsp;&nbsp;&nbsp;<span><?= round_decimels_digits($pageData['expenses']); ?></span></td>
                                    <td style="width: 33.3%; text-align: center;"><strong><?= print_lang($app_lang,'income_statement_net_profit'); ?>:</strong>&nbsp;&nbsp;&nbsp;<span><?= round_decimels_digits($pageData['balance']); ?></span></td>
                                </tr>
                            </table>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>