<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'micro_balance_sheet'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/reports'); ?>"><?= print_lang($app_lang,'reports'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'micro_balance_sheet'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
        
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'micro_balance_sheet'); ?></h2>
                    
                    <form id="financial-balance-sheet-search-form" action="<?= url('/micro-balance-sheet'); ?>">
                    <div class="row">
                        <div class="col-md-10">
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <div class="input-group date">
                                            <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                            <select class="form-control chosen-select" name="currency">
                                                <option value="" selected="">-- <?= print_lang($app_lang,'select_currency'); ?> --</option>
                                                <?php foreach($currencies as $row){ ?>
                                                    <option value="<?= $row['uid']; ?>" <?php if($search_currency == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= $search_from; ?>" name="from" placeholder="<?= print_lang($app_lang,'from'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="from" value="<?= $search_from; ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= $search_to; ?>" name="to" placeholder="<?= print_lang($app_lang,'to'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="to" value="<?= $search_to; ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-2 text-right">
                            <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                        </div>
                    </div>
                    </form>
                    <hr>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="micro-balance-sheet-box" style="width: 90%; margin: 0 auto 50px;">
                                <div class="table-responsive">
                                    <table class="table table-striped">
                                        <thead>
                                            <tr>
                                                <th colspan="2" style="background: #2B9C1B; color: #fff; text-align: center;"><?= print_lang($app_lang,'assets'); ?></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php if($_item_settings['fuel_parts'] == 'enable'){ ?>
                                            <tr>
                                                <td style="width: 50%;"><?= print_lang($app_lang,'available_tankers'); ?></td>
                                                <td style="width: 50%; text-align: right;"><?= amount_number_format($assets['avail_tankers']); ?></td>
                                            </tr>
                                            <?php } ?>
                                            <tr>
                                                <td style="width: 50%;"><?= print_lang($app_lang,'current_stock'); ?></td>
                                                <td style="width: 50%; text-align: right;"><?= amount_number_format($assets['current_stock']); ?></td>
                                            </tr>
                                            <tr>
                                                <td style="width: 50%;"><?= print_lang($app_lang,'clients'); ?> +</td>
                                                <td style="width: 50%; text-align: right;"><?= amount_number_format($assets['clients']); ?></td>
                                            </tr>
                                            <tr>
                                                <td style="width: 50%;"><?= print_lang($app_lang,'cashbook'); ?></td>
                                                <td style="width: 50%; text-align: right;"><?= amount_number_format($assets['cashbook']); ?></td>
                                            </tr>
                                            <tr>
                                                <td style="width: 50%;"><?= print_lang($app_lang,'fixed_assets'); ?></td>
                                                <td style="width: 50%; text-align: right;"><?= amount_number_format($assets['fixed_assets']); ?></td>
                                            </tr>
                                            <tr>
                                                <td style="width: 50%;"><?= print_lang($app_lang,'total'); ?></td>
                                                <td style="width: 50%; text-align: right;"><?= amount_number_format($assets['total']); ?></td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="micro-balance-sheet-box" style="width: 90%; margin: 0 auto 50px;">
                                <div class="table-responsive">
                                    <table class="table table-striped">
                                        <thead>
                                            <tr>
                                                <th colspan="2" style="background: #2B9C1B; color: #fff; text-align: center;"><?= print_lang($app_lang,'payable'); ?></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td style="width: 50%;"><?= print_lang($app_lang,'banks'); ?></td>
                                                <td style="width: 50%; text-align: right;"><?= amount_number_format($payable['bank']); ?></td>
                                            </tr>
                                            <tr>
                                                <td style="width: 50%;"><?= print_lang($app_lang,'clients'); ?> -</td>
                                                <td style="width: 50%; text-align: right;"><?= amount_number_format($payable['client']); ?></td>
                                            </tr>
                                            <tr>
                                                <td style="width: 50%;"><?= print_lang($app_lang,'suppliers'); ?></td>
                                                <td style="width: 50%; text-align: right;"><?= amount_number_format($payable['supplier']); ?></td>
                                            </tr>
                                            <tr>
                                                <td style="width: 50%;"><?= print_lang($app_lang,'other_accounts'); ?></td>
                                                <td style="width: 50%; text-align: right;"><?= amount_number_format($payable['other_accounts']); ?></td>
                                            </tr>
                                            <tr>
                                                <td style="width: 50%;"><?= print_lang($app_lang,'total'); ?></td>
                                                <td style="width: 50%; text-align: right;"><?= amount_number_format($payable['total']); ?></td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="micro-balance-sheet-box" style="width: 90%; margin: 0 auto 50px;">
                                <div class="table-responsive">
                                    <table class="table table-striped">
                                        <thead>
                                            <tr>
                                                <th colspan="2" style="background: #2B9C1B; color: #fff; text-align: center;"><?= print_lang($app_lang,'assets_total'); ?></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach($totals_assets as $key => $row){ if($key === 'all_in_usd'){ continue; } ?>
                                                <tr>
                                                    <td style="width: 50%;"><?= array_key_exists($row['uid'], $currencies) ? $currencies[$row['uid']]['name'] : NULL; ?></td>
                                                    <td style="width: 50%; text-align: right;"><?= amount_number_format($row['assets_total']); ?></td>
                                                </tr>
                                            <?php } ?>
                                            <tr>
                                                <td style="width: 50%;"><?= print_lang($app_lang,'total_in_usd'); ?></td>
                                                <td style="width: 50%; text-align: right;"><?= amount_number_format($totals_assets['all_in_usd']); ?></td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="micro-balance-sheet-box" style="width: 90%; margin: 0 auto 50px;">
                                <div class="table-responsive">
                                    <table class="table table-striped">
                                        <thead>
                                            <tr>
                                                <th colspan="2" style="background: #2B9C1B; color: #fff; text-align: center;"><?= print_lang($app_lang,'payable_total'); ?></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach($totals_payable as $key => $row){ if($key === 'all_in_usd'){ continue; } ?>
                                                <tr>
                                                    <td style="width: 50%;"><?= array_key_exists($row['uid'], $currencies) ? $currencies[$row['uid']]['name'] : NULL; ?></td>
                                                    <td style="width: 50%; text-align: right;"><?= amount_number_format($row['payable_total']); ?></td>
                                                </tr>
                                            <?php } ?>
                                            <tr>
                                                <td style="width: 50%;"><?= print_lang($app_lang,'total_in_usd'); ?></td>
                                                <td style="width: 50%; text-align: right;"><?= amount_number_format($totals_payable['all_in_usd']); ?></td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-offset-4 col-md-4 col-md-offset-4" style="background: #2B9C1B; color: #fff; text-align: center;">
                            <span style="line-height: 40px;font-size: 15px;"><?= print_lang($app_lang,'equity'); ?>: <?= amount_number_format( ($totals_assets['all_in_usd'] + $totals_payable['all_in_usd']) ); ?></span>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>