<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'profit_and_loss'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/reports'); ?>"><?= print_lang($app_lang,'reports'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'profit_and_loss'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
        
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'profit_and_loss'); ?></h2>
                    
                    <form id="financial-balance-sheet-search-form" action="<?= url('/profit-and-loss'); ?>">
                    <div class="row">
                        <div class="col-md-10">
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <div class="input-group date">
                                            <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                            <select class="form-control chosen-select" name="currency">
                                                <option value="" selected="">-- <?= print_lang($app_lang,'select_currency'); ?> --</option>
                                                <?php foreach($currencies as $row){ ?>
                                                    <option value="<?= $row['uid']; ?>" <?php if($search_currency == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= $search_from; ?>" name="from" placeholder="<?= print_lang($app_lang,'from'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="from" value="<?= $search_from; ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= $search_to; ?>" name="to" placeholder="<?= print_lang($app_lang,'to'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="to" value="<?= $search_to; ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-2 text-right">
                            <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                        </div>
                    </div>
                    </form>
                    <hr>

                    <div class="panel panel-primary" style="width: 70%; margin: 50px auto;">
                        <div class="panel-heading">
                            <h3 style="margin: 0;"><?= print_lang($app_lang,'profit_and_loss_main_heading'); ?></h3>
                        </div>
                        <div class="panel-body">
                            <table class="table table-bordered">
                                <tbody>
                                <tr>
                                    <td style="padding-left: 20px; border-right: none;"><strong><?= print_lang($app_lang,'profit_and_loss_Total_sales'); ?></strong></td>
                                    <td style="border-left: none; text-align: right"><?= amount_number_format($pageData['sales_amount']); ?></td>
                                </tr>
                                <tr>
                                    <td style="padding-left: 20px; border-right: none;"><strong><?= print_lang($app_lang,'profit_and_loss_Total_returns'); ?></strong></td>
                                    <td style="border-left: none; text-align: right"><?= amount_number_format($pageData['sales_return_amount']); ?></td>
                                </tr>
                                <tr>
                                    <td style="padding-left: 20px; border-right: none;"><strong><?= print_lang($app_lang,'profit_and_loss_Total_profit_sales'); ?></strong></td>
                                    <td style="border-left: none; text-align: right"><?= amount_number_format($pageData['sales_profit']); ?></td>
                                </tr>
                                <tr>
                                    <td style="padding-left: 20px; border-right: none;"><strong><?= print_lang($app_lang,'profit_and_loss_Total_profit_return'); ?></strong></td>
                                    <td style="border-left: none; text-align: right"><?= '-'.amount_number_format($pageData['sales_return_profit']); ?></td>
                                </tr>

                                <tr>
                                    <td style="padding-left: 20px; border-right: none;"><strong><?= print_lang($app_lang,'profit_and_loss_Total_profit_transfer_out_amount'); ?></strong></td>
                                    <td style="border-left: none; text-align: right"><?= amount_number_format($pageData['transfer_out_amount']); ?></td>
                                </tr>
                                <tr>
                                    <td style="padding-left: 20px; border-right: none;"><strong><?= print_lang($app_lang,'profit_and_loss_Total_profit_transfer_out'); ?></strong></td>
                                    <td style="border-left: none; text-align: right"><?= amount_number_format($pageData['transfer_out_profit']); ?></td>
                                </tr>

                                <tr>
                                    <td style="padding-left: 20px; border-right: none;"><strong><?= print_lang($app_lang,'profit_and_loss_Total_profit_extra_incomes'); ?></strong></td>
                                    <td style="border-left: none; text-align: right"><?= amount_number_format($pageData['extra_income_amount']); ?></td>
                                </tr>
                                
                                <tr>
                                    <td style="padding-left: 20px; border-right: none;"><strong><?= print_lang($app_lang,'profit_and_loss_Total_expenses'); ?></strong></td>
                                    <td style="border-left: none; text-align: right"><?= amount_number_format($pageData['expenses_amount']); ?></td>
                                </tr>
                                <tr>
                                    <td style="padding-left: 20px; border-right: none;"><strong><?= print_lang($app_lang,'profit_and_loss_net_profit'); ?></strong></td>
                                    <td style="border-left: none; text-align: right"><?= amount_number_format($pageData['net_profit']); ?></td>
                                </tr>
                            </tbody></table>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>