<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'trial_balance'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/reports'); ?>"><?= print_lang($app_lang,'reports'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'trial_balance'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
        
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'trial_balance'); ?></h2>
                    
                    <form id="financial-balance-sheet-search-form" action="<?= url('/trial-balance'); ?>">
                    <div class="row">
                        <div class="col-md-10">
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <div class="input-group date">
                                            <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                            <select class="form-control chosen-select" name="currency">
                                                <option value="" selected="">-- <?= print_lang($app_lang,'select_currency'); ?> --</option>
                                                <?php foreach($currencies as $row){ ?>
                                                    <option value="<?= $row['uid']; ?>" <?php if($search_currency == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= $search_from; ?>" name="from" placeholder="<?= print_lang($app_lang,'from'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="from" value="<?= $search_from; ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= $search_to; ?>" name="to" placeholder="<?= print_lang($app_lang,'to'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="to" value="<?= $search_to; ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-2 text-right">
                            <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                        </div>
                    </div>
                    </form>
                    <hr>

                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th style="width: 28%;"><?= print_lang($app_lang,'trial_balance_table_1st_head'); ?></th>
                                    <th style="width: 18%; text-align: center;"><?= print_lang($app_lang,'trial_balance_table_old_head'); ?></th>
                                    <th style="width: 18%; text-align: center;"><?= print_lang($app_lang,'trial_balance_table_2nd_head'); ?></th>
                                    <th style="width: 18%; text-align: center;"><?= print_lang($app_lang,'trial_balance_table_3rd_head'); ?></th>
                                    <th style="width: 18%; text-align: center;"><?= print_lang($app_lang,'trial_balance_table_4th_head'); ?></th>
                                </tr>
                            </thead>
                            <tbody>

                                <?php
                                $tr_debits = array();
                                $tr_credits = array();
                                $old_balance_total = array();
                                $branch_id = active_branch_id();
                                $branches_for_query = array();
                                $currency_for_query = array();
                                ?>

                                <?php 
                                foreach($root_accounts as $racount){
                                    $debits = 0;
                                    $credits = 0;
                                    $balance = 0;
                                    $debits_shared = 0;
                                    $credits_shared = 0;
                                    $total_debits = 0;
                                    $total_credits = 0;
                                    if($racount['branch'] == 'general')
                                    {
                                        $parent_name = print_lang($app_lang,'builtin_account_'.$racount['uid']);
                                    }
                                    else
                                    {
                                        $parent_name = $racount['name'];
                                    }

                                    $debits = isset($balance_summary_data[$racount['uid']]['debit']) ? array_sum($balance_summary_data[$racount['uid']]['debit']) : 0;
                                    $credits = isset($balance_summary_data[$racount['uid']]['credit']) ? array_sum($balance_summary_data[$racount['uid']]['credit']) : 0;
                                    $balance = isset($balance_summary_data[$racount['uid']]['balance']) ? array_sum($balance_summary_data[$racount['uid']]['balance']) : 0;
                                    $balance_old = isset($balance_summary_data_previous[$racount['uid']]['balance']) ? array_sum($balance_summary_data_previous[$racount['uid']]['balance']) : 0;

                                    $balance_color = ($balance >= 0) ? '#2B9C1B' : '#ec4758';
                                    $balance_old_color = ($balance_old >= 0) ? '#2B9C1B' : '#ec4758';
                                ?>
                                <tr style="line-height: 35px;">
                                    <td style="width: 28%; text-indent: 20px;"><?= $parent_name; ?></td>
                                    <td style="width: 18%; text-align: center; color: <?= $balance_old_color; ?>;"><?= amount_number_format($balance_old); $old_balance_total[] = $balance_old; ?></td>
                                    <td style="width: 18%; text-align: center;"><?= amount_number_format($debits); $tr_debits[] = $debits; ?></td>
                                    <td style="width: 18%; text-align: center;"><?= amount_number_format($credits); $tr_credits[] = $credits; ?></td>
                                    <td style="width: 18%; text-align: center; color: <?= $balance_color; ?>;"><?= amount_number_format($balance); ?></td>
                                    
                                </tr>
                                <?php } ?>
                                <tr style="line-height: 35px;">
                                    <td style="width: 25%; text-indent: 20px;"><?= print_lang($app_lang,'trial_balance_table_fixed_assets'); ?></td>
                                    <?php
                                        $assets = DB::table('assets')->where('branch',active_branch_id())->where('currency',$search_currency)->sum('price');
                                        $balance_color = ($assets >= 0) ? '#2B9C1B' : '#ec4758';
                                    ?>
                                    <td style="width: 25%; text-align: center;"><?= amount_number_format($assets); $tr_debits[] = $assets; ?></td>
                                    <td style="width: 25%; text-align: center;">0.00</td>
                                    <td style="width: 25%; text-align: center; color: <?= $balance_color; ?>;"><?= amount_number_format($assets); ?></td>
                                    
                                </tr>

                                <?php
                                    $balance_color = (array_sum($tr_debits) - array_sum($tr_credits) >= 0) ? '#2B9C1B' : '#ec4758';
                                    $balance_color_old = (array_sum($old_balance_total) >= 0) ? '#2B9C1B' : '#ec4758';
                                ?>
                                <tr style="line-height: 35px;">
                                    <td style="width: 28%; text-indent: 20px;"><?= print_lang($app_lang,'total'); ?></td>
                                    <td style="width: 18%; text-align: center; color: <?= $balance_color_old; ?>;"><?= amount_number_format(array_sum($old_balance_total)); ?></td>
                                    <td style="width: 18%; text-align: center;"><?= amount_number_format(array_sum($tr_debits)); ?></td>
                                    <td style="width: 18%; text-align: center;"><?= amount_number_format(array_sum($tr_credits)); ?></td>
                                    <td style="width: 18%; text-align: center; color: <?= $balance_color; ?>;"><?= amount_number_format(array_sum($tr_debits) - array_sum($tr_credits)); ?></td>
                                </tr>

                            </tbody>
                        </table>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>