<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'trial_balance'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/reports'); ?>"><?= print_lang($app_lang,'reports'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'trial_balance'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
        
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'trial_balance'); ?></h2>
                    
                    <form id="financial-balance-sheet-search-form" action="<?= url('/trial-balance'); ?>">
                    <div class="row">
                        <div class="col-md-10">
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <div class="input-group date">
                                            <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                            <select class="form-control chosen-select" name="currency">
                                                <option value="" selected="">-- <?= print_lang($app_lang,'select_currency'); ?> --</option>
                                                <?php foreach($currencies as $row){ ?>
                                                    <option value="<?= $row['uid']; ?>" <?php if($search_currency == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= $search_from; ?>" name="from" placeholder="<?= print_lang($app_lang,'from'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="from" value="<?= $search_from; ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= $search_to; ?>" name="to" placeholder="<?= print_lang($app_lang,'to'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="to" value="<?= $search_to; ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-2 text-right">
                            <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                        </div>
                    </div>
                    </form>
                    <hr>

                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th style="width: 28%;"><?= print_lang($app_lang,'trial_balance_table_1st_head'); ?></th>
                                    <th style="width: 18%; text-align: center;"><?= print_lang($app_lang,'trial_balance_table_2nd_head'); ?></th>
                                    <th style="width: 18%; text-align: center;"><?= print_lang($app_lang,'trial_balance_table_3rd_head'); ?></th>
                                </tr>
                            </thead>
                            <tbody>

                                <?php
                                $tr_debits = array();
                                $tr_credits = array();
                                $old_balance_total = array();
                                $branch_id = active_branch_id();
                                $branches_for_query = array();
                                $currency_for_query = array();
                                ?>

                                <?php 
                                foreach($root_accounts as $racount){
                                    $debits = 0;
                                    $credits = 0;
                                    $balance = 0;
                                    $row_debits = 0;
                                    $row_credits = 0;
                                    $debits_shared = 0;
                                    $credits_shared = 0;
                                    $total_debits = 0;
                                    $total_credits = 0;
                                    if($racount['branch'] == 'general')
                                    {
                                        $parent_name = print_lang($app_lang,'builtin_account_'.$racount['uid']);
                                    }
                                    else
                                    {
                                        $parent_name = $racount['name'];
                                    }

                                    $debits = isset($balance_summary_data[$racount['uid']]['debit']) ? array_sum($balance_summary_data[$racount['uid']]['debit']) : 0;
                                    $credits = isset($balance_summary_data[$racount['uid']]['credit']) ? array_sum($balance_summary_data[$racount['uid']]['credit']) : 0;
                                    $balance = isset($balance_summary_data[$racount['uid']]['balance']) ? array_sum($balance_summary_data[$racount['uid']]['balance']) : 0;
                                    $balance_old = isset($balance_summary_data_previous[$racount['uid']]['balance']) ? array_sum($balance_summary_data_previous[$racount['uid']]['balance']) : 0;

                                    $balance_color = ($balance >= 0) ? '#2B9C1B' : '#ec4758';

                                    if($racount['uid'] == 'cashbook' OR $racount['uid'] == 'client' OR $racount['uid'] == 'bank' OR $racount['uid'] == 'personal_account' OR $racount['uid'] == 'property_account' OR $racount['uid'] == 'cashbook' OR $racount['uid'] == 'cashbook')
                                    {
                                        $row_debits = $balance;
                                    }
                                    else
                                    {
                                        $row_credits = $balance;
                                    }
                                ?>
                                <tr style="line-height: 35px;">
                                    <td style="width: 28%; text-indent: 20px;"><?= $parent_name; ?></td>
                                    <td style="width: 18%; text-align: center;"><?= amount_number_format($row_debits); $tr_debits[] = $row_debits; ?></td>
                                    <td style="width: 18%; text-align: center;"><?= amount_number_format($row_credits); $tr_credits[] = $row_credits; ?></td>
                                    
                                </tr>
                                <?php } ?>
                                <tr style="line-height: 35px;">
                                    <td style="width: 25%; text-indent: 20px;"><?= print_lang($app_lang,'trial_balance_table_stock'); ?></td>
                                    <?php
                                        $stock = _calculate_system_current_stock(['currencies' => $currencies]);
                                        $stock = $stock[$search_currency];
                                    ?>
                                    <td style="width: 25%; text-align: center;"><?= amount_number_format($stock); $tr_debits[] = $stock; ?></td>
                                    <td style="width: 25%; text-align: center;">0.00</td>
                                    
                                </tr>
                                <tr style="line-height: 35px;">
                                    <td style="width: 25%; text-indent: 20px;"><?= print_lang($app_lang,'trial_balance_table_fixed_assets'); ?></td>
                                    <?php
                                        $assets = DB::table('assets')->where('branch',active_branch_id())->where('currency',$search_currency);
                                        if(!empty($search_from)){ $assets->where('created_at','>=',get_true_date($search_from).' 00:00:00'); }
                                        if(!empty($search_to)){ $assets->where('created_at','<=',get_true_date($search_to).' 23:59:59'); }
                                        $assets = $assets->sum('price');
                                    ?>
                                    <td style="width: 25%; text-align: center;"><?= amount_number_format($assets); $tr_debits[] = $assets; ?></td>
                                    <td style="width: 25%; text-align: center;">0.00</td>
                                    
                                </tr>

                                <tr style="line-height: 35px;">
                                    <td style="width: 25%; text-indent: 20px;"><?= print_lang($app_lang,'trial_balance_table_employee_salary'); ?></td>
                                    <?php
                                        $payslips = DB::table('payslips')->where('branch',active_branch_id())->where('currency',$search_currency);
                                        if(!empty($search_from)){ $payslips->where('pay_date','>=',get_true_date($search_from).' 00:00:00'); }
                                        if(!empty($search_to)){ $payslips->where('pay_date','<=',get_true_date($search_to).' 23:59:59'); }
                                        $payslips = $payslips->sum('net_salary');
                                    ?>
                                    <td style="width: 25%; text-align: center;"><?= amount_number_format($payslips); $tr_debits[] = $payslips; ?></td>
                                    <td style="width: 25%; text-align: center;">0.00</td>
                                    
                                </tr>

                                <tr style="line-height: 35px;">
                                    <td style="width: 25%; text-indent: 20px;"><?= print_lang($app_lang,'trial_balance_table_damage'); ?></td>
                                    <?php
                                        $damage = DB::table('damage')->where('branch',active_branch_id())->where('currency',$search_currency);
                                        if(!empty($search_from)){ $damage->where('created_at','>=',get_true_date($search_from).' 00:00:00'); }
                                        if(!empty($search_to)){ $damage->where('created_at','<=',get_true_date($search_to).' 23:59:59'); }
                                        $damage = $damage->sum('total');
                                    ?>
                                    <td style="width: 25%; text-align: center;">0.00</td>
                                    <td style="width: 25%; text-align: center;"><?= amount_number_format($damage); $tr_credits[] = $damage; ?></td>
                                    
                                </tr>

                                <tr style="line-height: 35px;">
                                    <td style="width: 25%; text-indent: 20px;"><?= print_lang($app_lang,'trial_balance_table_services_income'); ?></td>
                                    <?php
                                        $services = DB::table('services')->where('branch',active_branch_id())->where('currency',$search_currency);
                                        if(!empty($search_from)){ $services->where('service_date','>=',get_true_date($search_from).' 00:00:00'); }
                                        if(!empty($search_to)){ $services->where('service_date','<=',get_true_date($search_to).' 23:59:59'); }
                                        $services = $services->sum('gross_total');
                                    ?>
                                    <td style="width: 25%; text-align: center;">0.00</td>
                                    <td style="width: 25%; text-align: center;"><?= amount_number_format($services); $tr_credits[] = $services; ?></td>
                                    
                                </tr>

                                <tr style="line-height: 35px;">
                                    <td style="width: 25%; text-indent: 20px;"><?= print_lang($app_lang,'trial_balance_table_retained_earnings'); ?></td>
                                    <?php
                                        $sales = DB::table('sales')->where('branch',active_branch_id())->where('currency',$search_currency);
                                        if(!empty($search_from)){ $sales->where('created_at','>=',get_true_date($search_from).' 00:00:00'); }
                                        if(!empty($search_to)){ $sales->where('created_at','<=',get_true_date($search_to).' 23:59:59'); }
                                        $sales = $sales->sum('total_profit_amount');

                                        $sales_return = DB::table('sales')->where('branch',active_branch_id())->where('currency',$search_currency);
                                        if(!empty($search_from)){ $sales_return->where('created_at','>=',get_true_date($search_from).' 00:00:00'); }
                                        if(!empty($search_to)){ $sales_return->where('created_at','<=',get_true_date($search_to).' 23:59:59'); }
                                        $sales_return = $sales_return->sum('return_profit');

                                        $purchase_discounts = DB::table('purchases')->where('branch',active_branch_id())->where('currency',$search_currency)->where('status','passed');
                                        if(!empty($search_from)){ $purchase_discounts->where('created_at','>=',get_true_date($search_from).' 00:00:00'); }
                                        if(!empty($search_to)){ $purchase_discounts->where('created_at','<=',get_true_date($search_to).' 23:59:59'); }
                                        $purchase_discounts = $purchase_discounts->sum('discount_amount');

                                        $retained_earnings = $sales + $purchase_discounts - $sales_return;

                                        if($retained_earnings < 0)
                                        {
                                            $retained_earnings = abs($retained_earnings);
                                        }
                                        else
                                        {
                                            $retained_earnings = '-'.$retained_earnings;
                                        }
                                        
                                    ?>
                                    <td style="width: 25%; text-align: center;">0.00</td>
                                    <td style="width: 25%; text-align: center;"><?= amount_number_format($retained_earnings); $tr_credits[] = $retained_earnings; ?></td>
                                    
                                </tr>

                                <tr style="line-height: 35px;">
                                    <td style="width: 25%; text-indent: 20px;"><?= print_lang($app_lang,'trial_balance_table_transit'); ?></td>
                                    <?php
                                        $transit = DB::table('transit')->where('branch',active_branch_id())->where('currency',$search_currency);
                                        if(!empty($search_from)){ $transit->where('transit_date','>=',get_true_date($search_from).' 00:00:00'); }
                                        if(!empty($search_to)){ $transit->where('transit_date','<=',get_true_date($search_to).' 23:59:59'); }
                                        $transit = $transit->sum('total_exp');
                                    ?>
                                    <td style="width: 25%; text-align: center;"><?= amount_number_format($transit); $tr_debits[] = $transit; ?></td>
                                    <td style="width: 25%; text-align: center;">0.00</td>
                                    
                                </tr>

                                <?php
                                    $balance_color = (array_sum($tr_debits) - array_sum($tr_credits) >= 0) ? '#2B9C1B' : '#ec4758';
                                ?>
                                <tr style="line-height: 35px;">
                                    <td style="width: 28%; text-indent: 20px;"><?= print_lang($app_lang,'total'); ?></td>
                                    <td style="width: 18%; text-align: center;"><?= amount_number_format(array_sum($tr_debits)); ?></td>
                                    <td style="width: 18%; text-align: center;"><?= amount_number_format(array_sum($tr_credits)); ?></td>
                                </tr>

                            </tbody>
                        </table>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>