<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-8">
        <h2><?= print_lang($app_lang,'mod_item_stock_in_view_title'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'mod_item_stock_in_view_title'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-4">
        <div class="title-action">
            <?php if(check_user_access('add_item_stock_in_right') === TRUE){ ?>
                <a href="<?php echo url('/item-stock-in/add'); ?>" class="btn btn-primary btn-sm custom-font-btn"><i class="fa fa-plus"></i>&nbsp; <?= print_lang($app_lang,'mod_item_stock_in_view_add_button'); ?></a>
            <?php } ?>
        </div>
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'mod_item_stock_in_view_title_listing'); ?></h2>
                    <hr>

                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center" style="width:40px;"><?= print_lang($app_lang,'mod_item_stock_in_view_thead_sr'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_item_stock_in_view_thead_date'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_item_stock_in_view_thead_item'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_item_stock_in_view_thead_account'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_item_stock_in_view_thead_currency'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_item_stock_in_view_thead_bill'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_item_stock_in_view_thead_unit'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_item_stock_in_view_thead_quantity'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_item_stock_in_view_thead_cost'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_item_stock_in_view_thead_total'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_item_stock_in_view_details'); ?></th>
                                    <th class="text-center" style="min-width:120px; max-width:120px;"><?= print_lang($app_lang,'mod_item_stock_in_view_thead_action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $quantity_total = [];
                                $cost_total = [];
                                $grand_total = [];
                                 $i = 1; foreach($pageData as $row){ ?>
                                    <tr class="text-center">
                                        <td><?= $i++; ?></td>
                                        <td><?= display_true_date($row['event_date']); ?></td>
                                        <td><?= $row['item_name']; ?></td>
                                        <td><?= $row['account_name']; ?></td>
                                        <td><?= $row['currency_name']; ?></td>
                                        <td><?= $row['bill_number']; ?></td>
                                        <td><?= $row['unit']; ?></td>
                                        <td><?= amount_number_format($row['quantity']); $quantity_total[] = $row['quantity']; ?></td>
                                        <td><?= amount_number_format($row['cost']); $cost_total[] = $row['cost']; ?></td>
                                        <td><?= amount_number_format($row['total']); $grand_total[] = $row['total']; ?></td>
                                        <td><?= $row['details']; ?></td>
                                        <td>
                                            <?php if($row['main_approval'] == 'approved'){?>
                                                <?php if(check_user_access('edit_item_stock_in_right') === TRUE){ ?>
                                                    <a href="<?= url('/item-stock-in/edit').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-primary url-elem"><i class="fa fa-pencil">&nbsp; </i><?= print_lang($app_lang,'mod_item_stock_in_view_thead_edit'); ?></a>
                                                <?php } ?>
                                                <?php if(check_user_access('delete_item_stock_in_right') === TRUE){ ?>
                                                    <a href="<?= url('/item-stock-in/delete').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-danger delete-btn-trigger" data-msg="You will not be able to revert this" data-mood="Delete"><i class="fa fa-trash"></i>&nbsp; <?= print_lang($app_lang,'mod_item_stock_in_view_thead_delete'); ?></a>
                                                <?php } ?>
                                            <?php }else{ ?>
                                                <a href="javascript:void(0);" class="btn btn-xs btn-outline btn-warning" data-msg="You will not be able to revert this" data-mood="Delete"><i class="fa fa-eye"></i>&nbsp; <?= print_lang($app_lang,'pending'); ?></a>
                                            <?php } ?>
                                        </td>
                                    </tr>
                                <?php } ?>
                                    <tr>
                                        <td class="text-center"><strong><?= $i++; ?></strong></td>
                                        <td class="text-center"><strong><?= print_lang($app_lang,'total'); ?></strong></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td class="text-center"><strong><?= amount_number_format(array_sum($quantity_total)); ?></strong></td>
                                        <td class="text-center"><strong><?= amount_number_format(array_sum($cost_total)); ?></strong></td>
                                        <td class="text-center"><strong><?= amount_number_format(array_sum($grand_total)); ?></strong></td>
                                        <td></td>
                                        <td></td>
                                    </tr>
                            </tbody>
                        </table>    
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>