<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'mod_item_stock_out_edit_title'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/item-stock-out'); ?>"><?= print_lang($app_lang,'mod_item_stock_out_view_title'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'mod_item_stock_out_edit_title'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="ibox-title">
        <h5><?= print_lang($app_lang,'fields_with'); ?> <strong class="text-danger">*</strong> <?= print_lang($app_lang,'are_mandatory'); ?></h5>

    </div>
    <div class="ibox-content">
        <!-- spinner -->
        <div class="sk-spinner sk-spinner-three-bounce">
            <div class="sk-bounce1"></div>
            <div class="sk-bounce2"></div>
            <div class="sk-bounce3"></div>
        </div>
        <!-- spinner -->
        <div class="row">
            <div class="col-sm-12 b-r">
                <form role="form" id="item-stock-out-form" action="<?php echo url('/item-stock-out/update').'/'.$editing_data['uid']; ?>">

                    <div class="row extra-mar-botm">
                        <div class="col-md-4">
                            <?php
                                $event_date = display_true_date($editing_data['event_date']);
                            ?>
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'date'); ?> <strong class="text-danger">*</strong></label>
                                <?php if($branch_calander == 'persian'){ ?>
                                    <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($event_date); ?>" name="event_date" placeholder="<?= print_lang($app_lang,'date'); ?>" readonly="" style="background: #fff;">
                                <?php }else{ ?>
                                    <input type="date" class="form-control" name="event_date" value="<?= true_date_for_inputs($event_date); ?>">
                                <?php } ?>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'mod_item_stock_out_add_input_item'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="item" tabindex="4">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'mod_item_stock_out_add_input_item'); ?> --</option>
                                    <?php foreach($item as $row){
                                        if($editing_data['item'] == $row['uid']){ $row['ava_qty'] = (float)$row['ava_qty'] + (float)$editing_data['out_quantity']; }
                                        if((float)$row['ava_qty'] == 0){continue;}
                                    ?>
                                        <option data-available="<?= (float)$row['ava_qty']; ?>" <?php if($editing_data['item'] == $row['uid']){echo "selected='selected'";}?> value="<?= $row['uid']; ?>"><?= $row['name'].' ('.print_lang($app_lang,'mod_item_stock_out_item_ava_text').' - '.(float)$row['ava_qty'].') '; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'mod_item_stock_out_add_input_qty'); ?> <strong class="text-danger">*</strong></label>
                                <input type="text" class="form-control" name="out_quantity" value="<?= $editing_data['out_quantity']; ?>" placeholder="<?= print_lang($app_lang,'mod_item_stock_out_add_input_qty'); ?>">
                            </div>
                        </div>
                    </div>

                    <div class="row extra-mar-botm">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'mod_item_stock_out_add_expense_type'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="expense_type" tabindex="4">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'mod_item_stock_out_add_expense_type'); ?> --</option>
                                    <?php foreach($expense_types as $row){ ?>
                                        <option <?php if($editing_data['expense_type'] == $row['uid']){echo "selected='selected'";}?> value="<?= $row['uid']; ?>"><?= $row['name']; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-8">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'mod_item_stock_out_add_input_details'); ?> </label>
                                <input class="form-control" name="details" value="<?= $editing_data['details']; ?>" placeholder="<?= print_lang($app_lang,'mod_item_stock_out_add_input_details'); ?>">
                            </div>
                        </div>
                    </div>

                    <div class="row extra-mar-botm">
                        <div class="col-md-12 text-right">
                            <a class="btn btn-w-m btn-outline btn-danger url-elem" href="<?php echo url('/item-stock-out'); ?>"><?= print_lang($app_lang,'cancel'); ?></a>
                            <button class="btn btn-w-m btn-primary" type="submit"><?= print_lang($app_lang,'update'); ?></button>
                        </div>
                    </div>

                </form>
            </div>
        </div>
    </div>

</div>