<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-8">
        <h2><?= print_lang($app_lang,'mod_item_stock_in_out_view_title'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'mod_item_stock_in_out_view_title'); ?></strong>
            </li>
        </ol>
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'mod_item_stock_in_out_view_title_listing'); ?></h2>
                    <hr>

                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center" style="width:40px;"><?= print_lang($app_lang,'mod_item_stock_in_out_view_thead_sr'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_item_stock_in_out_view_thead_item'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_item_stock_in_out_view_thead_unit'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_item_stock_in_out_view_thead_currency'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_item_stock_in_out_view_thead_cost'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_item_stock_in_out_view_thead_in_quantity'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_item_stock_in_out_view_thead_out_quantity'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_item_stock_in_out_view_thead_available'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php 
                                $in_total = [];
                                $out_total = [];
                                $cost_total = [];
                                $ava_total = [];
                                $in_amount_total = [];
                                $out_amount_total = [];
                                $ava_amount_total = [];
                                $i = 1;
                                foreach($pageData as $row){
                                    $item_in_amount = $row['in_qty'] * $row['avg_cost']; $in_amount_total[] = $item_in_amount;
                                    $item_out_amount = $row['out_qty'] * $row['avg_cost']; $out_amount_total[] = $item_out_amount;
                                    $item_ava_amount = $row['ava_qty'] * $row['avg_cost']; $ava_amount_total[] = $item_ava_amount;
                                ?>
                                    <tr class="text-center">
                                        <td><?= $i++; ?></td>
                                        <td><?= $row['name']; ?></td>
                                        <td><?= $row['unit']; ?></td>
                                        <td><?= $row['currency_name']; ?></td>
                                        <td><?= amount_number_format($row['avg_cost']); $cost_total[] = (float)$row['avg_cost']; ?></td>
                                        <td><?= $row['in_qty'].' ('.amount_number_format($item_in_amount).')'; $in_total[] = $row['in_qty']; ?></td>
                                        <td><?= $row['out_qty'].' ('.amount_number_format($item_out_amount).')'; $out_total[] = $row['out_qty']; ?></td>
                                        <td><?= $row['ava_qty'].' ('.amount_number_format($item_ava_amount).')'; $ava_total[] = $row['ava_qty']; ?></td>
                                    </tr>
                                <?php } ?>
                                    <tr class="text-center">
                                        <td><strong><?= $i++; ?></strong></td>
                                        <td><strong><?= print_lang($app_lang,'total'); ?></strong></td>
                                        <td></td>
                                        <td></td>
                                        <td><strong><?= amount_number_format(array_sum($cost_total)); ?></strong></td>
                                        <td><strong><?= array_sum($in_total).' ('.amount_number_format(array_sum($in_amount_total)).')'; ?></strong></td>
                                        <td><strong><?= array_sum($out_total).' ('.amount_number_format(array_sum($out_amount_total)).')'; ?></strong></td>
                                        <td><strong><?= array_sum($ava_total).' ('.amount_number_format(array_sum($ava_amount_total)).')'; ?></strong></td>
                                    </tr>
                            </tbody>
                        </table>    
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>