<?php

    $listing_columns = items_colums_array();
    $columns_data = fetch_table_where('items_columns','branch_id',active_branch_id(),true);
    if(!empty($columns_data))
    {
        if(!empty($columns_data['columns']))
        {
            $listing_columns = explode(',', $columns_data['columns']);
        }
    }

?>
<?php $item_settings = get_item_settings(); ?>

<style>
    .pagination {
        margin: 0 !important;
    }
</style>

<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-8">
        <h2><?= print_lang($app_lang,'items'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'items'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-4">
        <div class="title-action">
            <?php if(check_user_access('add_item') === TRUE){ ?>
                <a href="<?= url('/items/add'); ?>" class="btn btn-primary btn-sm custom-font-btn"><i class="fa fa-plus"></i>&nbsp; <?= print_lang($app_lang,'add_new_item'); ?></a>
            <?php } ?>
        </div>
    </div>
</div>



<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <!-- spinner -->
                    <div class="sk-spinner sk-spinner-three-bounce">
                        <div class="sk-bounce1"></div>
                        <div class="sk-bounce2"></div>
                        <div class="sk-bounce3"></div>
                    </div>
                    <!-- spinner -->

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'items_listing'); ?></h2>

                    <form id="items-search-form" action="<?= url('/items-all'); ?>">
                    <div class="row">
                        <div class="col-md-9">
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <select class="form-control chosen-select" name="type">
                                            <option selected="" value="">-- <?= print_lang($app_lang,'select_type'); ?> --</option>
                                            <option value="sales" <?php if($search_type == 'sales'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'sales'); ?></option>
                                            <option value="raw" <?php if($search_type == 'raw'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'raw'); ?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <select class="form-control chosen-select" name="category">
                                            <option selected="" value="">-- <?= print_lang($app_lang,'select_category'); ?> --</option>
                                            <?php foreach($product_categories as $row){ ?>
                                                <option value="<?= $row['uid']; ?>" <?php if($search_category == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <select class="form-control chosen-select" name="currency">
                                            <option selected="" value="">-- <?= print_lang($app_lang,'select_currency'); ?> --</option>
                                            <?php $currency_data = array(); foreach($currencies as $row){ ?>
                                                <option value="<?= $row['uid']; ?>" <?php if($search_currency == $row['uid']){ $currency_data = $row; echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <select class="form-control chosen-select" name="unit">
                                            <option selected="" value="">-- <?= print_lang($app_lang,'select_unit'); ?> --</option>
                                            <?php foreach($units as $row){ ?>
                                                <option value="<?= $row['uid']; ?>" <?php if($search_unit == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-2 text-right" style="padding: 2px !important;">
                            <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                        </div>
                        <div class="col-md-1">
                            <a target="_blank" href="<?= url('/items-print').'?'.'type='.$search_type.'&category='.$search_category.'&currency='.$search_currency.'&unit='.$search_unit.''; ?>" class="btn btn-outline btn-primary dim"><i class="fa fa-print"></i></a>
                        </div>
                    </div>
                    </form>
                    <hr>

                    <div class="table-responsive">

                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <?php if(in_array('sr_num', $listing_columns)){?>
                                        <th class="text-center"><?= print_lang($app_lang,'sr_#'); ?></th>
                                    <?php } ?>
                                    <?php if(in_array('name', $listing_columns)){?>
                                        <th class="text-center" style="width:200px;"><?= print_lang($app_lang,'name'); ?></th>
                                    <?php } ?>
                                    <?php if(in_array('category', $listing_columns)){?>
                                        <th class="text-center"><?= print_lang($app_lang,'category'); ?></th>
                                    <?php } ?>
                                    <?php if(in_array('country', $listing_columns)){?>
                                        <th class="text-center"><?= print_lang($app_lang,'item_country_thead'); ?></th>
                                    <?php } ?>
                                    <?php if(in_array('company', $listing_columns)){?>
                                        <th class="text-center"><?= print_lang($app_lang,'item_company_thead'); ?></th>
                                    <?php } ?>
                                    <?php if(in_array('details', $listing_columns)){?>
                                        <th class="text-center"><?= print_lang($app_lang,'item_details_thead'); ?></th>
                                    <?php } ?>
                                    <?php if(in_array('currency', $listing_columns)){?>
                                        <th class="text-center"><?= print_lang($app_lang,'currency'); ?></th>
                                    <?php } ?>
                                    <?php if(in_array('unit', $listing_columns)){?>
                                        <th class="text-center"><?= print_lang($app_lang,'unit'); ?></th>
                                    <?php } ?>
                                    <?php if(in_array('avg_cost', $listing_columns)){?>
                                        <th class="text-center"><?= print_lang($app_lang,'avg_cost'); ?></th>
                                    <?php } ?>
                                    <?php if(in_array('last_cost', $listing_columns)){?>
                                        <th class="text-center"><?= print_lang($app_lang,'last_cost'); ?></th>
                                    <?php } ?>
                                    <?php if(in_array('sale_price', $listing_columns)){?>
                                        <th class="text-center"><?= print_lang($app_lang,'sale_price'); ?></th>
                                    <?php } ?>
                                    <?php if(in_array('stock_in', $listing_columns)){?>
                                        <th class="text-center"><?= print_lang($app_lang,'stock_in'); ?></th>
                                    <?php } ?>
                                    <?php if(in_array('stock_out', $listing_columns)){?>
                                        <th class="text-center"><?= print_lang($app_lang,'stock_out'); ?></th>
                                    <?php } ?>
                                    <?php if($item_settings['transfer'] == 'b_transfer'){ ?>
                                        <?php if(in_array('branch_transfer_in', $listing_columns)){?>
                                            <th class="text-center"><?= print_lang($app_lang,'branch_transfer_in_short'); ?></th>
                                        <?php } ?>
                                        <?php if(in_array('branch_transfer_out', $listing_columns)){?>
                                            <th class="text-center"><?= print_lang($app_lang,'branch_transfer_out_short'); ?></th>
                                        <?php } ?>
                                    <?php } ?>

                                    <?php if($item_settings['transfer'] == 'n_transfer'){ ?>
                                        <?php if(in_array('transfer_in', $listing_columns)){?>
                                            <th class="text-center"><?= print_lang($app_lang,'ph_transfer_in_short'); ?></th>
                                        <?php } ?>
                                        <?php if(in_array('transfer_out', $listing_columns)){?>
                                            <th class="text-center"><?= print_lang($app_lang,'ph_transfer_out_short'); ?></th>
                                        <?php } ?>
                                    <?php } ?>

                                    <?php if(in_array('branch_to_branch_in', $listing_columns)){?>
                                        <th class="text-center"><?= print_lang($app_lang,'mod_branch_to_branch_iem_table_head_in'); ?></th>
                                    <?php } ?>
                                    <?php if(in_array('branch_to_branch_out', $listing_columns)){?>
                                        <th class="text-center"><?= print_lang($app_lang,'mod_branch_to_branch_iem_table_head_out'); ?></th>
                                    <?php } ?>

                                    <?php if(in_array('production_in', $listing_columns)){?>
                                        <th class="text-center"><?= print_lang($app_lang,'mode_production_thead_title_in'); ?></th>
                                    <?php } ?>
                                    <?php if(in_array('production_out', $listing_columns)){?>
                                        <th class="text-center"><?= print_lang($app_lang,'mode_production_thead_title_out'); ?></th>
                                    <?php } ?>
                                    <?php if($item_settings['bundle_toop'] == 'enable'){ ?>
                                        <?php if(in_array('bundle', $listing_columns)){?>
                                            <th class="text-center"><?= print_lang($app_lang,'bundle_ava'); ?></th>
                                        <?php } ?>
                                        <?php if(in_array('toop', $listing_columns)){?>
                                            <th class="text-center"><?= print_lang($app_lang,'toop_ava'); ?></th>
                                        <?php } ?>
                                    <?php } ?>
                                    <?php if(in_array('damage', $listing_columns)){?>
                                        <th class="text-center"><?= print_lang($app_lang,'damage'); ?></th>
                                    <?php } ?>
                                    <?php if(in_array('available', $listing_columns)){?>
                                        <th class="text-center"><?= print_lang($app_lang,'available'); ?></th>
                                    <?php } ?>
                                    <th class="text-center"><?= print_lang($app_lang,'value'); ?></th>

                                    <?php if($item_settings['item_measurements'] == 'get'){ ?>
                                        <?php if(in_array('width', $listing_columns)){?>
                                            <th class="text-center"><?= print_lang($app_lang,'width'); ?></th>
                                        <?php } ?>
                                        <?php if(in_array('height', $listing_columns)){?>
                                            <th class="text-center"><?= print_lang($app_lang,'height'); ?></th>
                                        <?php } ?>
                                        <?php if(in_array('length', $listing_columns)){?>
                                            <th class="text-center"><?= print_lang($app_lang,'length'); ?></th>
                                        <?php } ?>
                                        <?php if(in_array('cube_meter', $listing_columns)){?>
                                            <th class="text-center"><?= print_lang($app_lang,'cube_meter'); ?></th>
                                        <?php } ?>
                                        <?php if(in_array('total_cube_meter', $listing_columns)){?>
                                            <th class="text-center"><?= print_lang($app_lang,'total_cube_meter'); ?></th>
                                        <?php } ?>
                                    <?php } ?>

                                    <?php if($item_settings['cbm'] == 'enable'){ ?>
                                        <?php if(in_array('cbm', $listing_columns)){?>
                                            <th class="text-center"><?= print_lang($app_lang,'cbm'); ?></th>
                                        <?php } ?>
                                        <?php if(in_array('total_cbm', $listing_columns)){?>
                                            <th class="text-center"><?= print_lang($app_lang,'total_cbm'); ?></th>
                                        <?php } ?>
                                        <?php if(in_array('weight', $listing_columns)){?>
                                            <th class="text-center"><?= print_lang($app_lang,'weight'); ?></th>
                                        <?php } ?>
                                        <?php if(in_array('total_weight', $listing_columns)){?>
                                            <th class="text-center"><?= print_lang($app_lang,'total_weiight'); ?></th>
                                        <?php } ?>
                                    <?php } ?>

                                    <?php if(in_array('image', $listing_columns)){?>
                                        <th class="text-center"><?= print_lang($app_lang,'image'); ?></th>
                                    <?php } ?>
                                    <?php if(in_array('action', $listing_columns)){?>
                                        <th class="text-center" style="min-width:60px;"><?= print_lang($app_lang,'action'); ?></th>
                                    <?php } ?>
                                </tr>
                            </thead>
                            

                            <tbody>
                                <?php
                                $i = 1;
                                $total_avg_cost = array();
                                $total_last_cost = array();
                                $total_first_cost = array();
                                $total_sales_price = array();
                                $total_stock_in_units = array();
                                $total_stock_out_units = array();
                                $total_branch_transfer_in_units = array();
                                $total_branch_transfer_out_units = array();
                                $total_branch_to_branch_transfer_in_units = array();
                                $total_branch_to_branch_transfer_out_units = array();
                                $total_production_in_units = array();
                                $total_production_out_units = array();
                                $total_ph_transfer_in_units = array();
                                $total_ph_transfer_out_units = array();
                                $total_bundle_stock_units = array();
                                $total_toop_stock_units = array();
                                $total_stock_damage_units = array();
                                $total_stock_avail_units = array();
                                $total_of_item_width = array();
                                $total_of_item_height = array();
                                $total_of_item_length = array();
                                $total_of_item_cube_meter = array();
                                $total_of_item_total_cube_meter = array();
                                $total_cbm = array();
                                $total_cbm_amount = array();
                                $total_weight = array();
                                $total_weight_amount = array();
                                $total_value_amount = array();
                                foreach($pageData as $row){
                                    $row['stats'] = json_decode($row['stats'],true);
                                ?>
                                    <tr class="text-center">
                                        <?php if(in_array('sr_num', $listing_columns)){?>
                                            <td><?= $i++; ?></td>
                                        <?php } ?>
                                        <?php if(in_array('name', $listing_columns)){?>
                                            <td><?= $row['name']; ?></td>
                                        <?php } ?>
                                        <?php if(in_array('category', $listing_columns)){?>
                                            <td><?= array_key_exists($row['category'], $product_categories) ? $product_categories[$row['category']]['name'] : NULL; ?></td>
                                        <?php } ?>
                                        <?php if(in_array('country', $listing_columns)){?>
                                            <td><?= $row['country']; ?></td>
                                        <?php } ?>
                                        <?php if(in_array('company', $listing_columns)){?>
                                            <td><?= $row['company']; ?></td>
                                        <?php } ?>
                                        <?php if(in_array('details', $listing_columns)){?>
                                            <td><?= $row['details']; ?></td>
                                        <?php } ?>
                                        <?php
                                        $currency_name = array_key_exists($row['currency'], $currencies) ? $currencies[$row['currency']]['name'] : NULL;
                                        if(!empty($search_currency))
                                        {
                                            $currency_name = array_key_exists($search_currency, $currencies) ? $currencies[$search_currency]['name'] : NULL;
                                        }
                                        ?>
                                        <?php if(in_array('currency', $listing_columns)){?>
                                            <td><?= $currency_name; ?></td>
                                        <?php } ?>
                                        <?php if(in_array('unit', $listing_columns)){?>
                                            <td>
                                                <?php if($row['purchase_unit'] == $search_unit){ ?>
                                                    <span class="text-info font-bold"><?= array_key_exists($row['purchase_unit'], $units) ? $units[$row['purchase_unit']]['short'] : NULL; ?></span>
                                                <?php }else if($row['sale_unit'] == $search_unit){ ?>
                                                    <span class="text-info font-bold"><?= array_key_exists($row['sale_unit'], $units) ? $units[$row['sale_unit']]['short'] : NULL; ?></span>
                                                <?php }else if($row['production_unit'] == $search_unit){ ?>
                                                    <span class="text-info font-bold"><?= array_key_exists($row['production_unit'], $units) ? $units[$row['production_unit']]['short'] : NULL; ?></span>
                                                <?php }else{ ?>
                                                    <span class="text-info font-bold"><?= array_key_exists($row['purchase_unit'], $units) ? $units[$row['purchase_unit']]['short'] : NULL; ?></span>
                                                <?php } ?>
                                            </td>
                                        <?php } ?>

                                        <?php

                                        // currency conversion
                                        $item_avg_cost = $row['stats']['avg_cost'];
                                        $item_last_cost = $row['stats']['last_cost'];
                                        $item_first_cost = $row['cost'];
                                        $item_sale_price = $row['stats']['avg_cost'] + $row['stats']['last_profit'];

                                        // $item_stock_in_units = sum_up_array_values($row['stats']['stock_in_units']);
                                        // $item_stock_out_units = sum_up_array_values($row['stats']['stock_out_units']);
                                        $item_stock_in_units = sum_up_array_values($row['stats']['opening_units']) + sum_up_array_values($row['stats']['purchase_units']) + sum_up_array_values($row['stats']['sale_return_units']);
                                        $item_stock_out_units = sum_up_array_values($row['stats']['sale_units']);

                                        $item_branch_transfer_in_units = sum_up_array_values($row['stats']['branch_transfer_in_units']);
                                        $item_branch_transfer_out_units = sum_up_array_values($row['stats']['branch_transfer_out_units']);

                                        $item_branch_to_branch_transfer_in_units = isset($row['stats']['branch_to_branch_transfer_in_units']) ? sum_up_array_values($row['stats']['branch_to_branch_transfer_in_units']) : null; // sum_up_array_values($row['stats']['branch_to_branch_transfer_in_units']);
                                        $item_branch_to_branch_transfer_out_units = isset($row['stats']['branch_to_branch_transfer_out_units']) ? sum_up_array_values($row['stats']['branch_to_branch_transfer_out_units']) : null; //sum_up_array_values($row['stats']['branch_to_branch_transfer_out_units']);

                                        $item_production_in_units = isset($row['stats']['production_in_units']) ? sum_up_array_values($row['stats']['production_in_units']) : null; //sum_up_array_values($row['stats']['production_in_units']);
                                        $item_production_out_units = isset($row['stats']['production_out_units']) ? sum_up_array_values($row['stats']['production_out_units']) : null; //sum_up_array_values($row['stats']['production_out_units']);

                                        $item_ph_transfer_in_units = sum_up_array_values($row['stats']['transfer_in_pharma']);
                                        $item_ph_transfer_out_units = sum_up_array_values($row['stats']['transfer_out_pharma']);
                                        
                                        $item_damage_units = sum_up_array_values($row['stats']['damage_units']);
                                        $item_avail_units = sum_up_array_values($row['stats']['avail_units']);

                                        $bundle_stock_in_units = sum_up_array_values(isset($row['stats']['bundle_stock_in_units']) ? $row['stats']['bundle_stock_in_units'] : []);
                                        $bundle_stock_out_units = sum_up_array_values(isset($row['stats']['bundle_stock_out_units']) ? $row['stats']['bundle_stock_out_units'] : []);
                                        $bundle_ava_units = $bundle_stock_in_units - $bundle_stock_out_units;

                                        $toop_stock_in_units = sum_up_array_values(isset($row['stats']['toop_stock_in_units']) ? $row['stats']['toop_stock_in_units'] : []);
                                        $toop_stock_out_units = sum_up_array_values(isset($row['stats']['toop_stock_out_units']) ? $row['stats']['toop_stock_out_units'] : []);
                                        $toop_ava_units = $toop_stock_in_units - $toop_stock_out_units;

                                        if(!empty($search_currency))
                                        {
                                            $item_avg_cost = amount_conversion($item_avg_cost, $row['currency_usd_equalance'], $currency_data['usd_equalance']);
                                            $item_last_cost = amount_conversion($item_last_cost, $row['currency_usd_equalance'], $currency_data['usd_equalance']);
                                            $item_first_cost = amount_conversion($item_first_cost, $row['currency_usd_equalance'], $currency_data['usd_equalance']);
                                            $item_sale_price = amount_conversion($item_sale_price, $row['currency_usd_equalance'], $currency_data['usd_equalance']);
                                        }

                                        if(!empty($search_unit))
                                        {
                                            if($row['purchase_unit'] == $search_unit){ $unit_identifier = 'purchase'; }
                                            else if($row['sale_unit'] == $search_unit){ $unit_identifier = 'sale'; }
                                            else if($row['production_unit'] == $search_unit){ $unit_identifier = 'production'; }
                                            else{ $unit_identifier = 'purchase'; }

                                            $item_avg_cost = amount_unit_based_conversion($row,$unit_identifier,$item_avg_cost);
                                            $item_last_cost = amount_unit_based_conversion($row,$unit_identifier,$item_last_cost);
                                            $item_first_cost = amount_unit_based_conversion($row,$unit_identifier,$item_first_cost);
                                            $item_sale_price = amount_unit_based_conversion($row,$unit_identifier,$item_sale_price);

                                            $item_stock_in_units = unit_based_conversion($row,$unit_identifier,$item_stock_in_units);
                                            $item_stock_out_units = unit_based_conversion($row,$unit_identifier,$item_stock_out_units);
                                            $item_branch_transfer_in_units = unit_based_conversion($row,$unit_identifier,$item_branch_transfer_in_units);
                                            $item_branch_transfer_out_units = unit_based_conversion($row,$unit_identifier,$item_branch_transfer_out_units);

                                            $item_ph_transfer_in_units = unit_based_conversion($row,$unit_identifier,$item_ph_transfer_in_units);
                                            $item_ph_transfer_out_units = unit_based_conversion($row,$unit_identifier,$item_ph_transfer_out_units);

                                            $item_damage_units = unit_based_conversion($row,$unit_identifier,$item_damage_units);
                                            $item_avail_units = unit_based_conversion($row,$unit_identifier,$item_avail_units);

                                            $item_branch_to_branch_transfer_in_units = unit_based_conversion($row,$unit_identifier,$item_branch_to_branch_transfer_in_units);
                                            $item_branch_to_branch_transfer_out_units = unit_based_conversion($row,$unit_identifier,$item_branch_to_branch_transfer_out_units);

                                            $item_production_in_units = unit_based_conversion($row,$unit_identifier,$item_production_in_units);
                                            $item_production_out_units = unit_based_conversion($row,$unit_identifier,$item_production_out_units);
                                        }

                                        $item_width = (float)$row['width'];
                                        $item_height = (float)$row['height'];
                                        $item_length = (float)$row['length'];
                                        $item_cube_meter = $item_width * $item_height;
                                        $item_total_cube_meter = $item_cube_meter * $item_avail_units;

                                        ?>

                                        <?php if(in_array('avg_cost', $listing_columns)){?>
                                            <td><?= round_decimels_digits($item_avg_cost); $total_avg_cost[] = $item_avg_cost; ?></td>
                                        <?php } ?>
                                        <?php if(in_array('last_cost', $listing_columns)){?>
                                            <td><?= round_decimels_digits($item_last_cost); $total_last_cost[] = $item_last_cost; ?></td>
                                        <?php } ?>
                                        <?php if(in_array('sale_price', $listing_columns)){?>
                                            <td><?= round_decimels_digits($item_sale_price); $total_sales_price[] = $item_sale_price; ?></td>
                                        <?php } ?>
                                        
                                        <?php if(in_array('stock_in', $listing_columns)){?>
                                            <td><?= round_decimels_digits($item_stock_in_units); $total_stock_in_units[] = $item_stock_in_units; ?></td>
                                        <?php } ?>
                                        <?php if(in_array('stock_out', $listing_columns)){?>
                                            <td><?= round_decimels_digits($item_stock_out_units); $total_stock_out_units[] = $item_stock_out_units; ?></td>
                                        <?php } ?>
                                        <?php if($item_settings['transfer'] == 'b_transfer'){ ?>
                                            <?php if(in_array('branch_transfer_in', $listing_columns)){?>
                                                <td><?= round_decimels_digits($item_branch_transfer_in_units); $total_branch_transfer_in_units[] = $item_branch_transfer_in_units; ?></td>
                                            <?php } ?>
                                            <?php if(in_array('branch_transfer_out', $listing_columns)){?>
                                                <td><?= round_decimels_digits($item_branch_transfer_out_units); $total_branch_transfer_out_units[] = $item_branch_transfer_out_units; ?></td>
                                            <?php } ?>
                                        <?php } ?>

                                        <?php if($item_settings['transfer'] == 'n_transfer'){ ?>
                                            <?php if(in_array('transfer_in', $listing_columns)){?>
                                                <td><?= round_decimels_digits($item_ph_transfer_in_units); $total_ph_transfer_in_units[] = $item_ph_transfer_in_units; ?></td>
                                            <?php } ?>
                                            <?php if(in_array('transfer_out', $listing_columns)){?>
                                                <td><?= round_decimels_digits($item_ph_transfer_out_units); $total_ph_transfer_out_units[] = $item_ph_transfer_out_units; ?></td>
                                            <?php } ?>
                                        <?php } ?>

                                        <?php if(in_array('branch_to_branch_in', $listing_columns)){?>
                                            <td><?= round_decimels_digits($item_branch_to_branch_transfer_in_units); $total_branch_to_branch_transfer_in_units[] = $item_branch_to_branch_transfer_in_units; ?></td>
                                        <?php } ?>
                                        <?php if(in_array('branch_to_branch_out', $listing_columns)){?>
                                            <td><?= round_decimels_digits($item_branch_to_branch_transfer_out_units); $total_branch_to_branch_transfer_out_units[] = $item_branch_to_branch_transfer_out_units; ?></td>
                                        <?php } ?>

                                        <?php if(in_array('production_in', $listing_columns)){?>
                                            <td><?= round_decimels_digits($item_production_in_units); $total_production_in_units[] = $item_production_in_units; ?></td>
                                        <?php } ?>
                                        <?php if(in_array('production_out', $listing_columns)){?>
                                            <td><?= round_decimels_digits($item_production_out_units); $total_production_out_units[] = $item_production_out_units; ?></td>
                                        <?php } ?>
                                        <?php if($item_settings['bundle_toop'] == 'enable'){ ?>
                                            <?php if(in_array('bundle', $listing_columns)){?>
                                                <td><?= round_decimels_digits($bundle_ava_units); $total_bundle_stock_units[] = $bundle_ava_units; ?></td>
                                            <?php } ?>
                                            <?php if(in_array('toop', $listing_columns)){?>
                                                <td><?= round_decimels_digits($toop_ava_units); $total_toop_stock_units[] = $toop_ava_units; ?></td>
                                            <?php } ?>
                                        <?php } ?>
                                        <?php if(in_array('damage', $listing_columns)){?>
                                            <td><?= round_decimels_digits($item_damage_units); $total_stock_damage_units[] = $item_damage_units; ?></td>
                                        <?php } ?>
                                        <?php if(in_array('available', $listing_columns)){?>
                                            <td><?= round_decimels_digits($item_avail_units); $total_stock_avail_units[] = $item_avail_units; ?></td>
                                        <?php } ?>

                                        <?php
                                        $item_total_value = $item_avg_cost * $item_avail_units;
                                        ?>

                                        <td><?= round_decimels_digits($item_total_value); $total_value_amount[] = $item_total_value;?></td>
                                        
                                        <?php if($item_settings['item_measurements'] == 'get'){ ?>
                                            <?php if(in_array('width', $listing_columns)){?>
                                                <td><?= round_decimels_digits( $item_width ); $total_of_item_width[] = $item_width; ?></td>
                                            <?php } ?>
                                            <?php if(in_array('height', $listing_columns)){?>
                                                <td><?= round_decimels_digits( $item_height ); $total_of_item_height[] = $item_height; ?></td>
                                            <?php } ?>
                                            <?php if(in_array('length', $listing_columns)){?>
                                                <td><?= round_decimels_digits( $item_length ); $total_of_item_length[] = $item_length; ?></td>
                                            <?php } ?>
                                            <?php if(in_array('cube_meter', $listing_columns)){?>
                                                <td><?= round_decimels_digits( $item_cube_meter ); $total_of_item_cube_meter[] = $item_cube_meter; ?></td>
                                            <?php } ?>
                                            <?php if(in_array('total_cube_meter', $listing_columns)){?>
                                                <td><?= round_decimels_digits( $item_total_cube_meter ); $total_of_item_total_cube_meter[] = $item_total_cube_meter; ?></td>
                                            <?php } ?>
                                        <?php } ?>

                                        <?php if($item_settings['cbm'] == 'enable'){ ?>
                                            <?php if(in_array('cbm', $listing_columns)){?>
                                                <td><?= $row['cbm']; $total_cbm[] = $row['cbm']; ?></td>
                                            <?php } ?>
                                            <?php if(in_array('total_cbm', $listing_columns)){?>
                                                <td><?= round_decimels_digits($item_avail_units * $row['cbm']); $total_cbm_amount[] = $row['cbm'] * $item_avail_units; ?></td>
                                            <?php } ?>
                                            <?php if(in_array('weight', $listing_columns)){?>
                                                <td><?= $row['weight']; $total_weight[] = $row['weight']; ?></td>
                                            <?php } ?>
                                            <?php if(in_array('total_weight', $listing_columns)){?>
                                                <td><?= round_decimels_digits($item_avail_units * $row['weight']); $total_weight_amount[] = $row['weight'] * $item_avail_units; ?></td>
                                            <?php } ?>
                                        <?php } ?>

                                        <?php if(in_array('image', $listing_columns)){?>
                                            <td>
                                                <?php
                                                $item_image = base_path().'/uploads/items/'.$row['item_image'];
                                                if(is_file($item_image))
                                                {
                                                    $item_image = url('/').'/uploads/items/'.$row['item_image'];
                                                ?>
                                                <?php if(check_user_access('view_item_image') === TRUE){ ?>
                                                    <a href="<?= $item_image; ?>" target="_blank" class="btn btn-xs btn-outline btn-primary url-elem"><i class="fa fa-file-photo-o">&nbsp; </i><?= print_lang($app_lang,'image'); ?></a>
                                                <?php } ?>
                                                <?php
                                                }
                                                ?>
                                            </td>
                                        <?php } ?>

                                        <?php if(in_array('action', $listing_columns)){?>
                                            <td>
                                                    <?php if(check_user_access('edit_item') === TRUE){ ?>
                                                        <a href="<?= url('/items/edit').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-primary url-elem"><i class="fa fa-pencil"></i></a>
                                                    <?php } ?>
                                                <?php if(Session::get('branch_uid') != $row['uid']){ ?>
                                                    <?php if(check_user_access('delete_item') === TRUE){ ?>
                                                        <a href="<?= url('/items/delete').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-danger delete-btn-trigger" data-msg="You will not be able to revert this" data-mood="Delete"><i class="fa fa-trash"></i></a>
                                                    <?php } ?>
                                                <?php } ?>
                                            </td>
                                        <?php } ?>
                                    </tr>
                                <?php } ?>

                                <tr class="text-center">
                                    <?php if(in_array('sr_num', $listing_columns)){?>
                                        <td><?= $i++; ?></td>
                                    <?php } ?>
                                    <?php if(in_array('name', $listing_columns)){?>
                                        <td><?= print_lang($app_lang,'total'); ?></td>
                                    <?php } ?>
                                    <?php if(in_array('category', $listing_columns)){?>
                                        <td></td>
                                    <?php } ?>
                                    <?php if(in_array('country', $listing_columns)){?>
                                        <td></td>
                                    <?php } ?>
                                    <?php if(in_array('company', $listing_columns)){?>
                                        <td></td>
                                    <?php } ?>
                                    <?php if(in_array('details', $listing_columns)){?>
                                        <td></td>
                                    <?php } ?>
                                    <?php if(in_array('currency', $listing_columns)){?>
                                        <td></td>
                                    <?php } ?>
                                    <?php if(in_array('unit', $listing_columns)){?>
                                        <td></td>
                                    <?php } ?>
                                    <?php if(in_array('avg_cost', $listing_columns)){?>
                                        <td><?= round_decimels_digits(array_sum($total_avg_cost)); ?></td>
                                    <?php } ?>
                                    <?php if(in_array('last_cost', $listing_columns)){?>
                                        <td><?= round_decimels_digits(array_sum($total_last_cost)); ?></td>
                                    <?php } ?>
                                    <?php if(in_array('sale_price', $listing_columns)){?>
                                        <td><?= round_decimels_digits(array_sum($total_sales_price)); ?></td>
                                    <?php } ?>
                                    <?php if(in_array('stock_in', $listing_columns)){?>
                                        <td><?= round_decimels_digits(array_sum($total_stock_in_units)); ?></td>
                                    <?php } ?>
                                    <?php if(in_array('stock_out', $listing_columns)){?>
                                        <td><?= round_decimels_digits(array_sum($total_stock_out_units)); ?></td>
                                    <?php } ?>
                                    <?php if($item_settings['transfer'] == 'b_transfer'){ ?>
                                        <?php if(in_array('branch_transfer_in', $listing_columns)){?>
                                            <td><?= round_decimels_digits(array_sum($total_branch_transfer_in_units)); ?></td>
                                        <?php } ?>
                                        <?php if(in_array('branch_transfer_out', $listing_columns)){?>
                                            <td><?= round_decimels_digits(array_sum($total_branch_transfer_out_units)); ?></td>
                                        <?php } ?>
                                    <?php } ?>

                                    <?php if($item_settings['transfer'] == 'n_transfer'){ ?>
                                        <?php if(in_array('transfer_in', $listing_columns)){?>
                                            <td><?= round_decimels_digits(array_sum($total_ph_transfer_in_units)); ?></td>
                                        <?php } ?>
                                        <?php if(in_array('transfer_out', $listing_columns)){?>
                                            <td><?= round_decimels_digits(array_sum($total_ph_transfer_out_units)); ?></td>
                                        <?php } ?>
                                    <?php } ?>
                                    <?php if(in_array('branch_to_branch_in', $listing_columns)){?>
                                        <td><?= round_decimels_digits(array_sum($total_branch_to_branch_transfer_in_units)); ?></td>
                                    <?php } ?>
                                    <?php if(in_array('branch_to_branch_out', $listing_columns)){?>
                                        <td><?= round_decimels_digits(array_sum($total_branch_to_branch_transfer_out_units)); ?></td>
                                    <?php } ?>
                                    <?php if(in_array('production_in', $listing_columns)){?>
                                        <td><?= round_decimels_digits(array_sum($total_production_in_units)); ?></td>
                                    <?php } ?>
                                    <?php if(in_array('production_out', $listing_columns)){?>
                                        <td><?= round_decimels_digits(array_sum($total_production_out_units)); ?></td>
                                    <?php } ?>
                                    <?php if($item_settings['bundle_toop'] == 'enable'){ ?>
                                        <?php if(in_array('bundle', $listing_columns)){?>
                                            <td><?= round_decimels_digits(array_sum($total_bundle_stock_units)); ?></td>
                                        <?php } ?>
                                        <?php if(in_array('toop', $listing_columns)){?>
                                            <td><?= round_decimels_digits(array_sum($total_toop_stock_units)); ?></td>
                                        <?php } ?>
                                    <?php } ?>
                                    <?php if(in_array('damage', $listing_columns)){?>
                                        <td><?= round_decimels_digits(array_sum($total_stock_damage_units)); ?></td>
                                    <?php } ?>
                                    <?php if(in_array('available', $listing_columns)){?>
                                        <td><?= round_decimels_digits(array_sum($total_stock_avail_units)); ?></td>
                                    <?php } ?>

                                    <td><?= round_decimels_digits(array_sum($total_value_amount)); ?></td>
                                    
                                    <?php if($item_settings['item_measurements'] == 'get'){ ?>
                                        <?php if(in_array('width', $listing_columns)){?>
                                            <td><?= round_decimels_digits( array_sum($total_of_item_width) ); ?></td>
                                        <?php } ?>
                                        <?php if(in_array('height', $listing_columns)){?>
                                            <td><?= round_decimels_digits( array_sum($total_of_item_height) ); ?></td>
                                        <?php } ?>
                                        <?php if(in_array('length', $listing_columns)){?>
                                            <td><?= round_decimels_digits( array_sum($total_of_item_length) ); ?></td>
                                        <?php } ?>
                                        <?php if(in_array('cube_meter', $listing_columns)){?>
                                            <td><?= round_decimels_digits( array_sum($total_of_item_cube_meter) ); ?></td>
                                        <?php } ?>
                                        <?php if(in_array('total_cube_meter', $listing_columns)){?>
                                            <td><?= round_decimels_digits( array_sum($total_of_item_total_cube_meter) ); ?></td>
                                        <?php } ?>
                                    <?php } ?>

                                    <?php if($item_settings['cbm'] == 'enable'){ ?>
                                        <?php if(in_array('cbm', $listing_columns)){?>
                                            <td><?= round_decimels_digits( array_sum($total_cbm) ); ?></td>
                                        <?php } ?>
                                        <?php if(in_array('total_cbm', $listing_columns)){?>
                                            <td><?= round_decimels_digits( array_sum($total_cbm_amount) ); ?></td>
                                        <?php } ?>
                                        <?php if(in_array('weight', $listing_columns)){?>
                                            <td><?= round_decimels_digits( array_sum($total_weight) ); ?></td>
                                        <?php } ?>
                                        <?php if(in_array('total_weight', $listing_columns)){?>
                                            <td><?= round_decimels_digits( array_sum($total_weight_amount) ); ?></td>
                                        <?php } ?>
                                    <?php } ?>

                                    <?php if(in_array('image', $listing_columns)){?>
                                        <td></td>
                                    <?php } ?>
                                    <?php if(in_array('action', $listing_columns)){?>
                                        <td></td>
                                    <?php } ?>
                                </tr>
                            </tbody>
                        </table>    
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>