<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'edit_item'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/items'); ?>"><?= print_lang($app_lang,'items'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'edit_item'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="ibox-title">
        <h5><?= print_lang($app_lang,'fields_with'); ?> <strong class="text-danger">*</strong> <?= print_lang($app_lang,'are_mandatory'); ?></h5>
    </div>
    <div class="ibox-content">
        <!-- spinner -->
        <div class="sk-spinner sk-spinner-three-bounce">
            <div class="sk-bounce1"></div>
            <div class="sk-bounce2"></div>
            <div class="sk-bounce3"></div>
        </div>
        <!-- spinner -->
        <div class="row">
            <div class="col-sm-12 b-r">
                <form role="form" id="items-form" action="<?php echo url('/items/update').'/'.$editing_data['uid']; ?>" enctype="multipart/form-data">

                    <div class="row extra-mar-botm">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'item_id'); ?> <strong class="text-danger">*</strong></label>
                                <input type="text" class="form-control" name="item_id" value="<?= $editing_data['item_id']; ?>" placeholder="<?= print_lang($app_lang,'item_id'); ?>">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'name'); ?> <strong class="text-danger">*</strong></label>
                                <input type="text" class="form-control" name="name" value="<?= $editing_data['name']; ?>" placeholder="<?= print_lang($app_lang,'name'); ?>">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'item_type'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="type">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'select_type'); ?> --</option>
                                    <option value="sales" <?php if($editing_data['type'] == 'sales'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'sales'); ?></option>
                                    <option value="raw" <?php if($editing_data['type'] == 'raw'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'raw'); ?></option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'item_category'); ?></label>
                                <select class="form-control chosen-select" name="category">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'select_category'); ?> --</option>
                                    <?php foreach($product_categories as $row){ ?>
                                        <option value="<?= $row['uid']; ?>" <?php if($editing_data['category'] == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="row extra-mar-botm">
                        <div class="col-md-4">
                            <label><?= print_lang($app_lang,'unit_1'); ?> <strong class="text-danger">*</strong></label>
                            <div class="row">
                                <div class="col-md-7" style="padding-right: 5px;">
                                    <div class="form-group">
                                        <select class="form-control chosen-select" name="purchase_unit">
                                            <option disabled="" selected="">-- <?= print_lang($app_lang,'select_unit'); ?> --</option>
                                            <?php foreach($units as $row){ ?>
                                                <option value="<?= $row['uid']; ?>" <?php if($editing_data['purchase_unit'] == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?> (<?= $row['short']; ?>)</option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-5" style="padding-left: 0px;">
                                    <div class="form-group">
                                        <input type="number" class="form-control pointer-none" name="purchase_unit_equalance" value="<?= $editing_data['purchase_unit_equalance']; ?>" placeholder="<?= print_lang($app_lang,'unit_equalance'); ?>">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <label><?= print_lang($app_lang,'unit_2'); ?></label>
                            <div class="row">
                                <div class="col-md-7" style="padding-right: 5px;">
                                    <div class="form-group">
                                        <select class="form-control chosen-select" name="sale_unit">
                                            <option disabled="" selected="">-- <?= print_lang($app_lang,'select_unit'); ?> --</option>
                                            <?php foreach($units as $row){ ?>
                                                <option value="<?= $row['uid']; ?>" <?php if($editing_data['sale_unit'] != $editing_data['purchase_unit'] && $editing_data['sale_unit'] == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?> (<?= $row['short']; ?>)</option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-5" style="padding-left: 0px;">
                                    <div class="form-group">
                                        <input type="number" class="form-control" name="sale_unit_equalance" value="<?= $editing_data['sale_unit_equalance']; ?>" placeholder="<?= print_lang($app_lang,'unit_equalance'); ?>">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <label><?= print_lang($app_lang,'unit_3'); ?></label>
                            <div class="row">
                                <div class="col-md-7" style="padding-right: 5px;">
                                    <div class="form-group">
                                        <select class="form-control chosen-select" name="production_unit">
                                            <option disabled="" selected="">-- <?= print_lang($app_lang,'select_unit'); ?> --</option>
                                            <?php foreach($units as $row){ ?>
                                                <option value="<?= $row['uid']; ?>" <?php if($editing_data['production_unit'] != $editing_data['sale_unit'] && $editing_data['production_unit'] != $editing_data['purchase_unit'] && $editing_data['production_unit'] == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?> (<?= $row['short']; ?>)</option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-5" style="padding-left: 0px;">
                                    <div class="form-group">
                                        <input type="number" class="form-control" name="production_unit_equalance" value="<?= $editing_data['production_unit_equalance']; ?>" placeholder="<?= print_lang($app_lang,'unit_equalance'); ?>">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <?php $item_settings = get_item_settings(); ?>
                    <?php if($item_settings['item_measurements'] == 'get'){ ?>
                        <div class="row extra-mar-botm">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'height'); ?> <strong class="text-danger">*</strong></label>
                                    <input type="number" class="form-control" name="height" value="<?= $editing_data['height']; ?>" placeholder="<?= print_lang($app_lang,'height'); ?>">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'width'); ?> <strong class="text-danger">*</strong></label>
                                    <input type="number" class="form-control" name="width" value="<?= $editing_data['width']; ?>" placeholder="<?= print_lang($app_lang,'width'); ?>">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'length'); ?></label>
                                    <input type="number" class="form-control" name="length" value="<?= $editing_data['length']; ?>" placeholder="<?= print_lang($app_lang,'length'); ?>">
                                </div>
                            </div>
                        </div>
                    <?php } ?>

                    <?php if($item_settings['cbm'] == 'enable'){ ?>
                        <div class="row extra-mar-botm">
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'item_cbm_width'); ?></label>
                                    <input type="number" class="form-control" name="item_width" placeholder="<?= print_lang($app_lang,'item_cbm_width'); ?>" value="<?= $editing_data['item_width']; ?>">
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'item_cbm_length'); ?></label>
                                    <input type="number" class="form-control" name="item_length" placeholder="<?= print_lang($app_lang,'item_cbm_length'); ?>" value="<?= $editing_data['item_length']; ?>">
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'item_cbm_height'); ?></label>
                                    <input type="number" class="form-control" name="item_height" placeholder="<?= print_lang($app_lang,'item_cbm_height'); ?>" value="<?= $editing_data['item_height']; ?>">
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'item_cbm'); ?></label>
                                    <input type="number" class="form-control" name="cbm" placeholder="<?= print_lang($app_lang,'item_cbm'); ?>" value="<?= $editing_data['cbm']; ?>" readonly>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'item_weight'); ?></label>
                                    <input type="number" class="form-control" name="weight" value="<?= $editing_data['weight']; ?>" placeholder="<?= print_lang($app_lang,'item_weight'); ?>">
                                </div>
                            </div>
                        </div>
                    <?php } ?>

                    <?php 
                    if($item_settings['bundle_toop'] == 'enable'){ ?>
                    <div class="row extra-mar-botm">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'item_bundle'); ?></label>
                                <input type="number" class="form-control" name="bundle" value="<?= $editing_data['bundle']; ?>" placeholder="<?= print_lang($app_lang,'item_bundle'); ?>">
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'item_toop'); ?></label>
                                <input type="number" class="form-control" name="toop" value="<?= $editing_data['toop']; ?>" placeholder="<?= print_lang($app_lang,'item_toop'); ?>">
                            </div>
                        </div>
                    </div>
                    <?php } ?>
                    <div class="row extra-mar-botm">
                        <div class="col-md-5">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'opening_stock_warehouse'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select opening-stock-warehouse">
                                    <option disabled="" selected="" value="" data-opt-type="default">-- <?= print_lang($app_lang,'select_warehouse'); ?> --</option>
                                    <?php foreach($warehouse as $row){ ?>
                                        <option <?php if($row['type'] != $editing_data['type']){ echo 'class="display-none"'; } ?> value="<?= $row['uid']; ?>" data-opt-type="<?= $row['type']; ?>"><?= $row['name']; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-5">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'opening_stock'); ?> <strong class="text-danger">*</strong></label>
                                <input type="number" class="form-control opening-stock-qty" placeholder="<?= print_lang($app_lang,'opening_stock'); ?>">
                            </div>
                        </div>

                        <div class="col-md-2" style="margin-top: 23px;">
                            <a class="btn btn-primary opening-stock-trigger-elm" href="javascript:void(0);"><i class="fa fa-plus" style="margin: 0px 8px;"></i><?= print_lang($app_lang,'add_to_list'); ?></a>
                        </div>

                    </div>

                    <div class="opening-stock-rows">
                        <?php
                            $warehouses = json_decode($editing_data['warehouses'],true);
                            $opening_stocks = json_decode($editing_data['opening_stocks'],true);
                            if(!empty($warehouses)){
                                foreach($warehouses as $key => $val){ $warehouse_data = fetch_table_where('warehouse','uid',$val,true); ?>
                                    <div class="row extra-mar-botm opening-stock-multiple-row">
                                        <div class="col-md-5">
                                            <input type="hidden" class="form-control" name="warehouse[]" value="<?= $val; ?>">
                                            <input type="text" class="form-control" readonly value="<?= isset($warehouse_data['name']) ? $warehouse_data['name'] : null; ?>">
                                        </div>

                                        <div class="col-md-5">
                                            <input type="number" class="form-control" name="opening_stock[]" value="<?= isset($opening_stocks[$key]) ? $opening_stocks[$key] : null; ?>">
                                        </div>

                                        <div class="col-md-2">
                                            <a class="btn btn-danger opening-stock-del-elm" href="javascript:void(0);"><i class="fa fa-trash" style="margin: 0px 8px;"></i></a>
                                        </div>
                                    </div>
                        <?php } } ?>
                    </div>

                    <div class="row extra-mar-botm">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'item_batch'); ?> </label>
                                <input type="text" class="form-control" name="batch" value="<?= $editing_data['batch']; ?>" placeholder="<?= print_lang($app_lang,'item_batch'); ?>">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'currency'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="currency">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'select_currency'); ?> --</option>
                                    <?php foreach($currencies as $row){ ?>
                                        <option value="<?= $row['uid']; ?>" <?php if($editing_data['currency'] == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'cost'); ?> <strong class="text-danger">*</strong></label>
                                <input type="text" class="form-control" name="cost" value="<?= $editing_data['cost']; ?>" placeholder="<?= print_lang($app_lang,'cost'); ?>">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group <?php if($editing_data['type'] == 'raw'){ echo 'display-none'; } ?>">
                                <label><?= print_lang($app_lang,'sale_price'); ?> <strong class="text-danger">*</strong></label>
                                <input type="text" class="form-control" name="sale_price" value="<?= $editing_data['sale_price']; ?>" placeholder="<?= print_lang($app_lang,'sale_price'); ?>">
                            </div>
                        </div>
                    </div>

                    <div class="row extra-mar-botm">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'reorder_qty'); ?> <strong class="text-danger">*</strong></label>
                                <input type="text" class="form-control" name="reorder_qty" value="<?= $editing_data['reorder_qty']; ?>" placeholder="<?= print_lang($app_lang,'reorder_qty'); ?>">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <?php
                                $mfg_date = display_true_date($editing_data['mfg_date']);
                            ?>
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'mfg_date'); ?></label>
                                <?php if($branch_calander == 'persian'){ ?>
                                    <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($mfg_date); ?>" name="mfg_date" placeholder="<?= print_lang($app_lang,'date'); ?>" readonly="" style="background: #fff;">
                                <?php }else{ ?>
                                    <input type="date" class="form-control" name="mfg_date" value="<?php if(!empty($mfg_date)){echo date("Y-m-d",strtotime(true_date_for_inputs($mfg_date)));} ?>">
                                <?php } ?>
                            </div>
                        </div>

                        <div class="col-md-3">
                            <?php
                                $expiry_date = display_true_date($editing_data['expiry_date']);
                            ?>
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'expiry_date'); ?></label>
                                <?php if($branch_calander == 'persian'){ ?>
                                    <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($expiry_date); ?>" name="expiry_date" placeholder="<?= print_lang($app_lang,'date'); ?>" readonly="" style="background: #fff;">
                                <?php }else{ ?>
                                    <input type="date" class="form-control" name="expiry_date" value="<?php if(!empty($expiry_date)){echo date("Y-m-d",strtotime(true_date_for_inputs($expiry_date)));} ?>">
                                <?php } ?>
                            </div>
                        </div>

                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'expiry_alert'); ?></label>
                                <input type="text" class="form-control" name="expiry_alert" value="<?= $editing_data['expiry_alert']; ?>" placeholder="<?= print_lang($app_lang,'expiry_alert'); ?>">
                            </div>
                        </div>

                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'item_country'); ?></label>
                                <input type="text" class="form-control" name="country" value="<?= $editing_data['country']; ?>" placeholder="<?= print_lang($app_lang,'item_country'); ?>">
                            </div>
                        </div>

                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'item_company'); ?></label>
                                <input type="text" class="form-control" name="company" value="<?= $editing_data['company']; ?>" placeholder="<?= print_lang($app_lang,'item_company'); ?>">
                            </div>
                        </div>

                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'item_details'); ?></label>
                                <input type="text" class="form-control" name="details" value="<?= $editing_data['details']; ?>" placeholder="<?= print_lang($app_lang,'item_details'); ?>">
                            </div>
                        </div>

                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'item_image'); ?></label>
                                <input type="file" class="form-control" name="item_image">
                            </div>
                        </div>
                    </div>

                    <div class="row extra-mar-botm">
                        <div class="col-md-12 text-right">
                            <a class="btn btn-w-m btn-outline btn-danger url-elem" href="<?php echo url('/items'); ?>"><?= print_lang($app_lang,'cancel'); ?></a>
                            <button class="btn btn-w-m btn-primary" type="submit"><?= print_lang($app_lang,'update'); ?></button>
                        </div>
                    </div>

                </form>
            </div>
        </div>
    </div>

</div>