
<?php if($live_search_data == 'no'){ ?>
    <style type="text/css">
        .html5buttons{display: none !important;}
        .dataTables_info{display: none !important;}
        .dataTables_filter{display: none !important;}
        .dataTables_paginate.paging_simple_numbers{display: none !important;}
    </style>
<style>
    .pagination {
        margin: 0 !important;
    }
</style>
<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-8">
        <h2><?= print_lang($app_lang,'journal'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'journal'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-4">
        <div class="title-action">
            <?php if(check_user_access('add_journal') === TRUE){ ?>
                <a href="<?php echo url('/journal/add'); ?>" class="btn btn-primary btn-sm custom-font-btn"><i class="fa fa-plus"></i>&nbsp; <?= print_lang($app_lang,'add_new_journal'); ?></a>
            <?php } ?>
        </div>
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'journal_listing'); ?></h2>

                    <form id="journal-search-form" action="<?= url('/journal'); ?>">
                    <div class="row">
                        <div class="col-md-9">
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <select class="form-control chosen-select" name="account">
                                            <option value="" selected="">-- <?= print_lang($app_lang,'account'); ?> --</option>
                                            <?php foreach($accounts as $row){ if($row['type'] == 'root'){continue;} ?>
                                                <option value="<?= $row['uid']; ?>" <?php if($search_account == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>

                                <div class="col-md-4">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= $search_from; ?>" name="from" placeholder="<?= print_lang($app_lang,'from'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="from" value="<?= $search_from; ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= $search_to; ?>" name="to" placeholder="<?= print_lang($app_lang,'to'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="to" value="<?= $search_to; ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-2 text-right">
                            <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                        </div>
                        <div class="col-md-1">
                            <a target="_blank" href="<?= url('/journal/print').'?'.'&from='.$search_from.'&to='.$search_to.'&account='.$search_account.''; ?>" class="btn btn-outline btn-primary dim"><i class="fa fa-print"></i></a>
                        </div>
                    </div>
                    </form>
                    <hr>

                    <div class="table-responsive">
                        <!-- custom live search -->
                        <div class="custom-search-input" style="position: relative; top: 30px; z-index: 1;">
                            <input style="width: 200px; height: 30px;" type="text" title="Search" placeholder="Search" name="_hp_live_search" value="<?= $_search; ?>" class="form-control" data-params="from,to" data-action="<?= url('/journal'); ?>">
                        </div>
                        <!-- custom live search -->
                        <table class="table table-bordered table-hover dataTables-custom">
                            <thead>
                                <tr>
                                    <td style="border: none !important;"></td>
                                    <td style="border: none !important;"></td>
                                    <td style="border: none !important;"></td>
                                    <td style="border: none !important; text-align: right; font-size: 18px;"><strong><?= print_lang($app_lang,'debit_part'); ?></strong></td>
                                    <td style="border: none !important;"></td>
                                    <td style="border: none !important; <?php if($app_direction == 'ltr'){echo 'border-right: 1px solid #e2e0e0;';}?>"></td>
                                    <!-- Credit -->
                                    <td style="border: none !important; <?php if($app_direction == 'rtl'){echo 'border-right: 1px solid #e2e0e0;';}?>"></td>
                                    <td style="border: none !important; text-align: right; font-size: 18px;"><strong style="position: relative;left: 50px;"><?= print_lang($app_lang,'credit_part'); ?></strong></td>
                                    <td style="border: none !important;"></td>
                                    <td style="border: none !important;"></td>
                                </tr>
                                <tr>
                                    <th class="text-center">#</th>
                                    <th class="text-center"><?= print_lang($app_lang,'jv_num_thead'); ?></th>
                                    <th class="text-center" style="width: 70px; max-width: 70px;"><?= print_lang($app_lang,'date'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'dr_account'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'dr_amount'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'dr_narration'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'cr_account'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'cr_amount'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'cr_narration'); ?></th>
                                    <th class="text-center" style="min-width:120px;"><?= print_lang($app_lang,'action'); ?></th>
                                </tr>
                            </thead>
                            <tbody id="page-records-body">
<?php } ?>
                                <?php 
                                    $i = $records['from'];
                                    $total_receiving_amount = array();
                                    $total_payment_amount = array();
                                    foreach($pageData as $row){ ?>
                                    <tr class="text-center">
                                        <td><?= $i++; ?></td>
                                        <td><?= print_lang($app_lang,'jv_num_td').''.$row['serial_id']; ?></td>
                                        <td><?= display_true_date($row['journal_date']); ?></td>
                                        <td><?= array_key_exists($row['receiving_account'], $accounts) ? $accounts[$row['receiving_account']]['name'] : NULL; ?></td>
                                        <td><?= array_key_exists($row['receiving_currency'], $currencies) ? $currencies[$row['receiving_currency']]['symbol'] : NULL; ?><?= amount_number_format($row['receiving_amount']); $total_receiving_amount[] = $row['receiving_amount']; ?></td>
                                        <td><?= $row['receiving_narration']; ?></td>
                                        <td><?= array_key_exists($row['payment_account'], $accounts) ? $accounts[$row['payment_account']]['name'] : NULL; ?></td>
                                        <td><?= array_key_exists($row['payment_currency'], $currencies) ? $currencies[$row['payment_currency']]['symbol'] : NULL; ?><?= amount_number_format($row['payment_amount']); $total_payment_amount[] = $row['payment_amount']; ?></td>
                                        <td><?= $row['payment_narration']; ?></td>
                                        <td>
                                            <?php if($row['main_approval'] == 'approved'){?>
                                                <?php if(check_user_access('view_journal') === TRUE){ ?>
                                                    <a href="<?= url('/journal/invoice').'/'.$row['uid']; ?>" target="_blank" class="btn btn-xs btn-outline btn-warning url-elem"><i class="fa fa-external-link">&nbsp; </i><?= print_lang($app_lang,'invoice'); ?></a>
                                                <?php } ?>
                                                <?php if(check_user_access('edit_journal') === TRUE){ ?>
                                                    <a href="<?= url('/journal/edit').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-primary url-elem"><i class="fa fa-pencil">&nbsp; </i><?= print_lang($app_lang,'edit'); ?></a>
                                                <?php } ?>
                                                <?php if(check_user_access('delete_journal') === TRUE){ ?>
                                                    <a href="<?= url('/journal/delete').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-danger delete-btn-trigger" data-msg="You will not be able to revert this" data-mood="Delete"><i class="fa fa-trash"></i>&nbsp; <?= print_lang($app_lang,'delete'); ?></a>
                                                <?php } ?>
                                            <?php }else{ ?>
                                                <a href="javascript:void(0);" class="btn btn-xs btn-outline btn-warning" data-msg="You will not be able to revert this" data-mood="Delete"><i class="fa fa-eye"></i>&nbsp; <?= print_lang($app_lang,'pending'); ?></a>
                                            <?php } ?>
                                        </td>
                                    </tr>
                                <?php } ?>
                                    <tr class="text-center">
                                        <td><?= $i++; ?></td>
                                        <td></td>
                                        <td><?= display_true_date(date('Y-m-d')); ?></td>
                                        <td><?= print_lang($app_lang,'total'); ?></td>
                                        <td><?= amount_number_format(array_sum($total_receiving_amount)); ?> </td>
                                        <td></td>
                                        <td></td>
                                        <td><?= amount_number_format(array_sum($total_payment_amount)); ?> </td>
                                        <td></td>
                                        <td></td>
                                    </tr>
<?php if($live_search_data == 'no'){ ?>
                            </tbody>
                        </table>    
                    </div>

                    <div class="pagination-wrap">
                        <div class="row">
                            <div class="col-md-6" id="pagination-stats">
                                <span class="records-stats">Showing <?= (float)$records['from']; ?> - <?= (float)$records['to']; ?> of <?= $records['total']; ?></span>
                            </div>
                            <div class="col-md-6 text-right" id="pagination-pages">
                                <?= $pagination; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php } ?>