<style type="text/css">
    .tile-stats {
      box-shadow: 0 0 20px rgba(0,0,0,0.11);
      position: relative;
      display: block;
      background: #303641;
      padding: 20px;
      margin-bottom: 10px;
      overflow: hidden;
      -webkit-border-radius: 5px;
      -webkit-background-clip: padding-box;
      -moz-border-radius: 5px;
      -moz-background-clip: padding;
      border-radius: 5px;
      background-clip: padding-box;
      -moz-transition: all 300ms ease-in-out;
      -o-transition: all 300ms ease-in-out;
      -webkit-transition: all 300ms ease-in-out;
      transition: all 300ms ease-in-out;
    }
    .tile-stats:hover {
      background: #252a32;
    }
    .tile-stats .icon {
      color: rgba(0, 0, 0, 0.1);
      position: absolute;
      right: 5px;
      bottom: 25px;
      z-index: 1;
    }
    .tile-stats .icon i {
      font-size: 100px;
      line-height: 0;
      margin: 0;
      padding: 0;
      vertical-align: bottom;
    }
    .tile-stats .icon i:before {
      margin: 0;
      padding: 0;
      line-height: 0;
    }
    .tile-stats .num,
    .tile-stats h3,
    .tile-stats p {
      position: relative;
      color: #ffffff;
      z-index: 5;
      margin: 0;
      padding: 0;
    }
    .tile-stats .num {
      font-size: 38px;
      font-weight: bold;
    }
    .tile-stats h3 {
      font-size: 18px;
      margin-top: 5px;
    }
    .tile-stats p {
      font-size: 11px;
      margin-top: 5px;
    }
    .tile-stats.tile-gray {
      background: #f5f5f5;
    }
    .tile-stats.tile-gray:hover {
      background: #e8e8e8;
    }
    .tile-stats.tile-gray .icon {
      color: rgba(0, 0, 0, 0.1);
    }
    .tile-stats.tile-gray .num,
    .tile-stats.tile-gray h3,
    .tile-stats.tile-gray p {
      color: #8f8f8f;
    }
    .language_input_phrase{font-size: 12px !important;}
</style>
<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'edit_language_phrase'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/language'); ?>"><?= print_lang($app_lang,'language'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'edit_language_phrase'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="ibox-title">
        <!-- <h5>Fields with <strong class="text-danger">*</strong> are mandatory</h5> -->
    </div>
    <div class="ibox-content">
        <!-- spinner -->
        <div class="sk-spinner sk-spinner-three-bounce">
            <div class="sk-bounce1"></div>
            <div class="sk-bounce2"></div>
            <div class="sk-bounce3"></div>
        </div>
        <!-- spinner -->
        <div class="row">
            <div class="col-sm-12 b-r">
                <form role="form" id="language-phrase-form" action="<?php echo url('/language/update-phrase').'/'.$editing_data['uid']; ?>">
                    <div class="row extra-mar-botm">
                        <?php
                        $language_content = json_decode($editing_data['details'],'uid');
                        ?>
                        <?php foreach($app_default_language as $key => $value){ ?>
                            <div class="col-md-3">
                                <div class="tile-stats tile-gray">
                                    <div class="icon"><i class="fa fa-square"></i></div>                               
                                    <h5 style="font-weight: 900 !important;"><?= $key; ?></h5>
                                    <p>
                                        <input type="text" name="<?= $key; ?>" value="<?= print_lang($language_content,$key); ?>" class="form-control language_input_phrase" placeholder="linguistic Content">
                                    </p>
                                </div>
                            </div>
                        <?php } ?>
                    </div>

                    <div class="row extra-mar-botm">
                        <div class="col-md-12 text-right">
                            <a class="btn btn-w-m btn-outline btn-danger url-elem" href="<?php echo url('/language'); ?>"><?= print_lang($app_lang,'cancel'); ?></a>
                            <button class="btn btn-w-m btn-primary" type="submit"><?= print_lang($app_lang,'update'); ?></button>
                        </div>
                    </div>

                </form>
            </div>
        </div>
    </div>

</div>