<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-8">
        <h2><?= print_lang($app_lang,'leaves'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'leaves'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-4">
        <div class="title-action">
            <?php if(check_user_access('add_batch') === TRUE){ ?>
                <a href="<?php echo url('/leaves/add'); ?>" class="btn btn-primary btn-sm custom-font-btn"><i class="fa fa-plus"></i>&nbsp; <?= print_lang($app_lang,'add_new_leave'); ?></a>
            <?php } ?>
        </div>
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'leaves_listing'); ?></h2>
                    
                    <form id="leaves-search-form" action="<?= url('/leaves'); ?>">
                    <div class="row">
                        <div class="col-md-9">
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <select class="form-control chosen-select" name="currency">
                                            <option value="" selected="">-- <?= print_lang($app_lang,'currency'); ?> --</option>
                                            <?php foreach($currencies as $row){ ?>
                                                <option value="<?= $row['uid']; ?>" <?php if($search_currency == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <select class="form-control chosen-select" name="user">
                                            <option value="" selected="">-- <?= print_lang($app_lang,'user'); ?> --</option>
                                            <?php foreach($users as $row){ ?>
                                                <option value="<?= $row['uid']; ?>" <?php if($search_user == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <input type="date" class="form-control" name="from" value="<?= $search_from; ?>">
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <input type="date" class="form-control" name="to" value="<?= $search_to; ?>">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3 text-right">
                            <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                            <a href="#" data-date="<?= date('Y-m-d'); ?>" class="today-date-form-trigger btn btn-primary custom-font-btn-search"><?= print_lang($app_lang,'today'); ?></a>
                        </div>
                    </div>
                    </form>

                    <hr>

                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center"><?= print_lang($app_lang,'sr_#'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'date'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'employee'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'reason'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'expense'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'outgoing_time'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'return_time'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'comments'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'attachment'); ?></th>
                                    <th class="text-center" style="min-width:120px;"><?= print_lang($app_lang,'action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $i = 1;
                                $total_amount = array();

                                foreach($pageData as $row){
                                    
                                    $row_currency = array_key_exists($row['currency'],$currencies) ? $currencies[$row['currency']]['symbol'] : NULL;

                                    $image_path = '/uploads/leaves/'.$row['attachment'];
                                    if(is_file(base_path().$image_path))
                                    {
                                        $image_html = '<a class="btn btn-primary btn-xs" target="_blank" href="'.url('/').$image_path.'">'.print_lang($app_lang,'preview').'</a>'; // data-gallery=""
                                    }
                                    else
                                    {
                                        $image_html = '<span class="label label-info">'.print_lang($app_lang,'no_image').'</span>';
                                    }
                                ?>
                                    <tr class="text-center leave-row-<?= $row['uid']; ?>">
                                        <td><?= $i++; ?></td>
                                        <td><?= $row['l_date']; ?></td>
                                        <td><?= array_key_exists($row['user'],$users) ? $users[$row['user']]['name'] : NULL; ?></td>
                                        <td><?= $row['reason']; ?></td>
                                        <td><?= $row_currency; ?><?= amount_number_format($row['expense']); ?><?php $total_amount[] = (float)$row['expense']; ?></td>
                                        <td><?= $row['out_time']; ?></td>
                                        <td class="row-in-time" data-in-time="<?= $row['in_time']; ?>"><?= $row['in_time']; ?></td>
                                        <td class="row-comments" data-comments="<?= $row['comments']; ?>"><?= $row['comments']; ?></td>
                                        <td class="row-attachment"><?= $image_html; ?></td>
                                        <td>
                                            <?php if(check_user_access('edit_batch') === TRUE){ ?>
                                                <a href="javascript:void(0);" data-uid="<?= $row['uid']; ?>" class="btn btn-xs btn-outline btn-warning leave-return-trigger"><i class="fa fa-pencil">&nbsp; </i><?= print_lang($app_lang,'return'); ?></a>
                                            <?php } ?>
                                            <?php if(check_user_access('edit_batch') === TRUE){ ?>
                                                <a href="<?= url('/leaves/edit').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-primary url-elem"><i class="fa fa-pencil">&nbsp; </i><?= print_lang($app_lang,'edit'); ?></a>
                                            <?php } ?>
                                            <?php if(check_user_access('delete_batch') === TRUE){ ?>
                                                <a href="<?= url('/leaves/delete').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-danger delete-btn-trigger" data-msg="You will not be able to revert this" data-mood="Delete"><i class="fa fa-trash"></i>&nbsp; <?= print_lang($app_lang,'delete'); ?></a>
                                            <?php } ?>
                                        </td>
                                    </tr>
                                <?php } ?>

                                <tr class="text-center">
                                    <td><?= $i++; ?></td>
                                    <td><?= print_lang($app_lang,'total'); ?></td>
                                    <td>---</td>
                                    <td>---</td>
                                    <td><?= amount_number_format( array_sum($total_amount) ); ?></td>
                                    <td>---</td>
                                    <td>---</td>
                                    <td>---</td>
                                    <td>---</td>
                                </tr>

                            </tbody>
                        </table>    
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>


<div class="modal inmodal" id="leave-return-modal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content animated flipInX">
            <form id="leave-return-form" action="<?= url('/leaves/return-time'); ?>">
                <input type="hidden" id="leave-return-row-id" name="uid" value="">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
                <h4 class="modal-title"><?= print_lang($app_lang,'leave_return_modal_title'); ?></h4>
                <small class="font-bold"><?= print_lang($app_lang,'leave_return_modal_tag_line'); ?></small>
            </div>
            <div class="modal-body bg-white">

                <div class="row">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label><?= print_lang($app_lang,'return_time'); ?> <strong class="text-danger">*</strong></label>
                            <input type="time" class="form-control" name="in_time" style="padding: 0 0 0 5px;">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label><?= print_lang($app_lang,'attachment'); ?></label>
                            <input type="file" class="form-control" name="attachment">
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label><?= print_lang($app_lang,'comments'); ?> <strong class="text-danger">*</strong></label>
                            <input type="text" class="form-control" name="comments" placeholder="<?= print_lang($app_lang,'comments'); ?>">
                        </div>
                    </div>
                </div>

            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-white" data-dismiss="modal"><?= print_lang($app_lang,'cancel'); ?></button>
                <button type="submit" class="btn btn-primary"><?= print_lang($app_lang,'save'); ?></button>
            </div>
            </form>
        </div>
    </div>
</div>