<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'edit_load_delivery'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/load-deliveries'); ?>"><?= print_lang($app_lang,'load_deliveries'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'edit_load_delivery'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="ibox-title">
        <h5><?= print_lang($app_lang,'fields_with'); ?> <strong class="text-danger">*</strong> <?= print_lang($app_lang,'are_mandatory'); ?></h5>
    </div>
    <div class="ibox-content">
        <!-- spinner -->
        <div class="sk-spinner sk-spinner-three-bounce">
            <div class="sk-bounce1"></div>
            <div class="sk-bounce2"></div>
            <div class="sk-bounce3"></div>
        </div>
        <!-- spinner -->
        <div class="row">
            <div class="col-sm-12 b-r">
                <form role="form" id="load-delivery-form" action="<?php echo url('/load-deliveries/update').'/'.$editing_data['uid']; ?>">

                    <div class="row extra-mar-botm">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'currency'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="currency">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'select_currency'); ?> --</option>
                                    <?php foreach($currencies as $row){ ?>
                                        <option value="<?= $row['uid']; ?>" <?php if($editing_data['currency'] == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'purchase_invoice'); ?> <strong class="text-danger">*</strong></label>
                                <!-- <select class="form-control chosen-select" name="purchase"> -->
                                <select name="purchase[]" data-placeholder="<?= print_lang($app_lang,'select_purchase'); ?>" class="chosen-select" multiple tabindex="4">
                                    <!-- <option disabled="" selected="">-- <?= print_lang($app_lang,'select_purchase'); ?> --</option> -->
                                    <?php $purchase_invoices = explode(',',$editing_data['purchase']); ?>
                                    <?php foreach($purchases as $row){ ?>
                                        <option value="<?= $row['uid']; ?>" <?php if(in_array($row['uid'], $purchase_invoices)){ echo 'selected="selected"'; } ?>><?= $row['invoice']; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'account'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="account">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'select_account'); ?> --</option>
                                    <?php foreach($accounts as $row){ ?>
                                        <?php if($row['type'] != 'transit'){ continue; } ?>
                                        <option value="<?= $row['uid']; ?>" <?php if($editing_data['account'] == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'document'); ?></label>
                                <input type="file" class="form-control" name="document">
                            </div>
                        </div>
                    </div>

                    <div class="row extra-mar-botm">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'load_plate'); ?> <strong class="text-danger">*</strong></label>
                                <input type="text" class="form-control" name="load_plate" value="<?= $editing_data['load_plate']; ?>" placeholder="<?= print_lang($app_lang,'load_plate'); ?>">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'load_expenses'); ?> <strong class="text-danger">*</strong></label>
                                <input type="text" class="form-control in-calculation" name="load_expenses" value="<?= $editing_data['load_expenses']; ?>" placeholder="<?= print_lang($app_lang,'load_expenses'); ?>">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'charges'); ?> <strong class="text-danger">*</strong></label>
                                <input type="text" class="form-control in-calculation" name="charges" value="<?= $editing_data['charges']; ?>" placeholder="<?= print_lang($app_lang,'charges'); ?>">
                            </div>
                        </div>
                    </div>

                    <div class="row extra-mar-botm">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'total'); ?></label>
                                <input type="text" class="form-control" name="total" value="<?= $editing_data['total']; ?>" placeholder="<?= print_lang($app_lang,'total'); ?>">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'cash_paid'); ?></label>
                                <input type="text" class="form-control in-calculation" name="cash_paid" value="<?= $editing_data['cash_paid']; ?>" placeholder="<?= print_lang($app_lang,'cash_paid'); ?>">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'cash_paid_account'); ?></label>
                                <select class="form-control chosen-select" name="cash_paid_account">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'select_account'); ?> --</option>
                                    <?php foreach($accounts as $row){ ?>
                                        <?php if($row['type'] == 'transit' OR $row['type'] == 'supplier' OR $row['type'] == 'bank' OR $row['type'] == 'cashbook'){ ?>
                                            <option value="<?= $row['uid']; ?>" <?php if($editing_data['cash_paid_account'] == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                        <?php } ?>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'pending'); ?></label>
                                <input type="text" class="form-control" name="pending" value="<?= $editing_data['pending']; ?>" placeholder="<?= print_lang($app_lang,'pending'); ?>">
                            </div>
                        </div>
                    </div>

                    <div class="row extra-mar-botm">
                        <div class="col-md-12 text-right">
                            <a class="btn btn-w-m btn-outline btn-danger url-elem" href="<?php echo url('/load-deliveries'); ?>"><?= print_lang($app_lang,'cancel'); ?></a>
                            <button class="btn btn-w-m btn-primary" type="submit"><?= print_lang($app_lang,'update'); ?></button>
                        </div>
                    </div>

                </form>
            </div>
        </div>
    </div>

</div>