<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-8">
        <h2><?= print_lang($app_lang,'load_deliveries'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'load_deliveries'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-4">
        <div class="title-action">
            <?php if(check_user_access('add_shor_load_delivery') === TRUE){ ?>
                <a href="<?php echo url('/load-deliveries/add'); ?>" class="btn btn-primary btn-sm custom-font-btn"><i class="fa fa-plus"></i>&nbsp; <?= print_lang($app_lang,'add_new_load_delivery'); ?></a>
            <?php } ?>
        </div>
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'load_deliveries_listing'); ?></h2>
                    
                    <form id="load-deliveries-search-form" action="<?= url('/load-deliveries'); ?>">
                    <div class="row">
                        <div class="col-md-9">
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <select class="form-control chosen-select" name="currency">
                                            <option value="" selected="">-- <?= print_lang($app_lang,'currency'); ?> --</option>
                                            <?php foreach($currencies as $row){ ?>
                                                <option value="<?= $row['uid']; ?>" <?php if($search_currency == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <select class="form-control chosen-select" name="account">
                                            <option value="" selected="">-- <?= print_lang($app_lang,'account'); ?> --</option>
                                            <?php foreach($accounts as $row){ ?>
                                                <?php if($row['type'] != 'transit'){ continue; } ?>
                                                <option value="<?= $row['uid']; ?>" <?php if($search_account == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($search_from); ?>" name="from" placeholder="<?= print_lang($app_lang,'from'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="from" value="<?= true_date_for_inputs($search_from); ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($search_to); ?>" name="to" placeholder="<?= print_lang($app_lang,'to'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="to" value="<?= true_date_for_inputs($search_to); ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3 text-right">
                            <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                            <a href="#" data-date="<?= display_true_date(date('Y-m-d')); ?>" class="today-date-form-trigger btn btn-primary custom-font-btn-search"><?= print_lang($app_lang,'today'); ?></a>
                        </div>
                    </div>
                    </form>

                    <hr>

                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center"><?= print_lang($app_lang,'sr_#'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'load_plate'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'account'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'load_expenses'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'charges'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'total'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'cash_paid'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'pending'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'document'); ?></th>
                                    <th class="text-center" style="min-width:120px;"><?= print_lang($app_lang,'action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $i = 1;
                                $total_load_expenes = array();
                                $total_charges = array();
                                $total_total = array();
                                $total_cash_paid = array();
                                $total_pending = array();

                                foreach($pageData as $row){

                                    $row_currency = array_key_exists($row['currency'],$currencies) ? $currencies[$row['currency']]['symbol'] : NULL;

                                    $image_path = '/uploads/load-delivery/'.$row['document'];
                                    if(is_file(base_path().$image_path))
                                    {
                                        $image_html = '<a class="btn btn-primary btn-xs" target="_blank" href="'.url('/').$image_path.'">'.print_lang($app_lang,'preview').'</a>'; // data-gallery=""
                                    }
                                    else
                                    {
                                        $image_html = '<span class="label label-info">'.print_lang($app_lang,'no_image').'</span>';
                                    }
                                ?>
                                    <tr class="text-center">
                                        <td><?= $i++; ?></td>
                                        <td><?= $row['load_plate']; ?></td>
                                        <td><?= array_key_exists($row['account'],$accounts) ? $accounts[$row['account']]['name'] : NULL; ?></td>
                                        <td><?= $row_currency; ?><?= amount_number_format((float)$row['load_expenses']); $total_load_expenes[] = (float)$row['load_expenses']; ?></td>
                                        <td><?= $row_currency; ?><?= amount_number_format((float)$row['charges']); $total_charges[] = (float)$row['charges']; ?></td>
                                        <td><?= $row_currency; ?><?= amount_number_format((float)$row['total']); $total_total[] = (float)$row['total']; ?></td>
                                        <td><?= $row_currency; ?><?= amount_number_format((float)$row['cash_paid']); $total_cash_paid[] = (float)$row['cash_paid']; ?></td>
                                        <td><?= $row_currency; ?><?= amount_number_format((float)$row['pending']); $total_pending[] = (float)$row['pending']; ?></td>
                                        <td><?= $image_html; ?></td>
                                        <td>
                                            <?php if(check_user_access('edit_shor_load_delivery') === TRUE){ ?>
                                                <a href="<?= url('/load-deliveries/edit').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-primary url-elem"><i class="fa fa-pencil">&nbsp; </i><?= print_lang($app_lang,'edit'); ?></a>
                                            <?php } ?>
                                            <?php if(check_user_access('delete_shor_load_delivery') === TRUE){ ?>
                                                <a href="<?= url('/load-deliveries/delete').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-danger delete-btn-trigger" data-msg="You will not be able to revert this" data-mood="Delete"><i class="fa fa-trash"></i>&nbsp; <?= print_lang($app_lang,'delete'); ?></a>
                                            <?php } ?>
                                        </td>
                                    </tr>
                                <?php } ?>

                                <tr class="text-center">
                                    <td><?= $i++; ?></td>
                                    <td><?= print_lang($app_lang,'total'); ?></td>
                                    <td>---</td>
                                    <td><?= amount_number_format( array_sum($total_load_expenes) ); ?></td>
                                    <td><?= amount_number_format( array_sum($total_charges) ); ?></td>
                                    <td><?= amount_number_format( array_sum($total_total) ); ?></td>
                                    <td><?= amount_number_format( array_sum($total_cash_paid) ); ?></td>
                                    <td><?= amount_number_format( array_sum($total_pending) ); ?></td>
                                    <td>---</td>
                                </tr>

                            </tbody>
                        </table>    
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>