<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-8">
        <h2><?= print_lang($app_lang,'lot_purchase_avail'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/lot-purchase'); ?>"><?= print_lang($app_lang,'lot_purchase'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'lot_purchase_avail'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-4">
        
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'avail_lot_purchases_listing'); ?></h2>

                    <form id="lot-available-search-form" action="<?= url('/lot-purchase/avail'); ?>">
                    <div class="row">
                        <div class="col-md-2">
                            <div class="form-group">
                                <select class="form-control chosen-select" name="currency">
                                    <option value="" selected="">-- <?= print_lang($app_lang,'currency'); ?> --</option>
                                    <?php foreach($currencies as $row){ ?>
                                        <option value="<?= $row['uid']; ?>" <?php if($search_currency == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <select class="form-control chosen-select" name="supplier">
                                    <option value="" selected="">-- <?= print_lang($app_lang,'supplier'); ?> --</option>
                                    <?php foreach($suppliers as $row){ ?>
                                        <option value="<?= $row['uid']; ?>" <?php if($search_supplier == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <select class="form-control chosen-select" name="type">
                                    <option disabled="">-- <?= print_lang($app_lang,'purchase_type'); ?> --</option>
                                    <option value="" selected=""><?= print_lang($app_lang,'both'); ?></option>
                                    <option value="iran_to_afghanistan" <?php if($search_type == 'iran_to_afghanistan'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'iran_to_afghanistan'); ?></option>
                                    <option value="iran_to_border" <?php if($search_type == 'iran_to_border'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'iran_to_border'); ?></option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <div class="form-group">
                                <?php if($branch_calander == 'persian'){ ?>
                                    <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($search_from); ?>" name="from" placeholder="<?= print_lang($app_lang,'from'); ?>" readonly="" style="background: #fff;">
                                <?php }else{ ?>
                                    <input type="date" class="form-control" name="from" value="<?= true_date_for_inputs($search_from); ?>">
                                <?php } ?>
                            </div>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <?php if($branch_calander == 'persian'){ ?>
                                    <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($search_to); ?>" name="to" placeholder="<?= print_lang($app_lang,'to'); ?>" readonly="" style="background: #fff;">
                                <?php }else{ ?>
                                    <input type="date" class="form-control" name="to" value="<?= true_date_for_inputs($search_to); ?>">
                                <?php } ?>
                            </div>
                        </div>
                        <div class="col-md-2 text-right">
                            <button class="btn btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                            <a href="#" data-date="<?= display_true_date(date('Y-m-d')); ?>" class="today-date-form-trigger btn btn-primary custom-font-btn-search"><?= print_lang($app_lang,'today'); ?></a>
                        </div>
                    </div>
                    </form>
                    <hr>

                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center"><?= print_lang($app_lang,'sr_#'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'email_image'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'purchased_invoice'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'purchased_date'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'supplier'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'fuel_type'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'driver'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'plate_num'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mobile'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'cmr'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'transit'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'expense'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'weight'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'weight_plus'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'weight_minus'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'weight_lose'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'gross_weight'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'cost'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'rent'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'expenses'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'real_cost'); ?></th>
                                    <th class="text-center" style="min-width: 180px;"><?= print_lang($app_lang,'sold_?'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'move_?'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $total_weight = array();
                                $total_weight_plus = array();
                                $total_weight_minus = array();
                                $total_weight_lose = array();
                                $total_gross_weight = array();
                                $total_cost = array();
                                $total_rent = array();
                                $total_expenses = array();
                                $total_real_cost = array();
                                ?>
                                <?php
                                
                                $i = 0;
                                $background_color = '#ffffff';

                                foreach($pageData as $parent_row){

                                    $i = 1;
                                    if($background_color == '#ffffff'){ $background_color = '#eee'; }else{ $background_color = '#ffffff'; }

                                    $image_path = '/uploads/screenshots/'.$parent_row['email_attachment'];
                                    if(is_file(base_path().$image_path))
                                    {
                                        $image_html = '<a class="btn btn-primary btn-xs" data-gallery="" target="_blank" href="'.url('/').$image_path.'">'.print_lang($app_lang,'preview').'</a>';
                                    }
                                    else
                                    {
                                        $image_html = '<span class="label label-info">'.print_lang($app_lang,'no_image').'</span>';
                                    }

                                    if($parent_row['purchase_type'] == 'iran_to_border')
                                    {
                                        $lot_list = json_decode($parent_row['division_list'],true);
                                    }
                                    else
                                    {
                                        $lot_list = json_decode($parent_row['lot_list'],true);
                                    }
                                    foreach($lot_list as $child_row){

                                        // if already sold | skip
                                        if(array_key_exists($child_row['uid'], $lot_sales)){ continue; }
                                        // if already moved | skip
                                        if(array_key_exists($child_row['uid'], $moved_lots)){ continue; }

                                        $weight_plus = isset($child_row['weight_plus']) ? $child_row['weight_plus'] : 0;
                                        $weight_minus = isset($child_row['weight_minus']) ? $child_row['weight_minus'] : 0;
                                        $weight_lose = isset($child_row['weight_lose']) ? $child_row['weight_lose'] : 0;

                                ?>

                                    <tr class="text-center lotitem<?= $child_row['uid']; ?>" style="background: <?= $background_color; ?>;">
                                        <td><?= $i++; ?></td>
                                        <td><?= $image_html; ?></td>
                                        <td><a target="_blank" href="<?= url('/lot-purchase/invoice').'/'.$parent_row['uid']; ?>"><?= $parent_row['receipt']; ?></a></td>
                                        <td><?= display_true_date($parent_row['lot_date']); ?></td>
                                        <td><?= array_key_exists($parent_row['supplier'], $suppliers) ? $suppliers[$parent_row['supplier']]['name'] : NULL; ?></td>
                                        <td><?= isset($child_row['fuel_type']) ? $child_row['fuel_type'] : NULL; ?></td>
                                        <td><?= $child_row['driver']; ?></td>
                                        <td><?= $child_row['plate']; ?></td>
                                        <td><?= $child_row['mobile']; ?></td>
                                        <td><?= $child_row['cmr']; ?></td>
                                        <td><?= array_key_exists($child_row['transit_account'], $transits) ? $transits[$child_row['transit_account']]['name'] : NULL; ?></td>
                                        <td><?= array_key_exists($child_row['expense_account'], $expenses) ? $expenses[$child_row['expense_account']]['name'] : NULL; ?></td>
                                        <td><?= $child_row['weight']; $total_weight[] = $child_row['weight']; ?></td>
                                        
                                        <td><?= $weight_plus; $total_weight_plus[] = $weight_plus; ?></td>
                                        <td><?= $weight_minus; $total_weight_minus[] = $weight_minus; ?></td>
                                        <td><?= $weight_lose; $total_weight_lose[] = $weight_lose; ?></td>

                                        <td><?= round_decimels_digits_3($child_row['gross_weight']); $total_gross_weight[] = $child_row['gross_weight']; ?></td>
                                        <td><?= round_decimels_digits_3($child_row['cost']); $total_cost[] = $child_row['cost']; ?></td>
                                        <td><?= round_decimels_digits_3($child_row['rent']); $total_rent[] = $child_row['rent']; ?></td>
                                        <td><?= round_decimels_digits_3($child_row['expenses']); $total_expenses[] = $child_row['expenses']; ?></td>
                                        <td><?= round_decimels_digits_3($child_row['real_cost']); $total_real_cost[] = $child_row['real_cost']; ?></td>
                                        <td>
                                            <?php if(check_user_access('add_lot_sold') === TRUE){ ?>
                                                <button class="btn btn-xs btn-outline btn-primary lot-item-sold-trigger" data-puid="<?= $parent_row['uid']; ?>" data-cuid="<?= $child_row['uid']; ?>"><i class="fa fa-pencil">&nbsp; </i><?= print_lang($app_lang,'btn_sold_?'); ?></button>
                                                <button class="btn btn-xs btn-outline btn-success lot-invoice-sold-trigger" data-puid="<?= $parent_row['uid']; ?>"><i class="fa fa-edit">&nbsp; </i><?= print_lang($app_lang,'btn_sold_invoice_?'); ?></button>
                                            <?php } ?>
                                        </td>
                                        <td>
                                            <?php if(check_user_access('add_lot_moved') === TRUE){ ?>
                                                <button class="btn btn-xs btn-outline btn-info lot-item-move-trigger" data-weight="<?= $child_row['gross_weight']; ?>" data-puid="<?= $parent_row['uid']; ?>" data-cuid="<?= $child_row['uid']; ?>"><i class="fa fa-trash"></i>&nbsp; <?= print_lang($app_lang,'btn_move_?'); ?></button>
                                            <?php } ?>
                                        </td>
                                    </tr>

                                    <?php } ?>
                                <?php } ?>

                                <tr class="text-center">
                                    <td><?= $i++; ?></td>
                                    <td></td>
                                    <td><?= print_lang($app_lang,'total'); ?></td>
                                    <td><?= display_true_date(date('Y-m-d')); ?></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td><?= round_decimels_digits_3( array_sum($total_weight) ); ?></td>
                                    <td><?= round_decimels_digits_3( array_sum($total_weight_plus) ); ?></td>
                                    <td><?= round_decimels_digits_3( array_sum($total_weight_minus) ); ?></td>
                                    <td><?= round_decimels_digits_3( array_sum($total_weight_lose) ); ?></td>
                                    <td><?= round_decimels_digits_3( array_sum($total_gross_weight) ); ?></td>
                                    <td><?= round_decimels_digits_3( array_sum($total_cost) ); ?></td>
                                    <td><?= round_decimels_digits_3( array_sum($total_rent) ); ?></td>
                                    <td><?= round_decimels_digits_3( array_sum($total_expenses) ); ?></td>
                                    <td><?= round_decimels_digits_3( array_sum($total_real_cost) ); ?></td>
                                    <td></td>
                                    <td></td>
                                </tr>

                            </tbody>
                        </table>    
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>


<?php if(check_user_access('add_lot_sold') === TRUE){ ?>
<div class="modal inmodal" id="lot-sale-modal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content animated flipInX">
            <form id="lot-sale-form" action="<?= url('/lot-purchase/avail/save'); ?>">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
                <h4 class="modal-title"><?= print_lang($app_lang,'lot_sold_title'); ?></h4>
                <small class="font-bold"><?= print_lang($app_lang,'lot_sold_tag_line'); ?></small>
            </div>
            <div class="modal-body bg-white">
                
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label><?= print_lang($app_lang,'currency'); ?> <strong class="text-danger">*</strong></label>
                            <input type="hidden" name="parent_uid" value="">
                            <input type="hidden" name="child_uid" value="">
                            <input type="hidden" name="lot_currency" value="">
                            <input type="hidden" name="lot_currency_usd_equalance" value="">
                            <input type="hidden" name="lot_real_cost" value="">
                            <input type="hidden" name="_sold_discount_amount" value="">
                            <select class="form-control chosen-select" name="_sold_currency">
                                <option disabled="" selected="">-- <?= print_lang($app_lang,'currency'); ?> --</option>
                                <?php foreach($currencies as $row){ ?>
                                    <option value="<?= $row['uid']; ?>" data-usd-equalance="<?= $row['usd_equalance']; ?>"><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                <?php } ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label><?= print_lang($app_lang,'client'); ?> <strong class="text-danger">*</strong></label>
                            <select class="form-control chosen-select" name="_sold_client">
                                <option disabled="" selected="">-- <?= print_lang($app_lang,'client'); ?> --</option>
                                <?php foreach($clients as $row){ ?>
                                    <option value="<?= $row['uid']; ?>"><?= $row['name']; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label><?= print_lang($app_lang,'invoice'); ?></label>
                            <select class="form-control chosen-select" name="_sold_invoice">
                                <option disabled="" selected="">-- <?= print_lang($app_lang,'invoice'); ?> --</option>
                            </select>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label><?= print_lang($app_lang,'weight'); ?></label>
                            <input type="text" class="form-control pointer-none" name="_sold_weight" placeholder="<?= print_lang($app_lang,'weight'); ?>">
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="row">
                            <div class="col-md-7">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'difference'); ?></label>
                                    <select class="form-control chosen-select" name="_sold_difference_type">
                                        <option value="plus" selected=""><?= print_lang($app_lang,'plus'); ?></option>
                                        <option value="minus"><?= print_lang($app_lang,'minus'); ?></option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-5">
                                <div class="form-group">
                                    <label style="opacity: 0; color: transparent;">-</label>
                                    <input type="text" class="form-control" name="_sold_difference" placeholder="<?= print_lang($app_lang,'amount'); ?>">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label><?= print_lang($app_lang,'gross_weight'); ?></label>
                            <input type="text" class="form-control pointer-none" name="_sold_gross_weight" placeholder="<?= print_lang($app_lang,'gross_weight'); ?>">
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label><?= print_lang($app_lang,'mod_lot_sale_popup_input_saqlat'); ?> </label>
                            <input type="text" class="form-control" name="_saqlat" placeholder="<?= print_lang($app_lang,'mod_lot_sale_popup_input_saqlat'); ?>">
                        </div>
                    </div>

                    <div class="col-md-4">
                        <div class="form-group">
                            <label><?= print_lang($app_lang,'mod_lot_sale_popup_input_liters_qty'); ?> </label>
                            <input type="text" class="form-control" name="_litres_qty" placeholder="<?= print_lang($app_lang,'mod_lot_sale_popup_input_liters_qty'); ?>" readonly>
                        </div>
                    </div>

                    <div class="col-md-4">
                        <div class="form-group">
                            <label><?= print_lang($app_lang,'sale_price'); ?> <strong class="text-danger">*</strong></label>
                            <input type="text" class="form-control" name="_sold_sale_price" placeholder="<?= print_lang($app_lang,'sale_price'); ?>">
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label><?= print_lang($app_lang,'profit'); ?></label>
                            <input type="text" class="form-control pointer-none" name="_sold_profit" placeholder="<?= print_lang($app_lang,'profit'); ?>">
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label><?= print_lang($app_lang,'total_profit'); ?></label>
                            <input type="text" class="form-control pointer-none" name="_sold_total_profit" placeholder="<?= print_lang($app_lang,'total_profit'); ?>">
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label><?= print_lang($app_lang,'total'); ?></label>
                            <input type="text" class="form-control pointer-none" name="_sold_total" placeholder="<?= print_lang($app_lang,'total'); ?>">
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label><?= print_lang($app_lang,'discount'); ?></label>
                            <input type="text" class="form-control" name="_sold_discount" placeholder="<?= print_lang($app_lang,'discount'); ?>">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label><?= print_lang($app_lang,'gross_amount'); ?></label>
                            <input type="text" class="form-control pointer-none" name="_sold_gross_amount" placeholder="<?= print_lang($app_lang,'gross_amount'); ?>">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label><?= print_lang($app_lang,'cash'); ?></label>
                            <input type="text" class="form-control" name="_sold_cash" placeholder="<?= print_lang($app_lang,'cash'); ?>">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label><?= print_lang($app_lang,'cash_account'); ?></label>
                            <select class="form-control chosen-select" name="_sold_cash_account">
                                <option disabled="" selected="">-- <?= print_lang($app_lang,'account'); ?> --</option>
                                <?php foreach($accounts as $row){ ?>
                                <?php if($row['type'] == 'bank' OR $row['type'] == 'cashbook'){?>
                                    <option value="<?= $row['uid']; ?>"><?= $row['name']; ?></option>
                                <?php }} ?>
                            </select>
                        </div>
                    </div>
                </div>

            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-white" data-dismiss="modal"><?= print_lang($app_lang,'cancel'); ?></button>
                <button type="submit" class="btn btn-primary"><?= print_lang($app_lang,'save_sold_lot'); ?></button>
            </div>
            </form>
        </div>
    </div>
</div>






<div class="modal inmodal" id="lot-invoice-sale-modal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content animated flipInX">
            <form id="lot-invoice-sale-form" action="<?= url('/lot-purchase/avail-invoice/save'); ?>">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
                <h4 class="modal-title"><?= print_lang($app_lang,'lot_invoice_sold_title'); ?></h4>
                <small class="font-bold"><?= print_lang($app_lang,'lot_invoice_sold_tag_line'); ?></small>
            </div>
            <div class="modal-body bg-white">
                
                <div class="row">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label><?= print_lang($app_lang,'currency'); ?> <strong class="text-danger">*</strong></label>
                            <input type="hidden" name="invoice_parent_uid" value="">
                            <input type="hidden" name="invoice_child_uid" value="">
                            <input type="hidden" name="invoice_lot_tankers" value="">
                            <input type="hidden" name="invoice_lot_real_cost" value="">
                            <input type="hidden" name="invoice_lot_weight" value="">
                            <input type="hidden" name="invoice_lot_currency" value="">
                            <input type="hidden" name="invoice_lot_currency_usd_equalance" value="">
                            <select class="form-control chosen-select" name="_invoice_sold_currency">
                                <option disabled="" selected="">-- <?= print_lang($app_lang,'currency'); ?> --</option>
                                <?php foreach($currencies as $row){ ?>
                                    <option value="<?= $row['uid']; ?>" data-usd-equalance="<?= $row['usd_equalance']; ?>"><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                <?php } ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label><?= print_lang($app_lang,'client'); ?> <strong class="text-danger">*</strong></label>
                            <select class="form-control chosen-select" name="_invoice_sold_client">
                                <option disabled="" selected="">-- <?= print_lang($app_lang,'client'); ?> --</option>
                                <?php foreach($clients as $row){ ?>
                                    <option value="<?= $row['uid']; ?>"><?= $row['name']; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label><?= print_lang($app_lang,'invoice'); ?></label>
                            <select class="form-control chosen-select" name="_invoice_sold_invoice">
                                <option disabled="" selected="">-- <?= print_lang($app_lang,'invoice'); ?> --</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label><?= print_lang($app_lang,'weight'); ?></label>
                            <input type="text" class="form-control pointer-none" name="_invoice_sold_weight" placeholder="<?= print_lang($app_lang,'weight'); ?>">
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label><?= print_lang($app_lang,'sale_price'); ?> <strong class="text-danger">*</strong></label>
                            <input type="text" class="form-control" name="_invoice_sold_sale_price" placeholder="<?= print_lang($app_lang,'sale_price'); ?>">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label><?= print_lang($app_lang,'profit'); ?></label>
                            <input type="text" class="form-control pointer-none" name="_invoice_sold_profit" placeholder="<?= print_lang($app_lang,'profit'); ?>">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label><?= print_lang($app_lang,'total_profit'); ?></label>
                            <input type="text" class="form-control pointer-none" name="_invoice_sold_total_profit" placeholder="<?= print_lang($app_lang,'total_profit'); ?>">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label><?= print_lang($app_lang,'total'); ?></label>
                            <input type="text" class="form-control pointer-none" name="_invoice_sold_total" placeholder="<?= print_lang($app_lang,'total'); ?>">
                        </div>
                    </div>
                </div>

            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-white" data-dismiss="modal"><?= print_lang($app_lang,'cancel'); ?></button>
                <button type="submit" class="btn btn-primary"><?= print_lang($app_lang,'save_sold_lot'); ?></button>
            </div>
            </form>
        </div>
    </div>
</div>
<?php } ?>



<?php if(check_user_access('add_lot_moved') === TRUE){ ?>
<div class="modal inmodal" id="lot-move-modal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content animated flipInX">
            <form id="lot-move-form" action="<?= url('/lot-purchase/moved/save'); ?>">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
                <h4 class="modal-title"><?= print_lang($app_lang,'lot_moved_title'); ?></h4>
                <small class="font-bold"><?= print_lang($app_lang,'lot_moved_tag_line'); ?></small>
            </div>
            <div class="modal-body bg-white">
                
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label><?= print_lang($app_lang,'item'); ?> <strong class="text-danger">*</strong></label>
                            <input type="hidden" name="_move_parent_uid" value="">
                            <input type="hidden" name="_move_child_uid" value="">
                            <select class="form-control chosen-select" name="_move_item">
                                <option disabled="" selected="">-- <?= print_lang($app_lang,'select_item'); ?> --</option>
                                <?php foreach($items as $row){ ?>
                                    <option value="<?= $row['uid']; ?>" data-width="<?= $row['width']; ?>" data-height="<?= $row['height']; ?>" data-purchase-unit="<?= array_key_exists($row['purchase_unit'],$units) ? $units[$row['purchase_unit']]['name'] : NULL; ?>" data-sale-unit="<?= array_key_exists($row['sale_unit'],$units) ? $units[$row['sale_unit']]['name'] : NULL; ?>" data-production-unit="<?= array_key_exists($row['production_unit'],$units) ? $units[$row['production_unit']]['name'] : NULL; ?>" data-opt-type="<?= $row['type']; ?>"><?= $row['name'].', '.$row['item_id']; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label><?= print_lang($app_lang,'warehouse'); ?> <strong class="text-danger">*</strong></label>
                            <select class="form-control chosen-select" name="_move_warehouse">
                                <option disabled="" selected="" data-opt-type="default">-- <?= print_lang($app_lang,'select_warehouse'); ?> --</option>
                                <?php foreach($warehouse as $row){ ?>
                                    <option class="display-none" value="<?= $row['uid']; ?>" data-opt-type="<?= $row['type']; ?>"><?= $row['name']; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label><?= print_lang($app_lang,'unit'); ?> <strong class="text-danger">*</strong></label>
                            <select class="form-control chosen-select" name="_move_unit">
                                <option disabled="" selected="">-- <?= print_lang($app_lang,'unit'); ?> --</option>
                            </select>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label><?= print_lang($app_lang,'weight'); ?> <strong class="text-danger">*</strong></label>
                            <input type="text" class="form-control pointer-none" name="_move_weight" placeholder="<?= print_lang($app_lang,'weight'); ?>">
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="row">
                            <div class="col-md-7">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'difference'); ?></label>
                                    <select class="form-control chosen-select" name="_move_difference_type">
                                        <option value="plus" selected=""><?= print_lang($app_lang,'plus'); ?></option>
                                        <option value="minus"><?= print_lang($app_lang,'minus'); ?></option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-5">
                                <div class="form-group">
                                    <label style="opacity: 0; color: transparent;">-</label>
                                    <input type="text" class="form-control" name="_move_difference" placeholder="<?= print_lang($app_lang,'amount'); ?>">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label><?= print_lang($app_lang,'gross_weight'); ?></label>
                            <input type="text" class="form-control pointer-none" name="_move_gross_weight" placeholder="<?= print_lang($app_lang,'gross_weight'); ?>">
                        </div>
                    </div>
                </div>

            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-white" data-dismiss="modal"><?= print_lang($app_lang,'cancel'); ?></button>
                <button type="submit" class="btn btn-primary"><?= print_lang($app_lang,'move_lot'); ?></button>
            </div>
            </form>
        </div>
    </div>
</div>
<?php } ?>