<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-8">
        <h2><?= print_lang($app_lang,'moved_lots'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'moved_lots'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-4">
        
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'moved_lots_listing'); ?></h2>

                    <form id="lot-moved-search-form" action="<?= url('/lot-purchase/moved'); ?>">
                    <div class="row">
                        <div class="col-md-9">
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <div class="input-group date">
                                            <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                            <select class="form-control chosen-select" name="currency">
                                                <option value="" selected="">-- <?= print_lang($app_lang,'currency'); ?> --</option>
                                                <?php foreach($currencies as $row){ ?>
                                                    <option value="<?= $row['uid']; ?>" <?php if($search_currency == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <div class="input-group date">
                                            <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                            <select class="form-control chosen-select" name="supplier">
                                                <option value="" selected="">-- <?= print_lang($app_lang,'supplier'); ?> --</option>
                                                <?php foreach($suppliers as $row){ ?>
                                                    <option value="<?= $row['uid']; ?>" <?php if($search_supplier == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($search_from); ?>" name="from" placeholder="<?= print_lang($app_lang,'from'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="from" value="<?= true_date_for_inputs($search_from); ?>">
                                        <?php } ?>
                                    </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($search_to); ?>" name="to" placeholder="<?= print_lang($app_lang,'to'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="to" value="<?= true_date_for_inputs($search_to); ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3 text-right">
                            <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                            <a href="#" data-date="<?= display_true_date(date('Y-m-d')); ?>" class="today-date-form-trigger btn btn-primary custom-font-btn-search"><?= print_lang($app_lang,'today'); ?></a>
                        </div>
                    </div>
                    </form>
                    <hr>

                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center" style="width: 40px; min-width: 40px;"><?= print_lang($app_lang,'sr_#'); ?></th>
                                    <th class="text-center" style="width: 100px; min-width: 100px;"><?= print_lang($app_lang,'email_image'); ?></th>
                                    <th class="text-center" style="width: 80px; min-width: 80px;"><?= print_lang($app_lang,'purchased_invoice_num'); ?></th>
                                    <th class="text-center" style="width: 110px; min-width: 110px;"><?= print_lang($app_lang,'purchased_date'); ?></th>
                                    <th class="text-center" style="width: 100px; min-width: 100px;"><?= print_lang($app_lang,'supplier'); ?></th>
                                    <th class="text-center" style="width: 80px; min-width: 80px;"><?= print_lang($app_lang,'fuel_type'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'driver'); ?></th>
                                    <th class="text-center" style="width: 70px; min-width: 70px;"><?= print_lang($app_lang,'plate_num'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mobile'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'cmr'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'transit'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'weight'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'weight_plus'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'weight_minus'); ?></th>
                                    <th class="text-center" style="width: 60px; min-width: 60px;"><?= print_lang($app_lang,'weight_lose'); ?></th>
                                    <th class="text-center" style="width: 100px; min-width: 100px;"><?= print_lang($app_lang,'gross_weight'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'cost'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'rent'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'expenses'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'real_cost'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $total_weight = array();
                                $total_weight_plus = array();
                                $total_weight_minus = array();
                                $total_weight_loss = array();
                                $total_weight_gross = array();
                                $total_cost = array();
                                $total_rent = array();
                                $total_expenses = array();
                                $total_real_cost = array();
                                ?>
                                <?php
                                $i = 1; 
                                foreach($pageData as $_move_lot){

                                    // if lot data not found | skip
                                    if(!array_key_exists($_move_lot['lot_id'], $lots)){ continue; }

                                    $lot_p_data = $lots[$_move_lot['lot_id']];

                                    // currency and supplier filter
                                    if(!empty($search_currency)){ if($search_currency != $lot_p_data['currency']){ continue; } }
                                    if(!empty($search_supplier)){ if($search_supplier != $lot_p_data['supplier']){ continue; } }

                                    if($lot_p_data['purchase_type'] == 'iran_to_border')
                                    {
                                        $lot_c_data = json_decode($lot_p_data['division_list'],true);
                                    }
                                    else
                                    {
                                        $lot_c_data = json_decode($lot_p_data['lot_list'],true);
                                    }
                                    
                                    $moved_lot_data = array();
                                    $moved_lot_data_found = false;
                                    foreach($lot_c_data as $c_row)
                                    {
                                        if($_move_lot['lot_child_id'] == $c_row['uid'])
                                        {
                                            $moved_lot_data = $c_row;
                                            $moved_lot_data_found = true;
                                        }
                                    }
                                    // if data not found | skip row
                                    if($moved_lot_data_found === false){ continue; }

                                    $image_path = '/uploads/screenshots/'.$lot_p_data['email_attachment'];
                                    if(is_file(base_path().$image_path))
                                    {
                                        $image_html = '<a data-gallery="" class="btn btn-primary btn-xs" target="_blank" href="'.url('/').$image_path.'">'.print_lang($app_lang,'preview').'</a>';
                                    }
                                    else
                                    {
                                        $image_html = '<span class="label label-info">'.print_lang($app_lang,'no_image').'</span>';
                                    }

                                ?>

                                <?php
                                $iran_to_afghanistan_invoice = url('/lot-purchase/invoice').'/'.$lot_p_data['uid'].'?type=iran_to_afghanistan';
                                $iran_to_border_invoice = NULL;
                                if($lot_p_data['purchase_type'] == 'iran_to_border')
                                {
                                    $iran_to_border_invoice_url = "'".url("/lot-purchase/invoice")."/".$lot_p_data["uid"]."?type=iran_to_border'";
                                    $iran_to_border_invoice = 'onclick="window.open('.$iran_to_border_invoice_url.');"';
                                }
                                ?>

                                    <tr class="text-center lotitem<?= $moved_lot_data['uid']; ?>">
                                        <td><?= $i++; ?></td>
                                        <td><?= $image_html; ?></td>
                                        <td><a target="_blank" href="<?= $iran_to_afghanistan_invoice; ?>" <?= $iran_to_border_invoice; ?>><?= $lot_p_data['receipt']; ?></a></td>
                                        <td><?= display_true_date($lot_p_data['lot_date']); ?></td>
                                        <td><?= array_key_exists($lot_p_data['supplier'], $suppliers) ? $suppliers[$lot_p_data['supplier']]['name'] : NULL; ?></td>
                                        <td><?= isset($moved_lot_data['fuel_type']) ? $moved_lot_data['fuel_type'] : NULL; ?></td>
                                        <td><?= $moved_lot_data['driver']; ?></td>
                                        <td><?= $moved_lot_data['plate']; ?></td>
                                        <td><?= $moved_lot_data['mobile']; ?></td>
                                        <td><?= $moved_lot_data['cmr']; ?></td>
                                        <td><?= array_key_exists($moved_lot_data['transit_account'], $transits) ? $transits[$moved_lot_data['transit_account']]['name'] : NULL; ?></td>
                                        <td><?= round_decimels_digits_3($moved_lot_data['weight']); $total_weight[] = $moved_lot_data['weight']; ?></td>
                                        <td><?= round_decimels_digits_3($moved_lot_data['weight_plus']); $total_weight_plus[] = $moved_lot_data['weight_plus']; ?></td>
                                        <td><?= round_decimels_digits_3($moved_lot_data['weight_minus']); $total_weight_minus[] = $moved_lot_data['weight_minus']; ?></td>
                                        <td><?= round_decimels_digits_3($moved_lot_data['weight_lose']); $total_weight_loss[] = $moved_lot_data['weight_lose']; ?></td>
                                        <td><?= round_decimels_digits_3($moved_lot_data['gross_weight']); $total_weight_gross[] = $moved_lot_data['gross_weight']; ?></td>
                                        <td><?= round_decimels_digits_3($moved_lot_data['cost']); $total_cost[] = $moved_lot_data['cost']; ?></td>
                                        <td><?= round_decimels_digits_3($moved_lot_data['rent']); $total_rent[] = $moved_lot_data['rent']; ?></td>
                                        <td><?= round_decimels_digits_3($moved_lot_data['expenses']); $total_expenses[] = $moved_lot_data['expenses']; ?></td>
                                        <td><?= round_decimels_digits_3($moved_lot_data['real_cost']); $total_real_cost[] = $moved_lot_data['real_cost']; ?></td>
                                        <td>
                                            <?php if(check_user_access('delete_lot_moved') === TRUE){ ?>
                                                <a href="<?= url('/lot-purchase/moved/delete').'/'.$_move_lot['uid']; ?>" class="btn btn-xs btn-outline btn-danger delete-btn-trigger" data-msg="You will not be able to revert this" data-mood="Delete"><i class="fa fa-trash"></i>&nbsp; <?= print_lang($app_lang,'delete'); ?></a>
                                            <?php } ?>
                                        </td>
                                    </tr>

                                <?php } ?>

                                <tr class="text-center">
                                    <td><?= $i++; ?></td>
                                    <td></td>
                                    <td><?= print_lang($app_lang,'total'); ?></td>
                                    <td><?= display_true_date(date('Y-m-d')); ?></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td><?= round_decimels_digits_3( array_sum($total_weight) ); ?></td>
                                    <td><?= round_decimels_digits_3( array_sum($total_weight_plus) ); ?></td>
                                    <td><?= round_decimels_digits_3( array_sum($total_weight_minus) ); ?></td>
                                    <td><?= round_decimels_digits_3( array_sum($total_weight_loss) ); ?></td>
                                    <td><?= round_decimels_digits_3( array_sum($total_weight_gross) ); ?></td>
                                    <td><?= round_decimels_digits_3( array_sum($total_cost) ); ?></td>
                                    <td><?= round_decimels_digits_3( array_sum($total_rent) ); ?></td>
                                    <td><?= round_decimels_digits_3( array_sum($total_expenses) ); ?></td>
                                    <td><?= round_decimels_digits_3( array_sum($total_real_cost) ); ?></td>
                                    <td></td>
                                </tr>

                            </tbody>
                        </table>    
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>