<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-8">
        <h2><?= print_lang($app_lang,'purchases_difference_report'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'purchases_difference_report'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-4">
        
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'purchases_difference_report_listing'); ?></h2>

                    <form id="lot-purchases-diff-report-search-form" action="<?= url('/lot-purchase/difference-report'); ?>">
                        <input type="hidden" name="type" value="<?= $purchase_type; ?>">
                        <input type="hidden" name="source" value="<?= $purchase_source; ?>">
                    <div class="row">
                        <div class="col-md-9">
                            <div class="row">
                                
                                <?php if($purchase_type == 'iran_to_border'){ ?>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <div class="input-group date">
                                                <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                                <select class="form-control chosen-select" name="currency">
                                                    <option value="" selected="">-- <?= print_lang($app_lang,'currency'); ?> --</option>
                                                    <?php foreach($currencies as $row){ ?>
                                                        <option value="<?= $row['uid']; ?>" <?php if($search_currency == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                                    <?php } ?>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <div class="form-group">
                                            <?php if($branch_calander == 'persian'){ ?>
                                                <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($search_from); ?>" name="from" placeholder="<?= print_lang($app_lang,'from'); ?>" readonly="" style="background: #fff;">
                                            <?php }else{ ?>
                                                <input type="date" class="form-control" name="from" value="<?= true_date_for_inputs($search_from); ?>">
                                            <?php } ?>
                                        </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <?php if($branch_calander == 'persian'){ ?>
                                                <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($search_to); ?>" name="to" placeholder="<?= print_lang($app_lang,'to'); ?>" readonly="" style="background: #fff;">
                                            <?php }else{ ?>
                                                <input type="date" class="form-control" name="to" value="<?= true_date_for_inputs($search_to); ?>">
                                            <?php } ?>
                                        </div>
                                    </div>
                                <?php }else{ ?>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <div class="input-group date">
                                                <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                                <select class="form-control chosen-select" name="currency">
                                                    <option value="" selected="">-- <?= print_lang($app_lang,'currency'); ?> --</option>
                                                    <?php foreach($currencies as $row){ ?>
                                                        <option value="<?= $row['uid']; ?>" <?php if($search_currency == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                                    <?php } ?>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <div class="input-group date">
                                                <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                                <select class="form-control chosen-select" name="supplier">
                                                    <option value="" selected="">-- <?= print_lang($app_lang,'supplier'); ?> --</option>
                                                    <?php foreach($suppliers as $row){ ?>
                                                        <option value="<?= $row['uid']; ?>" <?php if($search_supplier == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                                    <?php } ?>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <div class="form-group">
                                            <?php if($branch_calander == 'persian'){ ?>
                                                <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($search_from); ?>" name="from" placeholder="<?= print_lang($app_lang,'from'); ?>" readonly="" style="background: #fff;">
                                            <?php }else{ ?>
                                                <input type="date" class="form-control" name="from" value="<?= true_date_for_inputs($search_from); ?>">
                                            <?php } ?>
                                        </div>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <?php if($branch_calander == 'persian'){ ?>
                                                <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($search_to); ?>" name="to" placeholder="<?= print_lang($app_lang,'to'); ?>" readonly="" style="background: #fff;">
                                            <?php }else{ ?>
                                                <input type="date" class="form-control" name="to" value="<?= true_date_for_inputs($search_to); ?>">
                                            <?php } ?>
                                        </div>
                                    </div>
                                <?php } ?>
                                
                            </div>
                        </div>
                        <div class="col-md-3 text-right">
                            <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                            <a href="#" data-date="<?= display_true_date(date('Y-m-d')); ?>" class="today-date-form-trigger btn btn-primary custom-font-btn-search"><?= print_lang($app_lang,'today'); ?></a>
                        </div>
                    </div>
                    </form>
                    <hr>

                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center"><?= print_lang($app_lang,'sr_#'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'date'); ?></th>
                                    <?php if($purchase_type == 'iran_to_afghanistan'){ ?>
                                        <th class="text-center"><?= print_lang($app_lang,'supplier'); ?></th>
                                    <?php } ?>
                                    <th class="text-center"><?= print_lang($app_lang,'driver'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'cmr'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'invoice'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'cost'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'weight'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'weight_plus'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'weight_minus'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'gross_weight'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $i = 1;
                                $total_cost = array();
                                $total_weight = array();
                                $total_weight_plus = array();
                                $total_weight_minus = array();
                                $total_gross_weight = array();

                                foreach($pageData as $lot)
                                {
                                    $iran_to_afghanistan_invoice = url('/lot-purchase/invoice').'/'.$lot['uid'].'?type=iran_to_afghanistan';
                                    $iran_to_border_invoice = NULL;
                                    
                                    if($purchase_type == 'iran_to_border')
                                    {
                                        $iran_to_border_invoice_url = "'".url("/lot-purchase/invoice")."/".$lot["uid"]."?type=iran_to_border'";
                                        $iran_to_border_invoice = 'onclick="window.open('.$iran_to_border_invoice_url.');"';
                                        if($purchase_source == 'initial')
                                        {
                                            $lot_list = json_decode($lot['lot_list'],true);
                                        }
                                        else
                                        {
                                            $lot_list = json_decode($lot['division_list'],true);
                                        }
                                    }
                                    else
                                    {
                                        $lot_list = json_decode($lot['lot_list'],true);
                                    }
                                    foreach($lot_list as $list_item){

                                ?>

                                    <tr class="text-center">
                                        <td><?= $i++; ?></td>
                                        <td><?= display_true_date($lot['lot_date']); ?></td>
                                        <?php if($purchase_type == 'iran_to_afghanistan'){ ?>
                                            <td><?= array_key_exists($lot['supplier'], $suppliers) ? $suppliers[$lot['supplier']]['name'] : NULL; ?></td>
                                        <?php } ?>
                                        <td><?= $list_item['driver']; ?></td>
                                        <td><?= $list_item['cmr']; ?></td>
                                        <td><a target="_blank" href="<?= $iran_to_afghanistan_invoice; ?>" <?= $iran_to_border_invoice; ?>><?= $lot['receipt']; ?></a></td>
                                       
                                        <td><?= round_decimels_digits_3($list_item['cost']); $total_cost[] = $list_item['cost']; ?></td>
                                        <td><?= $list_item['weight']; $total_weight[] = $list_item['weight']; ?></td>
                                        <td><?= $list_item['weight_plus']; $total_weight_plus[] = $list_item['weight_plus']; ?></td>
                                        <td><?= $list_item['weight_minus']; $total_weight_minus[] = $list_item['weight_minus']; ?></td>
                                        <td><?= $list_item['gross_weight']; $total_gross_weight[] = $list_item['gross_weight']; ?></td>
                                    </tr>

                                <?php } } ?>

                                <tr class="text-center">
                                    <td><?= $i++; ?></td>
                                    <td><?= display_true_date(date('Y-m-d')); ?></td>
                                    <?php if($purchase_type == 'iran_to_afghanistan'){ ?>
                                        <td>---</td>
                                    <?php } ?>
                                    <td>---</td>
                                    <td>---</td>
                                    <td><?= print_lang($app_lang,'total'); ?></td>

                                    <td><?= round_decimels_digits_3( array_sum( $total_cost ) ); ?></td>
                                    <td><?= round_decimels_digits_3( array_sum( $total_weight ) ); ?></td>
                                    <td><?= round_decimels_digits_3( array_sum( $total_weight_plus ) ); ?></td>
                                    <td><?= round_decimels_digits_3( array_sum( $total_weight_minus ) ); ?></td>
                                    <td><?= round_decimels_digits_3( array_sum( $total_gross_weight ) ); ?></td>
                                </tr>

                            </tbody>
                        </table>    
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>