<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-8">
        <h2><?= print_lang($app_lang,'lot_purchase'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'lot_purchase'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-4">
        <div class="title-action">
            <?php if(check_user_access('add_lot_purchase') === TRUE){ ?>
                <a href="<?= url('/lot-purchase/add'); ?>" class="btn btn-primary btn-sm custom-font-btn"><i class="fa fa-plus"></i>&nbsp; <?= print_lang($app_lang,'new_lot_purchase'); ?></a>
            <?php } ?>
        </div>
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'lot_purchases_listing'); ?></h2>

                    <form id="purchases-search-form" action="<?= url('/lot-purchase'); ?>">
                    <div class="row">
                        <div class="col-md-9">
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <div class="input-group date">
                                            <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                            <select class="form-control chosen-select" name="currency">
                                                <option value="" selected="">-- <?= print_lang($app_lang,'currency'); ?> --</option>
                                                <?php foreach($currencies as $row){ ?>
                                                    <option value="<?= $row['uid']; ?>" <?php if($search_currency == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <div class="input-group date">
                                            <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                            <select class="form-control chosen-select" name="supplier">
                                                <option value="" selected="">-- <?= print_lang($app_lang,'supplier'); ?> --</option>
                                                <?php foreach($suppliers as $row){ ?>
                                                    <option value="<?= $row['uid']; ?>" <?php if($search_supplier == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($search_from); ?>" name="from" placeholder="<?= print_lang($app_lang,'from'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="from" value="<?= true_date_for_inputs($search_from); ?>">
                                        <?php } ?>
                                    </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($search_to); ?>" name="to" placeholder="<?= print_lang($app_lang,'to'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="to" value="<?= true_date_for_inputs($search_to); ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3 text-right">
                            <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                            <a href="#" data-date="<?= display_true_date(date('Y-m-d')); ?>" class="today-date-form-trigger btn btn-primary custom-font-btn-search"><?= print_lang($app_lang,'today'); ?></a>
                        </div>
                    </div>
                    </form>
                    <hr>

                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center"><?= print_lang($app_lang,'sr_#'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'date'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'receipt_num'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'supplier'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'email_image'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'currency'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'weight'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'weight_lose'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'cost'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'rent'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'expenses'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'total_real_cost'); ?></th>
                                    <th class="text-center" style="min-width:190px; max-width:190px;"><?= print_lang($app_lang,'action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $total_weight = array();
                                $total_weight_lose = array();
                                $total_cost = array();
                                $total_rent = array();
                                $total_expenses = array();
                                $total_real_cost = array();
                                ?>
                                <?php $i = 1; foreach($pageData as $row){ ?>

                                    <?php

                                    // calculate weight lose
                                    $weight_lose = array();
                                    if($row['purchase_type'] == 'iran_to_border')
                                    {
                                        // division
                                        $lot_list = json_decode($row['division_list'],true);
                                    }
                                    else
                                    {
                                        $lot_list = json_decode($row['lot_list'],true);
                                    }

                                    foreach($lot_list as $child_row)
                                    {
                                        if(isset($child_row['weight_lose']))
                                        {
                                            $weight_lose[] = $child_row['weight_lose'];
                                        }
                                    }

                                    $weight_lose = array_sum($weight_lose);
                                    // --------------------------------------------

                                    $image_path = '/uploads/screenshots/'.$row['email_attachment'];
                                    if(is_file(base_path().$image_path))
                                    {
                                        $image_html = '<a class="btn btn-primary btn-xs" target="_blank" href="'.url('/').$image_path.'">'.print_lang($app_lang,'preview').'</a>'; // data-gallery=""
                                    }
                                    else
                                    {
                                        $image_html = '<span class="label label-info">'.print_lang($app_lang,'no_image').'</span>';
                                    }

                                    ?>

                                    <tr class="text-center">
                                        <td><?= $i++; ?></td>
                                        <td><?= display_true_date($row['lot_date']); ?></td>
                                        <td><?= $row['receipt']; ?></td>
                                        <td><?= array_key_exists($row['supplier'], $suppliers) ? $suppliers[$row['supplier']]['name'] : NULL; ?></td>
                                        <td><?= $image_html; ?></td>
                                        <td><?= array_key_exists($row['currency'], $currencies) ? $currencies[$row['currency']]['name'] : NULL; ?></td>

                                        <td><?= $row['total_weight']; $total_weight[] = (float)$row['total_weight']; ?></td>
                                        <td><?= $weight_lose; $total_weight_lose[] = $weight_lose; ?></td>
                                        <td><?= round_decimels_digits_3($row['total_cost']); $total_cost[] = (float)$row['total_cost']; ?></td>
                                        <td><?= round_decimels_digits_3($row['total_rent']); $total_rent[] = (float)$row['total_rent']; ?></td>
                                        <td><?= round_decimels_digits_3($row['total_expenses']); $total_expenses[] = (float)$row['total_expenses']; ?></td>
                                        <td><?= round_decimels_digits_3($row['total_real_cost']); $total_real_cost[] = (float)$row['total_real_cost']; ?></td>

                                        <?php
                                        $iran_to_afghanistan_invoice = url('/lot-purchase/invoice').'/'.$row['uid'].'?type=iran_to_afghanistan';
                                        $iran_to_border_invoice = NULL;
                                        if($row['purchase_type'] == 'iran_to_border')
                                        {
                                            $iran_to_border_invoice_url = "'".url("/lot-purchase/invoice")."/".$row["uid"]."?type=iran_to_border'";
                                            $iran_to_border_invoice = 'onclick="window.open('.$iran_to_border_invoice_url.');"';
                                        }
                                        ?>

                                        <td>
                                            <?php if(check_user_access('add_lot_purchase') === TRUE){ ?>
                                                <a href="<?= $iran_to_afghanistan_invoice; ?>" target="_blank" <?= $iran_to_border_invoice; ?> class="btn btn-xs btn-outline btn-warning url-elem"><i class="fa fa-external-link">&nbsp; </i><?= print_lang($app_lang,'invoice'); ?></a>
                                            <?php } ?>
                                            <?php if(check_user_access('edit_lot_purchase') === TRUE){ ?>
                                                <a href="<?= url('/lot-purchase/edit').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-primary url-elem"><i class="fa fa-pencil">&nbsp; </i><?= print_lang($app_lang,'edit'); ?></a>
                                            <?php } ?>
                                            <?php if(check_user_access('delete_lot_purchase') === TRUE){ ?>
                                                <a href="<?= url('/lot-purchase/delete').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-danger show-lot-note delete-btn-trigger" data-msg="You will not be able to revert this" data-mood="Delete"><i class="fa fa-trash"></i>&nbsp; <?= print_lang($app_lang,'delete'); ?></a>
                                            <?php } ?>
                                        </td>
                                    </tr>
                                <?php } ?>
                                <tr class="text-center">
                                    <td><?= $i++; ?></td>
                                    <td><?= display_true_date(date('Y-m-d')); ?></td>
                                    <td><?= print_lang($app_lang,'total'); ?></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td><?= round_decimels_digits_3(array_sum($total_weight)); ?></td>
                                    <td><?= round_decimels_digits_3(array_sum($total_weight_lose)); ?></td>
                                    <td><?= round_decimels_digits_3(array_sum($total_cost)); ?></td>
                                    <td><?= round_decimels_digits_3(array_sum($total_rent)); ?></td>
                                    <td><?= round_decimels_digits_3(array_sum($total_expenses)); ?></td>
                                    <td><?= round_decimels_digits_3(array_sum($total_real_cost)); ?></td>
                                    <td>---</td>
                                </tr>
                            </tbody>
                        </table>    
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>