<style>
    .pagination {
        margin: 0 !important;
    }
</style>

<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-8">
        <h2><?= print_lang($app_lang,'marketers_view_breadcrumb'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'marketers_view_breadcrumb'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-4">
        <div class="title-action">
            <?php if(check_user_access('add_marketers') === TRUE){ ?>
                <a href="<?= url('/marketers/add'); ?>" class="btn btn-primary btn-sm custom-font-btn"><i class="fa fa-plus"></i>&nbsp; <?= print_lang($app_lang,'marketers_view_add_btn'); ?></a>
            <?php } ?>
        </div>
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <!-- spinner -->
                    <div class="sk-spinner sk-spinner-three-bounce">
                        <div class="sk-bounce1"></div>
                        <div class="sk-bounce2"></div>
                        <div class="sk-bounce3"></div>
                    </div>
                    <!-- spinner -->

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'marketers_view_title'); ?></h2>
                    <hr>

                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center"><?= print_lang($app_lang,'marketers_view_thead_sr'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'marketers_view_thead_name'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'marketers_view_thead_last_name'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'marketers_view_thead_mobile'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'marketers_view_thead_email'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'marketers_view_thead_username'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'marketers_view_thead_report'); ?></th>
                                    <th class="text-center" style="min-width: 120px; max-width:120px;"><?= print_lang($app_lang,'marketers_view_thead_action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                
                                <?php $i = 1; foreach($pageData as $row){ ?>
                                    <tr class="text-center">
                                        <td><?= $i++; ?></td>
                                        <td><?= $row['name']; ?></td>
                                        <td><?= $row['last_name']; ?></td>
                                        <td><?= $row['mobile']; ?></td>
                                        <td><?= $row['email']; ?></td>
                                        <td><?= $row['username']; ?></td>
                                        <td>
                                            <?php if(check_user_access('report_marketers') === TRUE){ ?>
                                                <a href="<?php echo url('/reports/marketers').'?marketer='.$row['uid']; ?>" class="btn btn-xs btn-outline btn-warning url-elem"><i class="fa fa-eye"></i></a>
                                            <?php } ?>
                                        </td>
                                        <td>
                                            <?php if(check_user_access('edit_marketers') === TRUE){ ?>
                                                <a href="<?= url('/marketers/edit').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-primary url-elem"><i class="fa fa-pencil"></i></a>
                                            <?php } ?>
                                            <?php if(check_user_access('delete_marketers') === TRUE){ ?>
                                                <a href="<?= url('/marketers/delete').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-danger delete-btn-trigger"><i class="fa fa-trash"></i></a>
                                            <?php } ?>
                                        </td>
                                    </tr>
                                <?php } ?>
                            </tbody>
                        </table>    
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>