
<style type="text/css">
    .blink_me {
      animation: blinker 1.5s linear infinite;
    }

    @keyframes blinker {
      50% {
        opacity: 0;
      }
</style>

<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-8">
        <h2><?= print_lang($app_lang,'mod_metu_stock_report_view_title'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'mod_metu_stock_report_view_title'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-4">
        
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">


    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <form id="metu-report-search-form" action="<?= url('/metu/report'); ?>">
                        <div class="row">

                            <div class="col-md-10">
                                <div class="row">
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label><?= print_lang($app_lang,'mod_metu_stock_report_view_filter_metu'); ?></label>
                                            <select class="form-control chosen-select" name="metu">
                                                <option value="" selected="">-- <?= print_lang($app_lang,'mod_metu_stock_report_view_filter_metu'); ?> --</option>
                                                <?php foreach($metu as $row){ ?>
                                                    <option value="<?= $row['uid']; ?>" <?php if($search_metu == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <div class="form-group">
                                                <label><?= print_lang($app_lang,'mod_metu_stock_report_view_filter_from'); ?></label>
                                            <?php if($branch_calander == 'persian'){ ?>
                                                <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($search_from); ?>" name="from" placeholder="<?= print_lang($app_lang,'from'); ?>" readonly="" style="background: #fff;">
                                            <?php }else{ ?>
                                                <input type="date" class="form-control" name="from" value="<?= true_date_for_inputs($search_from); ?>">
                                            <?php } ?>
                                        </div>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label><?= print_lang($app_lang,'mod_metu_stock_report_view_filter_to'); ?></label>
                                            <?php if($branch_calander == 'persian'){ ?>
                                                <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($search_to); ?>" name="to" placeholder="<?= print_lang($app_lang,'to'); ?>" readonly="" style="background: #fff;">
                                            <?php }else{ ?>
                                                <input type="date" class="form-control" name="to" value="<?= true_date_for_inputs($search_to); ?>">
                                            <?php } ?>
                                        </div>
                                    </div>

                                    <div class="col-md-3 text-right" style="margin-top: 23px;">
                                        <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'mod_metu_stock_report_view_filter_search'); ?></button>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-2" style="margin-top: 23px;">
                                <span style="font-size: 15px; font-weight: 700; color: #000;"><?= print_lang($app_lang,'mod_metu_stock_report_view_available_stock'); ?></span>
                                <br>
                                <span class="blink_me" style="font-size: 15px; font-weight: 700; color: red;"><?= amount_number_format($metu_available_amount); ?></span>
                            </div>
                        </div>
                    </form>

                </div>
            </div>
        </div>
    </div>


    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center" style="min-width:50px; max-width:50px; width:50px;"><?= print_lang($app_lang,'mod_metu_stock_report_view_thead_sr'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_metu_stock_report_view_thead_date'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_metu_stock_report_view_thead_details'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_metu_stock_report_view_thead_profit'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_metu_stock_report_view_thead_debit'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_metu_stock_report_view_thead_credit'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_metu_stock_report_view_thead_balance'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php 
                                $i = 1; 
                                $debits = [];
                                $credits = [];
                                $profits = [];
                                foreach($pageData as $row){
                                    $debits[] = (float)$row['debit'];
                                    $credits[] = (float)$row['credit'];
                                    $profits[] = (float)$row['profit'];
                                ?>
                                    <tr class="text-center">
                                        <td><?= $i++; ?></td>
                                        <td><?= display_true_date(explode(' ',$row['created_at'])[0]); ?></td>
                                        <td><?= $row['details']; ?></td>
                                        <td><?= amount_number_format($row['profit']); ?></td>
                                        <td><?= amount_number_format($row['debit']); ?></td>
                                        <td><?= amount_number_format($row['credit']); ?></td>
                                        <td><?= amount_number_format(array_sum($debits) - array_sum($credits)); ?></td>
                                    </tr>
                                <?php } ?>
                                    <tr class="text-center">
                                        <td><?= $i++; ?></td>
                                        <td><?= print_lang($app_lang,'total'); ?></td>
                                        <td></td>
                                        <td><?= amount_number_format(array_sum($profits)); ?></td>
                                        <td><?= amount_number_format(array_sum($debits)); ?></td>
                                        <td><?= amount_number_format(array_sum($credits)); ?></td>
                                        <td><?= amount_number_format(array_sum($debits) - array_sum($credits)); ?></td>
                                    </tr>
                            </tbody>
                        </table>    
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>