<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-8">
        <h2><?= print_lang($app_lang,'mod_metu_stock_sale_view_breadcrumb'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'mod_metu_stock_sale_view_title'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-4">
        <div class="title-action">
            <?php if(check_user_access('add_metu_sales_right') === TRUE){ ?>
                <a href="<?php echo url('/metu-sales/add'); ?>" class="btn btn-primary btn-sm custom-font-btn"><i class="fa fa-plus"></i>&nbsp; <?= print_lang($app_lang,'mod_metu_stock_sale_view_add_btn'); ?></a>
            <?php } ?>
        </div>
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">

    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <form id="metu-sales-search-form" action="<?= url('/metu-sales'); ?>">
                        <div class="row">
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'mod_metu_stock_sale_view_filter_client'); ?></label>
                                    <select class="form-control chosen-select" name="client">
                                        <option value="" selected="">-- <?= print_lang($app_lang,'mod_metu_stock_sale_view_filter_client'); ?> --</option>
                                        <?php foreach($clients as $row){ ?>
                                            <option value="<?= $row['uid']; ?>" <?php if($search_client == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                        <?php } ?>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'mod_metu_stock_sale_view_filter_from'); ?></label>
                                    <?php if($branch_calander == 'persian'){ ?>
                                        <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($search_from); ?>" name="from" placeholder="<?= print_lang($app_lang,'from'); ?>" readonly="" style="background: #fff;">
                                    <?php }else{ ?>
                                        <input type="date" class="form-control" name="from" value="<?= true_date_for_inputs($search_from); ?>">
                                    <?php } ?>
                                </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'mod_metu_stock_sale_view_filter_to'); ?></label>
                                    <?php if($branch_calander == 'persian'){ ?>
                                        <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($search_to); ?>" name="to" placeholder="<?= print_lang($app_lang,'to'); ?>" readonly="" style="background: #fff;">
                                    <?php }else{ ?>
                                        <input type="date" class="form-control" name="to" value="<?= true_date_for_inputs($search_to); ?>">
                                    <?php } ?>
                                </div>
                            </div>

                            <div class="col-md-3 text-right" style="margin-top: 23px;">
                                <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'mod_metu_stock_sale_view_filter_search'); ?></button>
                            </div>
                        </div>
                    </form>

                </div>
            </div>
        </div>
    </div>



    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center" style="min-width:50px; max-width:50px; width:50px;"><?= print_lang($app_lang,'mod_metu_stock_sale_view_thead_sr'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_metu_stock_sale_view_thead_date'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_metu_stock_sale_view_thead_client'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_metu_stock_sale_view_thead_value'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_metu_stock_sale_view_thead_percentage'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_metu_stock_sale_view_thead_metu'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_metu_stock_sale_view_thead_details'); ?></th>
                                    <th class="text-center" style="min-width:120px; max-width:120px; width:120px;"><?= print_lang($app_lang,'mod_metu_stock_metu_view_thead_action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $i = 1; foreach($pageData as $row){ ?>
                                    <tr class="text-center">
                                        <td><?= $i++; ?></td>
                                        <td><?= display_true_date(explode(' ',$row['created_at'])[0]); ?></td>
                                        <td><?= $row['client_name']; ?></td>
                                        <td><?= $row['currency_symbol'].' '.$row['value']; ?></td>
                                        <td><?= $row['currency_symbol'].' '.$row['percentage']; ?></td>
                                        <td><?= $row['currency_symbol'].' '.$row['total']; ?></td>
                                        <td><?= $row['details']; ?></td>
                                        <td>
                                            <?php if(check_user_access('edit_metu_sales_right') === TRUE){ ?>
                                                <a href="<?= url('/metu-sales/edit').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-primary url-elem"><i class="fa fa-pencil">&nbsp; </i><?= print_lang($app_lang,'edit'); ?></a>
                                            <?php } ?>
                                            <?php if(check_user_access('delete_metu_sales_right') === TRUE){ ?>
                                                <a href="<?= url('/metu-sales/delete').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-danger delete-btn-trigger" data-msg="You will not be able to revert this" data-mood="Delete"><i class="fa fa-trash"></i>&nbsp; <?= print_lang($app_lang,'delete'); ?></a>
                                            <?php } ?>
                                        </td>
                                    </tr>
                                <?php } ?>
                            </tbody>
                        </table>    
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>