<div id="confirm_msg_div" class="row wrapper border-bottom white-bg page-heading confirm-leave">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'mod_production_new_add_view'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/new-production'); ?>"><?= print_lang($app_lang,'mod_production_new_add_view'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'mod_production_new_edit_breadcrumb'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="ibox-title">
        <h5><?= print_lang($app_lang,'fields_with'); ?> <strong class="text-danger">*</strong> <?= print_lang($app_lang,'are_mandatory'); ?></h5>

        <div class="text-<?php if($app_direction == 'rtl'){echo 'left';}else{echo 'right';} ?>">
            <input style="width: 100px; border: none; background: #e0e0e0; padding: 9px 5px; text-align: center; border-radius: 2px; color: black;" type="text" class="pointer-none" value="<?= print_lang($app_lang,'add_entry_sr_num').' '.$editing_data['serial_id']; ?>" readonly="">
        </div>
    </div>
    <div class="ibox-content">
        <!-- spinner -->
        <div class="sk-spinner sk-spinner-three-bounce">
            <div class="sk-bounce1"></div>
            <div class="sk-bounce2"></div>
            <div class="sk-bounce3"></div>
        </div>
        <!-- spinner -->

        <form id="new-production-form" action="<?= url('new-production/update').'/'.$editing_data['uid']; ?>">
            <div class="row">
                <div class="col-md-3 pointer-none">
                    <div class="form-group">
                        <label><?= print_lang($app_lang,'mod_production_new_add_input_currency'); ?> <strong class="text-danger">*</strong></label>
                        <select class="form-control chosen-select cv-required new-production-currency" name="currency">
                            <option disabled="" value="" selected="">-- <?= print_lang($app_lang,'mod_production_new_add_input_currency'); ?> --</option>
                            <?php foreach($currencies as $row){ ?>
                                <option <?php if($editing_data['currency'] == $row['uid']){echo "selected='selected'";}?> value="<?= $row['uid']; ?>"><?= $row['name']; ?></option>
                            <?php } ?>
                        </select>
                    </div>
                </div>
                <div class="col-md-3 pointer-none">
                    <div class="form-group">
                        <label><?= print_lang($app_lang,'mod_production_new_add_input_formula'); ?> <strong class="text-danger">*</strong></label>
                        <select class="form-control chosen-select cv-required new-production-formula" name="formula">
                            <option disabled="" value="" selected="">-- <?= print_lang($app_lang,'mod_production_new_add_input_formula'); ?> --</option>
                            <?php foreach($items_formula as $row){ ?>
                                <option <?php if($editing_data['formula'] == $row['uid']){echo "selected='selected'";}?> value="<?= $row['uid']; ?>"><?= $row['name']; ?></option>
                            <?php } ?>
                        </select>
                    </div>
                </div>
                <div class="col-md-3 pointer-none">
                    <div class="form-group">
                        <label><?= print_lang($app_lang,'mod_production_new_add_input_item'); ?> <strong class="text-danger">*</strong></label>
                        <select class="form-control chosen-select cv-required production-item" name="item">
                            <option disabled="" value="" selected="">-- <?= print_lang($app_lang,'mod_production_new_add_input_item'); ?> --</option>
                            <?php foreach($branch_items as $row){ if($row['type'] == 'raw'){continue;} ?>
                                <option <?php if($editing_data['item'] == $row['uid']){echo "selected='selected'";}?> data-unit-name="<?= $row['purchase_unit_name']; ?>" value="<?= $row['uid']; ?>"><?= $row['name']; ?> (<?= $row['item_id']; ?>) (<?= $row['purchase_unit_name']; ?>)</option>
                            <?php } ?>
                        </select>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label><?= print_lang($app_lang,'mod_production_new_add_input_warehouse'); ?> <strong class="text-danger">*</strong></label>
                        <select class="form-control chosen-select cv-required production-warehouse" name="warehouse">
                            <option disabled="" selected="">-- <?= print_lang($app_lang,'mod_production_new_add_input_warehouse'); ?> --</option>
                            <?php foreach($warehouses as $row){ if($row['type'] == 'raw'){continue;} ?>
                                <option <?php if($editing_data['warehouse'] == $row['uid']){echo "selected='selected'";}?> value="<?= $row['uid']; ?>"><?= $row['name']; ?></option>
                            <?php } ?>
                        </select>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-4">
                    <div class="form-group">
                        <label><?= print_lang($app_lang,'mod_production_new_add_input_qty'); ?> <strong class="text-danger">*</strong></label>
                        <input type="text" class="form-control new-production-qty cv-required" value="<?= $editing_data['qty']; ?>" name="qty" placeholder="<?= print_lang($app_lang,'mod_production_new_add_input_qty'); ?>">
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label><?= print_lang($app_lang,'mod_production_new_add_input_weight'); ?> <strong class="text-danger">*</strong></label>
                        <input type="text" class="form-control new-production-weight cv-required" value="<?= $editing_data['weight']; ?>" name="weight" placeholder="<?= print_lang($app_lang,'mod_production_new_add_input_weight'); ?>">
                    </div>
                </div>
                <div class="col-md-4 pointer-none">
                    <div class="form-group">
                        <label><?= print_lang($app_lang,'mod_production_new_add_input_total_weight'); ?> <strong class="text-danger">*</strong></label>
                        <input type="text" class="form-control cv-required" name="total_weight" value="<?= $editing_data['total_weight']; ?>" placeholder="<?= print_lang($app_lang,'mod_production_new_add_input_total_weight'); ?>">
                    </div>
                </div>
            </div>

            <h4><?= print_lang($app_lang,'mod_production_new_add_input_raw_items'); ?></h4>
            <div class="row">
                <div class="col-md-3">
                    <label><?= print_lang($app_lang,'mod_production_new_add_input_raw_item'); ?> <strong class="text-danger">*</strong></label>
                </div>
                <div class="col-md-3">
                    <label><?= print_lang($app_lang,'mod_production_new_add_input_raw_warehouse'); ?> <strong class="text-danger">*</strong></label>
                </div>
                <div class="col-md-3">
                    <label><?= print_lang($app_lang,'mod_production_new_add_input_raw_qty'); ?> <strong class="text-danger">*</strong></label>
                </div>
                <div class="col-md-3">
                    <label><?= print_lang($app_lang,'mod_production_new_add_input_raw_cost'); ?> <strong class="text-danger">*</strong></label>
                </div>
            </div>

            <div class="new-production-formula-items-data">
                <?php foreach($editing_data_details as $drow){ if($drow['pro_type'] == 'produced'){continue;}
                    $item_data = fetch_table_where('items','uid',$drow['item'],true);
                    $item_stats = json_decode($item_data['stats'],true);
                    $item_warehouses = [];
                    if(!empty($item_stats['avail_units']))
                    {
                        foreach($item_stats['avail_units'] as $key => $iware)
                        {
                            $item_warehouses[] = $key;
                        }
                    }
                ?>
                    <div class="row new-production-formula-items-row">
                        <div class="col-md-3 pointer-none">
                            <div class="form-group">
                                <select class="form-control chosen-select cv-required" name="raw_item[]">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'mod_production_new_add_input_raw_item'); ?> --</option>
                                    <?php foreach($branch_items as $itrow){ if($itrow['type'] == 'sales'){continue;} ?>
                                        <option <?php if($drow['item'] == $itrow['uid']){echo "selected='selected'";}?> value="<?= $itrow['uid']; ?>"><?= $itrow['name']; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <select class="form-control chosen-select cv-required" name="raw_warehouse[]">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'mod_production_new_add_input_raw_warehouse'); ?> --</option>
                                    <?php foreach($warehouses as $irow){ if(!in_array($irow['uid'], $item_warehouses)){continue;} ?>
                                        <option <?php if($drow['warehouse'] == $irow['uid']){echo "selected='selected'";}?> value="<?= $irow['uid']; ?>"><?= $irow['name']; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3 pointer-none">
                            <div class="form-group">
                                <input type="text" class="form-control new-production-raw-item-qty cv-required" value="<?= $drow['qty']; ?>" name="raw_qty[]">
                            </div>
                        </div>
                        <div class="col-md-3 pointer-none">
                            <div class="form-group">
                                <input type="text" class="form-control new-production-raw-item-cost cv-required" value="<?= $drow['cost']; ?>" name="raw_cost[]">
                                <input type="hidden" class="form-control new-production-raw-item-percentage" value="<?= $drow['percentage']; ?>" name="raw_percentage[]">
                            </div>
                        </div>
                    </div>
                <?php } ?>
            </div>

            <div class="row">
                <div class="col-md-2 pointer-none">
                    <div class="form-group">
                        <label><?= print_lang($app_lang,'mod_production_new_add_input_system_expenses'); ?> <strong class="text-danger">*</strong></label>
                        <input type="text" class="form-control new-production-total-system-expenses" name="total_system_expenses" value="<?= $editing_data['system_expenses']; ?>" placeholder="<?= print_lang($app_lang,'mod_production_new_add_input_system_expenses'); ?>">
                    </div>
                </div>

                <div class="col-md-2">
                    <div class="form-group">
                        <label><?= print_lang($app_lang,'mod_production_new_add_input_used_expenses'); ?> </label>
                        <input type="text" class="form-control new-production-used-expenses" name="used_expenses" value="<?= $editing_data['used_expenses']; ?>" placeholder="<?= print_lang($app_lang,'mod_production_new_add_input_used_expenses'); ?>">
                    </div>
                </div>

                <div class="col-md-2 pointer-none">
                    <div class="form-group">
                        <label><?= print_lang($app_lang,'mod_production_new_add_input_total_cost'); ?> <strong class="text-danger">*</strong></label>
                        <input type="text" class="form-control new-production-total-cost cv-required" name="total_cost" value="<?= $editing_data['total_cost']; ?>" placeholder="<?= print_lang($app_lang,'mod_production_new_add_input_total_cost'); ?>">
                    </div>
                </div>

                <div class="col-md-3 pointer-none">
                    <div class="form-group">
                        <label><?= print_lang($app_lang,'mod_production_new_add_input_total_real_cost'); ?> <strong class="text-danger">*</strong></label>
                        <input type="text" class="form-control new-production-total-real-cost cv-required" name="total_real_cost" value="<?= $editing_data['total_real_cost']; ?>" placeholder="<?= print_lang($app_lang,'mod_production_new_add_input_total_real_cost'); ?>">
                    </div>
                </div>

                <div class="col-md-3 pointer-none">
                    <div class="form-group">
                        <label><?= print_lang($app_lang,'mod_production_new_add_input_per_item_cost'); ?> <strong class="text-danger">*</strong></label>
                        <input type="text" class="form-control new-production-per-item-produced-cost cv-required" name="per_item_cost" value="<?= $editing_data['per_item_cost']; ?>" placeholder="<?= print_lang($app_lang,'mod_production_new_add_input_per_item_cost'); ?>">
                    </div>
                </div>
            </div>

            <div class="row extra-mar-botm">
                <div class="col-md-12 text-right">
                    <a class="btn btn-w-m btn-outline btn-danger url-elem" href="<?php echo url('/new-production'); ?>"><?= print_lang($app_lang,'cancel'); ?></a>
                    <button class="btn btn-w-m btn-primary" type="submit"><?= print_lang($app_lang,'update'); ?></button>
                </div>
            </div>
        </form>

    </div>

</div>